/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.adapter;

import hep.graphics.heprep.HepRepAction;
import hep.graphics.heprep.HepRepAttributeAdapter;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepIterator;
import hep.graphics.heprep.util.HashMapList;
import hep.graphics.heprep.util.MapList;
import hep.graphics.heprep.xml.XMLHepRepReader;
import hep.graphics.heprep1.HepRep;
import hep.graphics.heprep1.adapter.HepRepAdapterFactory;
import hep.graphics.heprep1.adapter.NumericalComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HepRepAdapter
implements hep.graphics.heprep.HepRep {
    private MapList instanceTrees = new HashMapList();
    private MapList typeTrees = new HashMapList();
    private HepRepAdapterFactory factory = HepRepAdapterFactory.getFactory();
    List layerOrder;

    public HepRepAdapter(HepRep heprep1) {
        try {
            XMLHepRepReader.readDefaults();
        }
        catch (Exception e) {
            System.err.println("Warning: unable to read HepRep default attributes from XML");
        }
        HepRepTreeID id = this.factory.createHepRepTreeID("Types", "1.0");
        HepRepTypeTree typeTree = this.factory.createHepRepTypeTree(id);
        this.typeTrees.put(id, typeTree);
        HepRepType rootType = this.factory.createHepRepType(heprep1, null);
        typeTree.addType(rootType);
        HepRepInstanceTree instanceTree = this.factory.createHepRepInstanceTree("Instances", "1.0", id);
        this.instanceTrees.put(this.factory.createHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()), instanceTree);
        HepRepInstance rootInstance = this.factory.createHepRepInstance(heprep1, null, rootType);
        instanceTree.addInstance(rootInstance);
        Enumeration e = heprep1.getTypes();
        while (e.hasMoreElements()) {
            rootType.addType(this.factory.createHepRepType((hep.graphics.heprep1.HepRepType)e.nextElement(), rootType, rootInstance));
        }
    }

    @Override
    public void addLayer(String layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getLayerOrder() {
        if (this.layerOrder == null) {
            final HashSet set = new HashSet();
            DefaultHepRepIterator iterator = new DefaultHepRepIterator(this.getInstanceTreeList());
            iterator.addHepRepAttributeListener("Layer", new HepRepAttributeAdapter(){

                @Override
                public void setAttribute(HepRepInstance instance, String key, String value, String lowerCaseValue, int showLabel) {
                    set.add(value);
                }
            });
            while (iterator.hasNext()) {
                iterator.nextInstance();
            }
            this.layerOrder = new ArrayList(set);
            Collections.sort(this.layerOrder, new NumericalComparator());
        }
        return this.layerOrder;
    }

    @Override
    public void addTypeTree(HepRepTypeTree typeTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTypeTree(HepRepTypeTree typeTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set getTypeTrees() {
        return this.typeTrees.valueSet();
    }

    @Override
    public List getTypeTreeList() {
        return this.typeTrees.valueList();
    }

    @Override
    public HepRepTypeTree getTypeTree(String name, String version) {
        return (HepRepTypeTree)this.typeTrees.get(this.factory.createHepRepTreeID(name, version));
    }

    @Override
    public void addInstanceTree(HepRepInstanceTree instanceTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void overlayInstanceTree(HepRepInstanceTree instanceTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeInstanceTree(HepRepInstanceTree instanceTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set getInstanceTrees() {
        return this.instanceTrees.valueSet();
    }

    @Override
    public List getInstanceTreeList() {
        return this.instanceTrees.valueList();
    }

    @Override
    public HepRepInstanceTree getInstanceTreeTop(String name, String version) {
        return (HepRepInstanceTree)this.instanceTrees.get(this.factory.createHepRepTreeID(name, version));
    }

    @Override
    public HepRepInstanceTree getInstances(String name, String version, String[] typeNames) {
        return this.getInstanceTreeTop(name, version);
    }

    @Override
    public HepRepInstanceTree getInstancesAfterAction(String name, String version, String[] typeNames, HepRepAction[] actions, boolean getPoints, boolean getDrawAtts, boolean getNonDrawAtts, String[] invertAtts) {
        return this.getInstanceTreeTop(name, version);
    }

    @Override
    public String checkForException() {
        return "Not Implemented";
    }

    @Override
    public hep.graphics.heprep.HepRep copy() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public hep.graphics.heprep.HepRep copy(HepRepSelectFilter filter) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

