/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.xml;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepAction;
import hep.graphics.heprep.HepRepAttDef;
import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepAttribute;
import hep.graphics.heprep.HepRepDefinition;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.HepRepWriter;
import hep.graphics.heprep.util.HepRepUtil;
import hep.graphics.heprep.wbxml.BHepRepWriter;
import hep.graphics.heprep.xml.ASCIIHepRepWriter;
import hep.graphics.heprep.xml.XMLTagWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.freehep.util.io.NoCloseOutputStream;

public class XMLHepRepWriter
implements HepRepWriter {
    private static final String nameSpace = "heprep";
    private boolean bitEncoding;
    private OutputStream cos;
    private ZipOutputStream zip;
    private OutputStream out;
    private XMLTagWriter xml;
    private long fileNumber;
    protected Map properties;

    XMLHepRepWriter(OutputStream os, boolean randomAccess, boolean compress) throws IOException {
        if (randomAccess) {
            this.zip = new ZipOutputStream(os);
            this.zip.setMethod(compress ? 8 : 0);
            this.cos = this.zip;
        } else {
            this.cos = compress ? new GZIPOutputStream(os) : os;
        }
        this.out = new NoCloseOutputStream(this.cos);
        this.bitEncoding = false;
        this.properties = new HashMap();
        this.fileNumber = 1L;
    }

    public void setBitEncoding(boolean bitEncoding) {
        this.bitEncoding = bitEncoding;
        if (bitEncoding) {
            System.err.println("setBitEncoding is deprecated, use binary heprep files instead.");
        }
    }

    @Override
    public void addProperty(String key, String value) throws IOException {
        this.properties.put(key, value);
    }

    @Override
    public void close() throws IOException {
        if (this.zip != null) {
            this.zip.putNextEntry(new ZipEntry("heprep.properties"));
            PrintStream ps = new PrintStream(this.zip);
            for (String key : this.properties.keySet()) {
                ps.println(key + "=" + (String)this.properties.get(key));
            }
            this.zip.closeEntry();
            this.zip.close();
        }
        this.cos.close();
    }

    public void write(Object object) throws IOException {
        if (object instanceof HepRep) {
            this.write((HepRep)object, "File-" + this.fileNumber + ".bheprep");
            ++this.fileNumber;
        } else if (object instanceof HepRepTreeID) {
            this.write((HepRepTreeID)object);
        } else if (object instanceof List) {
            this.write((List)object);
        } else if (object instanceof HepRepAction) {
            this.write((HepRepAction)object);
        } else if (object instanceof HepRepTypeTree) {
            this.write((HepRepTypeTree)object);
        } else if (object instanceof HepRepType) {
            this.write((HepRepType)object);
        } else if (object instanceof HepRepInstanceTree) {
            this.write((HepRepInstanceTree)object);
        } else if (object instanceof HepRepInstance) {
            this.write((HepRepInstance)object);
        } else if (object instanceof HepRepPoint) {
            this.write((HepRepPoint)object);
        } else {
            System.err.println("XMLHepRepWriter: do not know how to write object of type: " + object.getClass());
        }
    }

    @Override
    public void write(HepRep heprep, String name) throws IOException {
        if (this.zip != null) {
            this.zip.putNextEntry(new ZipEntry(name));
        }
        if (name.endsWith(".bheprep")) {
            this.xml = new BHepRepWriter(new BufferedOutputStream(this.out));
            this.bitEncoding = false;
        } else {
            this.xml = new ASCIIHepRepWriter(new BufferedWriter(new OutputStreamWriter(this.out)), "  ", nameSpace);
        }
        this.xml.openDoc();
        this.xml.setAttribute("version", "2.0");
        String schemaLocation = "http://java.freehep.org/schemas/heprep/2.0";
        this.xml.setAttribute("xmlns", schemaLocation);
        this.xml.setAttribute("xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xml.setAttribute("xsi", "schemaLocation", schemaLocation + " " + schemaLocation + "/HepRep.xsd");
        this.xml.openTag(nameSpace, nameSpace);
        this.write(heprep.getLayerOrder());
        Iterator i = heprep.getTypeTreeList().iterator();
        while (i.hasNext()) {
            this.write((HepRepTypeTree)i.next());
        }
        i = heprep.getInstanceTreeList().iterator();
        while (i.hasNext()) {
            this.write((HepRepInstanceTree)i.next());
        }
        this.xml.closeTag();
        this.xml.closeDoc();
        this.xml.close();
        if (this.zip != null) {
            this.zip.closeEntry();
        }
    }

    @Override
    public void write(List layers) throws IOException {
        StringBuffer layerOrder = new StringBuffer();
        String layerName = null;
        Iterator i = layers.iterator();
        while (i.hasNext()) {
            if (layerName != null) {
                layerOrder.append(", ");
            }
            layerName = (String)i.next();
            layerOrder.append(layerName);
        }
        this.xml.setAttribute("order", layerOrder.toString());
        this.xml.printTag(nameSpace, "layer");
    }

    @Override
    public void write(HepRepTypeTree typeTree) throws IOException {
        this.xml.setAttribute("name", typeTree.getName());
        this.xml.setAttribute("version", typeTree.getVersion());
        this.xml.openTag(nameSpace, "typetree");
        Iterator i = typeTree.getTypeList().iterator();
        while (i.hasNext()) {
            this.write((HepRepType)i.next());
        }
        this.xml.closeTag();
    }

    @Override
    public void write(HepRepType type) throws IOException {
        if (type == null) {
            return;
        }
        this.xml.setAttribute("name", type.getName());
        this.xml.openTag(nameSpace, "type");
        this.write((HepRepDefinition)type);
        this.write((HepRepAttribute)type);
        Iterator i = type.getTypeList().iterator();
        while (i.hasNext()) {
            this.write((HepRepType)i.next());
        }
        this.xml.closeTag();
    }

    @Override
    public void write(HepRepTreeID treeID) throws IOException {
        this.xml.setAttribute("qualifier", treeID.getQualifier());
        this.xml.setAttribute("name", treeID.getName());
        this.xml.setAttribute("version", treeID.getVersion());
        this.xml.printTag(nameSpace, "treeid");
    }

    @Override
    public void write(HepRepAction action) throws IOException {
        this.xml.setAttribute("name", action.getName());
        this.xml.setAttribute("expression", action.getExpression());
        this.xml.printTag(nameSpace, "action");
    }

    @Override
    public void write(HepRepInstanceTree instanceTree) throws IOException {
        this.xml.setAttribute("name", instanceTree.getName());
        this.xml.setAttribute("version", instanceTree.getVersion());
        this.xml.setAttribute("typetreename", instanceTree.getTypeTree().getName());
        this.xml.setAttribute("typetreeversion", instanceTree.getTypeTree().getVersion());
        this.xml.openTag(nameSpace, "instancetree");
        Iterator i = instanceTree.getInstanceTreeList().iterator();
        while (i.hasNext()) {
            this.write((HepRepTreeID)i.next());
        }
        i = instanceTree.getInstances().iterator();
        while (i.hasNext()) {
            this.write((HepRepInstance)i.next());
        }
        this.xml.closeTag();
    }

    @Override
    public void write(HepRepInstance instance) throws IOException {
        this.xml.setAttribute("type", instance.getType().getFullName());
        this.xml.openTag(nameSpace, "instance");
        this.write((HepRepAttribute)instance);
        Iterator i = instance.getPoints().iterator();
        while (i.hasNext()) {
            this.write((HepRepPoint)i.next());
        }
        i = instance.getInstances().iterator();
        while (i.hasNext()) {
            this.write((HepRepInstance)i.next());
        }
        this.xml.closeTag();
    }

    @Override
    public void write(HepRepPoint point) throws IOException {
        if (this.bitEncoding) {
            this.xml.setAttribute("x", this.encodeNumber(point.getX()));
            this.xml.setAttribute("y", this.encodeNumber(point.getY()));
            this.xml.setAttribute("z", this.encodeNumber(point.getZ()));
        } else {
            this.xml.setAttribute("x", point.getX());
            this.xml.setAttribute("y", point.getY());
            this.xml.setAttribute("z", point.getZ());
        }
        if (point.getAttValuesFromNode().iterator().hasNext()) {
            this.xml.openTag(nameSpace, "point");
            this.write((HepRepAttribute)point);
            this.xml.closeTag();
        } else {
            this.xml.printTag(nameSpace, "point");
        }
    }

    @Override
    public void write(HepRepAttribute attribute) throws IOException {
        for (HepRepAttValue attValue : attribute.getAttValuesFromNode()) {
            this.write(attValue);
        }
    }

    @Override
    public void write(HepRepDefinition definition) throws IOException {
        for (HepRepAttDef attDef : definition.getAttDefsFromNode()) {
            this.write(attDef);
        }
    }

    private String encodeNumber(double d) {
        return "0ds" + HepRepUtil.encodeSpecial(Double.doubleToLongBits(d));
    }

    @Override
    public void write(HepRepAttValue attValue) throws IOException {
        String name = attValue.getName();
        this.xml.setAttribute("name", name);
        switch (attValue.getType()) {
            default: {
                this.xml.setAttribute("value", attValue.getAsString());
                break;
            }
            case 1: {
                this.xml.setAttribute("value", attValue.getString());
                break;
            }
            case 10: {
                this.xml.setAttribute("value", attValue.getLong());
                break;
            }
            case 11: {
                this.xml.setAttribute("value", attValue.getInteger());
                break;
            }
            case 20: {
                if (this.bitEncoding) {
                    this.xml.setAttribute("value", this.encodeNumber(attValue.getDouble()));
                    break;
                }
                this.xml.setAttribute("value", attValue.getDouble());
                break;
            }
            case 30: {
                this.xml.setAttribute("value", attValue.getBoolean());
                break;
            }
            case 2: {
                this.xml.setAttribute("value", attValue.getColor());
            }
        }
        if (attValue.showLabel() != 0) {
            this.xml.setAttribute("showlabel", attValue.showLabel());
        }
        this.xml.printTag(nameSpace, "attvalue");
    }

    @Override
    public void write(HepRepAttDef attDef) throws IOException {
        this.xml.setAttribute("name", attDef.getName());
        this.xml.setAttribute("desc", attDef.getDescription());
        this.xml.setAttribute("category", attDef.getCategory());
        this.xml.setAttribute("extra", attDef.getExtra());
        this.xml.printTag(nameSpace, "attdef");
    }
}

