/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.xml;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.ref.AbstractHepRepReader;
import hep.graphics.heprep.wbxml.BHepRepReader;
import hep.graphics.heprep.xml.XMLHepRepDefaultsHandler;
import hep.graphics.heprep.xml.XMLHepRepFactory;
import hep.graphics.heprep.xml.XMLHepRepHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.util.io.XMLSequence;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParserException;

public class XMLHepRepReader
extends AbstractHepRepReader {
    private InputStream sequence = null;

    XMLHepRepReader(InputStream in) throws IOException {
        super(in);
        this.reset();
    }

    XMLHepRepReader(String fileName) throws IOException {
        super(fileName);
        this.reset();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.sequence != null) {
            this.sequence.close();
        }
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        if (this.input != null && !(this.input instanceof ZipInputStream)) {
            this.sequence = new BufferedInputStream(this.input);
            this.sequence = this.input instanceof DataInputStream ? new PushbackInputStream(this.sequence) : new XMLSequence(this.sequence);
        } else if (this.name != null && !this.name.toLowerCase().endsWith(".zip")) {
            if (this.sequence != null) {
                this.sequence.close();
            }
            this.sequence = new FileInputStream(this.name);
            if (this.name.toLowerCase().endsWith(".gz")) {
                this.sequence = new GZIPInputStream(this.sequence);
            }
            this.sequence = new BufferedInputStream(this.sequence);
            this.sequence = this.name.toLowerCase().indexOf(".bheprep") >= 0 ? new PushbackInputStream(this.sequence) : new XMLSequence(this.sequence);
        } else {
            super.reset();
        }
    }

    @Override
    public boolean hasNext() throws IOException, UnsupportedOperationException {
        if (this.sequence != null) {
            if (this.sequence instanceof XMLSequence) {
                return ((XMLSequence)this.sequence).hasNext();
            }
            if (this.sequence instanceof PushbackInputStream) {
                int b = this.sequence.read();
                if (b < 0) {
                    return false;
                }
                ((PushbackInputStream)this.sequence).unread(b);
                return true;
            }
            return true;
        }
        return super.hasNext();
    }

    @Override
    public HepRep next() throws IOException, UnsupportedOperationException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException(this.getClass() + " no more elements");
        }
        if (this.sequence != null) {
            return this.sequence instanceof XMLSequence ? this.readHepRep(((XMLSequence)this.sequence).next(), false) : this.readHepRep(this.sequence, true);
        }
        return super.next();
    }

    @Override
    protected HepRep readHepRep(InputStream stream, boolean binary) throws IOException {
        HepRep heprep = this.readHepRep(new XMLHepRepFactory().createHepRep(), stream, binary);
        return heprep;
    }

    private HepRep readHepRep(HepRep heprep, InputStream stream, boolean binary) throws IOException {
        if (binary) {
            try {
                BHepRepReader reader = new BHepRepReader(heprep);
                reader.parse(stream);
                return heprep;
            }
            catch (XmlPullParserException e) {
                IOException exception = new IOException();
                exception.initCause(e);
                throw exception;
            }
        }
        try {
            XMLHepRepHandler handler = new XMLHepRepHandler(heprep);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser xml = factory.newSAXParser();
            xml.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            InputSource source = new InputSource(new BufferedReader(new InputStreamReader(stream)));
            xml.parse(source, (DefaultHandler)handler);
            return heprep;
        }
        catch (ParserConfigurationException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        catch (SAXParseException e) {
            if (e.getLineNumber() == 1 && e.getColumnNumber() == -1) {
                throw new EOFException();
            }
            IOException exception = new IOException("Syntax error at Line: " + e.getLineNumber() + "(" + e.getColumnNumber() + ")");
            exception.initCause(e);
            throw exception;
        }
        catch (SAXException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
    }

    public static void readDefaults() throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            XMLHepRepDefaultsHandler handler = new XMLHepRepDefaultsHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.setDTDHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.setEntityResolver(handler);
            BufferedReader reader = new BufferedReader(new InputStreamReader(XMLHepRepReader.class.getResourceAsStream("AttributeDefaults.xml")));
            InputSource source = new InputSource(reader);
            xmlReader.parse(source);
            ((Reader)reader).close();
        }
        catch (Exception e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
    }
}

