/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.xml;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.HepRepVersionException;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import hep.graphics.heprep.ref.DefaultHepRepInstance;
import hep.graphics.heprep.util.HepRepTypes;
import hep.graphics.heprep.util.HepRepUtil;
import hep.graphics.heprep.xml.XMLHepRepFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;
import org.freehep.util.VersionComparator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHepRepHandler
extends DefaultHandler {
    public static final String expectedVersion = "2.0";
    private boolean isHepRep2 = false;
    private HepRepFactory factory;
    private HepRep heprep;
    private int level = 0;
    private HepRepTypes types;
    private HepRepTypeTree currentTypeTree = null;
    private HepRepTreeID currentTypeTreeRef = null;
    private HepRepInstanceTree instanceTree = null;
    private HepRepPoint currentPoint = null;
    private Stack instanceStack = new Stack();
    private HepRepInstance currentInstance = null;
    private Stack typeStack = new Stack();
    private HepRepType currentType = null;

    XMLHepRepHandler(HepRep heprep) {
        this.heprep = heprep;
        this.factory = new XMLHepRepFactory();
    }

    @Override
    public void startDocument() throws SAXException {
        this.types = new HepRepTypes();
        this.currentTypeTree = null;
        this.currentTypeTreeRef = null;
        this.instanceTree = null;
        this.currentPoint = null;
        this.instanceStack = new Stack();
        this.currentInstance = null;
        this.typeStack = new Stack();
        this.currentType = null;
        this.level = 0;
    }

    @Override
    public void startElement(String namespace, String tag, String qName, Attributes atts) throws SAXException {
        ++this.level;
        if ((tag = tag.intern()) == "point") {
            double x = HepRepUtil.decodeNumber(atts.getValue("x"));
            double y = HepRepUtil.decodeNumber(atts.getValue("y"));
            double z = HepRepUtil.decodeNumber(atts.getValue("z"));
            this.currentPoint = this.factory.createHepRepPoint(this.currentInstance, x, y, z);
        } else if (tag == "instancetree") {
            String name = atts.getValue("name");
            String version = atts.getValue("version");
            this.currentTypeTreeRef = this.factory.createHepRepTreeID(atts.getValue("typetreename"), atts.getValue("typetreeversion"));
            this.instanceTree = this.factory.createHepRepInstanceTree(name, version, this.currentTypeTreeRef);
            this.heprep.addInstanceTree(this.instanceTree);
        } else if (tag == "treeid") {
            String name = atts.getValue("name");
            String version = atts.getValue("version");
            String qualifier = atts.getValue("qualifier");
            this.instanceTree.addInstanceTree(this.factory.createHepRepTreeID(name, version, qualifier));
        } else if (tag == "action") {
            String name = atts.getValue("name");
            String expression = atts.getValue("expression");
            this.factory.createHepRepAction(name, expression);
        } else if (tag == "layer") {
            String order = atts.getValue("order");
            StringTokenizer st = new StringTokenizer(order, ",");
            while (st.hasMoreTokens()) {
                this.heprep.addLayer(st.nextToken().trim());
            }
        } else if (tag == "instance") {
            String typeName = atts.getValue("type");
            if (typeName == null) {
                throw new SAXException("[XMLHepRepReader] Instance cannot exist without referring to a type.");
            }
            HepRepType type = this.types.getType(this.currentTypeTreeRef, typeName, this.currentInstance);
            if (type == null) {
                throw new SAXException("[XMLHepRepReader] Cannot find type: '" + typeName + "' " + "in tree: '" + this.types.getID(this.currentTypeTreeRef) + "'");
            }
            this.instanceStack.push(this.currentInstance);
            this.currentInstance = this.currentInstance != null ? this.factory.createHepRepInstance(this.currentInstance, type) : this.factory.createHepRepInstance(this.instanceTree, type);
        } else if (tag == "typetree") {
            this.isHepRep2 = true;
            String name = atts.getValue("name");
            String version = atts.getValue("version");
            HepRepTreeID id = this.factory.createHepRepTreeID(name, version);
            this.currentTypeTree = this.factory.createHepRepTypeTree(id);
            this.heprep.addTypeTree(this.currentTypeTree);
            this.types.put(id, this.currentTypeTree);
        } else if (tag == "type") {
            if (!this.isHepRep2) {
                throw new SAXException(new HepRepVersionException(this.getClass() + ": Could not deduce heprep version, expected version '" + expectedVersion + "'."));
            }
            String name = atts.getValue("name");
            this.typeStack.push(this.currentType);
            this.currentType = this.currentType != null ? this.factory.createHepRepType(this.currentType, name) : this.factory.createHepRepType(this.currentTypeTree, name);
            this.types.put(this.currentTypeTree, name, this.currentType);
        } else if (tag == "heprep") {
            String version = atts.getValue("version");
            if (version != null) {
                this.isHepRep2 = true;
                VersionComparator comparator = new VersionComparator();
                if (comparator.versionNumberCompare(version, expectedVersion) < 0) {
                    throw new SAXException(new HepRepVersionException(this.getClass() + ": Found version '" + version + "' while expected version '" + expectedVersion + "'."));
                }
            } else {
                String xmlns = atts.getValue("xmlns");
                if (xmlns != null && xmlns.startsWith("http://java.freehep.org/schemas/heprep/2")) {
                    this.isHepRep2 = true;
                }
            }
        } else if (tag == "attvalue") {
            String name = atts.getValue("name");
            String value = atts.getValue("value");
            String type = DefaultHepRepAttValue.guessType(name, value, atts.getValue("type"));
            String showLabelString = atts.getValue("showlabel");
            if (showLabelString == null) {
                showLabelString = atts.getValue("showLabel");
            }
            int showLabel = DefaultHepRepAttValue.toShowLabel(showLabelString);
            DefaultHepRepAttValue attValue = new DefaultHepRepAttValue(name, value, type, showLabel);
            if (this.currentPoint != null) {
                this.currentPoint.addAttValue(attValue);
            } else if (this.currentInstance != null) {
                this.currentInstance.addAttValue(attValue);
            } else {
                if (this.currentType == null) {
                    throw new SAXException("[XMLHepRepReader] Cannot use 'attvalue' outside 'type' tag.");
                }
                this.currentType.addAttValue(attValue);
            }
        } else if (tag == "attdef") {
            if (!this.isHepRep2) {
                throw new SAXException(new HepRepVersionException(this.getClass() + ": Found a probable HepRep1 version while expected version '" + expectedVersion + "'."));
            }
            if (this.currentType == null) {
                throw new SAXException("[XMLHepRepReader] Cannot use 'attdef' outside 'type' tag.");
            }
            String name = atts.getValue("name");
            String desc = atts.getValue("desc");
            String category = atts.getValue("category");
            String extra = atts.getValue("extra");
            this.currentType.addAttDef(name, desc, category, extra);
        } else {
            throw new SAXException("[XMLHepRepReader] Unknown tag: <" + (namespace != null ? namespace + ":" : "") + tag + "> qualifiedName: '" + qName + "'");
        }
        if (Thread.interrupted()) {
            throw new SAXException(new InterruptedException());
        }
    }

    @Override
    public void endElement(String namespace, String tag, String qName) throws SAXException {
        try {
            if (tag.lastIndexOf(58) >= 0) {
                tag = tag.substring(tag.lastIndexOf(58) + 1);
            }
            if ((tag = tag.intern()) == "point") {
                this.currentPoint = null;
            } else if (tag == "instancetree") {
                this.instanceTree = null;
                this.currentTypeTreeRef = null;
            } else if (tag != "treeid" && tag != "layer") {
                if (tag == "instance") {
                    if (this.currentInstance instanceof DefaultHepRepInstance) {
                        ((DefaultHepRepInstance)this.currentInstance).optimize();
                    }
                    this.currentInstance = (HepRepInstance)this.instanceStack.pop();
                } else if (tag == "typetree") {
                    this.currentTypeTree = null;
                } else if (tag == "type") {
                    this.currentType = (HepRepType)this.typeStack.pop();
                } else if (tag != "heprep" && tag != "attvalue" && tag != "attdef") {
                    throw new SAXException("[XMLHepRepReader] Unknown tag: " + tag);
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        if (Thread.interrupted()) {
            throw new SAXException(new InterruptedException());
        }
        --this.level;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (publicId != null) {
            return null;
        }
        InputStream is = null;
        URL url = null;
        try {
            url = new URL(systemId);
            is = url.openStream();
        }
        catch (MalformedURLException mfue) {
            return null;
        }
        catch (IOException ioe) {
            String file = url.getFile().substring(url.getFile().lastIndexOf(47) + 1);
            is = this.getClass().getResourceAsStream(file);
        }
        return new InputSource(is);
    }
}

