/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.xml;

import hep.graphics.heprep.HepRepDefaults;
import hep.graphics.heprep.ref.DefaultHepRepAttDef;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHepRepDefaultsHandler
extends DefaultHandler {
    XMLHepRepDefaultsHandler() {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespace, String tag, String qName, Attributes atts) throws SAXException {
        if ((tag = tag.intern()) != "type" && tag != "typetree" && tag != "heprep" && tag != "layer") {
            if (tag == "attvalue") {
                String name = atts.getValue("name");
                if (name == null) {
                    throw new SAXException("[XMLHepRepDefaultsHandler] tag: " + tag + " should have 'name' attribute");
                }
                String value = atts.getValue("value");
                if (value == null) {
                    throw new SAXException("[XMLHepRepDefaultsHandler] tag: " + tag + " with name: " + name + " should have 'value' attribute");
                }
                String type = atts.getValue("type");
                if (type == null) {
                    throw new SAXException("[XMLHepRepDefaultsHandler] tag: " + tag + " with name: " + name + " should have 'type' attribute");
                }
                int showLabel = DefaultHepRepAttValue.toShowLabel(atts.getValue("showlabel"));
                HepRepDefaults.addAttValue(new DefaultHepRepAttValue(name, value, type, showLabel));
            } else if (tag == "attdef") {
                String name = atts.getValue("name");
                String desc = atts.getValue("desc");
                String category = atts.getValue("category");
                String extra = atts.getValue("extra");
                HepRepDefaults.addAttDef(new DefaultHepRepAttDef(name, desc, category, extra));
            } else {
                throw new SAXException("[XMLHepRepDefaultsHandler] Unknown tag: " + tag);
            }
        }
    }

    @Override
    public void endElement(String namespace, String tag, String qName) throws SAXException {
        if (tag.lastIndexOf(58) >= 0) {
            tag = tag.substring(tag.lastIndexOf(58) + 1);
        }
        if ((tag = tag.intern()) != "type" && tag != "typetree" && tag != "heprep" && tag != "layer" && tag != "attvalue" && tag != "attdef") {
            throw new SAXException("[XMLHepRepDefaultsHandler] Unknown tag: " + tag);
        }
        if (Thread.interrupted()) {
            throw new SAXException(new InterruptedException());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        System.out.println("Resolving: " + systemId);
        if (publicId != null) {
            return null;
        }
        InputStream is = null;
        URL url = null;
        try {
            url = new URL(systemId);
            is = url.openStream();
        }
        catch (MalformedURLException mfue) {
            return null;
        }
        catch (IOException ioe) {
            String file = url.getFile().substring(url.getFile().lastIndexOf(47) + 1);
            is = this.getClass().getResourceAsStream(file);
        }
        return new InputSource(is);
    }
}

