/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.wbxml;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WbxmlParser
implements XmlPullParser {
    public static final int EXTENSION = 64;
    public static final int OPAQUE = 65;
    private static final String ILLEGAL_TYPE = "Wrong event type";
    private DataInputStream in;
    private int TAG_TABLE = 0;
    private int ATTR_START_TABLE = 1;
    private int ATTR_VALUE_TABLE = 2;
    protected String[] attrStartTable;
    protected String[] attrValueTable;
    protected String[] tagTable;
    private String stringTable;
    private boolean processNsp;
    private int depth;
    private String[] nspStack = new String[8];
    private int[] nspCounts = new int[4];
    private List attributes = new ArrayList();
    private Stack tags = new Stack();
    private int nextId = -2;
    private Vector tables = new Vector();
    int version;
    int publicIdentifierId;
    int charSet;
    private int tagId;
    private String prefix;
    private String namespace;
    private String name;
    private String text;
    private Object wapExtensionData;
    protected int type;
    private boolean degenerated;
    private boolean isWhitespace;

    public boolean getFeature(String feature) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature)) {
            return this.processNsp;
        }
        return false;
    }

    public String getInputEncoding() {
        return null;
    }

    public void defineEntityReplacementText(String entity, String value) throws XmlPullParserException {
    }

    public Object getProperty(String property) {
        return null;
    }

    public int getNamespaceCount(int depth) {
        if (depth > this.depth) {
            throw new IndexOutOfBoundsException();
        }
        return this.nspCounts[depth];
    }

    public String getNamespacePrefix(int pos) {
        return this.nspStack[pos << 1];
    }

    public String getNamespaceUri(int pos) {
        return this.nspStack[(pos << 1) + 1];
    }

    public String getNamespace(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i = (this.getNamespaceCount(this.depth) << 1) - 2; i >= 0; i -= 2) {
            if (!(prefix == null ? this.nspStack[i] == null : prefix.equals(this.nspStack[i]))) continue;
            return this.nspStack[i + 1];
        }
        return null;
    }

    public int getDepth() {
        return this.tags.size();
    }

    public String getPositionDescription() {
        StringBuffer buf = new StringBuffer(this.type < TYPES.length ? TYPES[this.type] : "unknown type " + this.type);
        buf.append(' ');
        if (this.type == 2 || this.type == 3) {
            if (this.degenerated) {
                buf.append("(empty) ");
            }
            buf.append('<');
            if (this.type == 3) {
                buf.append('/');
            }
            if (this.prefix != null) {
                buf.append("{" + this.namespace + "}" + this.prefix + ":");
            }
            buf.append(this.name);
            for (int i = 0; i < this.attributes.size(); ++i) {
                buf.append(' ');
                if (((Attribute)this.attributes.get((int)i)).namespace != null) {
                    buf.append("{" + ((Attribute)this.attributes.get((int)i)).prefix + "}" + ((Attribute)this.attributes.get((int)i)).namespace + ":");
                }
                buf.append(((Attribute)this.attributes.get((int)i)).name + "='" + this.getAttributeValue(i) + "'");
            }
            buf.append('>');
        } else if (this.type != 7) {
            if (this.type != 4) {
                buf.append(this.getText());
            } else if (this.isWhitespace) {
                buf.append("(whitespace)");
            } else {
                String text = this.getText();
                if (text.length() > 16) {
                    text = text.substring(0, 16) + "...";
                }
                buf.append(text);
            }
        }
        return buf.toString();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.type != 4 && this.type != 7 && this.type != 5) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.isWhitespace;
    }

    public String getText() {
        return this.text;
    }

    public char[] getTextCharacters(int[] poslen) {
        if (this.type >= 4) {
            poslen[0] = 0;
            poslen[1] = this.text.length();
            char[] buf = new char[this.text.length()];
            this.text.getChars(0, this.text.length(), buf, 0);
            return buf;
        }
        poslen[0] = -1;
        poslen[1] = -1;
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getTag() {
        return this.tagId;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.type != 2) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.degenerated;
    }

    protected void addAttribute(int attId, String prefix, String namespace, String name, Object value) {
        this.attributes.add(new Attribute(attId, prefix, namespace, name, value));
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public String getAttributeNamespace(int index) {
        if (index >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return ((Attribute)this.attributes.get((int)index)).namespace;
    }

    public String getAttributeName(int index) {
        if (index >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return ((Attribute)this.attributes.get((int)index)).name;
    }

    public String getAttributePrefix(int index) {
        if (index >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return ((Attribute)this.attributes.get((int)index)).prefix;
    }

    public String getAttributeValue(int index) {
        if (index >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.getAttributeObject(index);
        if (object instanceof List) {
            StringBuffer s = new StringBuffer();
            Iterator i = ((List)object).iterator();
            while (i.hasNext()) {
                s.append(i.next());
            }
            return s.toString();
        }
        return object.toString();
    }

    public Object getAttributeObject(int index) {
        if (index >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return ((Attribute)this.attributes.get((int)index)).value;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(null, name);
    }

    public String getAttributeValue(String namespace, String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!((Attribute)this.attributes.get((int)i)).name.equals(name) || namespace != null && !((Attribute)this.attributes.get((int)i)).namespace.equals(namespace)) continue;
            return this.getAttributeValue(i);
        }
        return null;
    }

    public Object getAttributeObject(String name) {
        return this.getAttributeObject(null, name);
    }

    public Object getAttributeObject(String namespace, String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!((Attribute)this.attributes.get((int)i)).name.equals(name) || namespace != null && !((Attribute)this.attributes.get((int)i)).namespace.equals(namespace)) continue;
            return this.getAttributeObject(i);
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.type;
    }

    public int next() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        int minType = 9999;
        block3: while (true) {
            String save = this.text;
            this.nextImpl();
            if (this.type < minType) {
                minType = this.type;
            }
            if (minType > 5) continue;
            if (minType < 4) break;
            if (save != null) {
                this.text = this.text == null ? save : save + this.text;
            }
            switch (this.peekId()) {
                case 2: 
                case 3: 
                case 4: 
                case 68: 
                case 132: 
                case 196: {
                    continue block3;
                }
            }
            break;
        }
        this.type = minType;
        if (this.type > 4) {
            this.type = 4;
        }
        return this.type;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        this.nextImpl();
        return this.type;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.type == 4 && this.isWhitespace) {
            this.next();
        }
        if (this.type != 3 && this.type != 2) {
            this.exception("unexpected type");
        }
        return this.type;
    }

    public String nextText() throws XmlPullParserException, IOException {
        String result;
        if (this.type != 2) {
            this.exception("precondition: START_TAG");
        }
        this.next();
        if (this.type == 4) {
            result = this.getText();
            this.next();
        } else {
            result = "";
        }
        if (this.type != 3) {
            this.exception("END_TAG expected");
        }
        return result;
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            this.exception("expected: " + TYPES[type] + " {" + namespace + "}" + name);
        }
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.exception("InputStream required");
    }

    protected int readVersion() throws IOException {
        return this.readByte();
    }

    protected int readPublicIdentifierId() throws IOException {
        int id = this.readInt();
        if (id == 0) {
            this.readInt();
        }
        return id;
    }

    protected int readCharSet() throws IOException {
        return this.readInt();
    }

    protected String readStringTable() throws IOException {
        int strTabSize = this.readInt();
        StringBuffer buf = new StringBuffer(strTabSize);
        for (int i = 0; i < strTabSize; ++i) {
            buf.append((char)this.readByte());
        }
        return buf.toString();
    }

    public void setInput(InputStream in, String enc) throws XmlPullParserException {
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        try {
            this.readVersion();
            this.publicIdentifierId = this.readPublicIdentifierId();
            this.charSet = this.readCharSet();
            this.stringTable = this.readStringTable();
            this.selectPage(0, true);
            this.selectPage(0, false);
        }
        catch (IOException e) {
            this.exception("Illegal input format");
        }
    }

    public void setFeature(String feature, boolean value) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature)) {
            this.processNsp = value;
        } else {
            this.exception("unsupported feature: " + feature);
        }
    }

    public void setProperty(String property, Object value) throws XmlPullParserException {
        throw new XmlPullParserException("unsupported property: " + property);
    }

    private final void setTable(int page, int type, String[] table) {
        if (this.stringTable != null) {
            throw new RuntimeException("setXxxTable must be called before setInput!");
        }
        while (this.tables.size() < 3 * page + 3) {
            this.tables.addElement(null);
        }
        this.tables.setElementAt(table, page * 3 + type);
    }

    private final void exception(String desc) throws XmlPullParserException {
        throw new XmlPullParserException(desc, (XmlPullParser)this, null);
    }

    protected void selectPage(int nr, boolean tags) throws XmlPullParserException {
        if (this.tables.size() == 0 && nr == 0) {
            return;
        }
        if (tags && nr * 3 + this.TAG_TABLE > this.tables.size() || !tags && nr * 3 + this.ATTR_VALUE_TABLE > this.tables.size()) {
            this.exception("Code Page " + nr + " undefined for " + (tags ? "tags" : "attributes") + ".");
        }
        if (tags) {
            this.tagTable = (String[])this.tables.elementAt(nr * 3 + this.TAG_TABLE);
        } else {
            this.attrStartTable = (String[])this.tables.elementAt(nr * 3 + this.ATTR_START_TABLE);
            this.attrValueTable = (String[])this.tables.elementAt(nr * 3 + this.ATTR_VALUE_TABLE);
        }
    }

    private final void nextImpl() throws IOException, XmlPullParserException {
        if (this.type == 3) {
            --this.depth;
            Tag tag = (Tag)this.tags.pop();
            this.endTag(tag);
        }
        if (this.degenerated) {
            this.type = 3;
            this.degenerated = false;
            return;
        }
        this.text = null;
        this.prefix = null;
        this.tagId = 0;
        this.name = null;
        int id = this.peekId();
        while (id == 0) {
            this.nextId = -2;
            this.selectPage(this.readByte(), true);
            id = this.peekId();
        }
        this.nextId = -2;
        switch (id) {
            case -1: {
                this.type = 1;
                break;
            }
            case 1: {
                this.type = 3;
                Tag peek = (Tag)this.tags.peek();
                this.tagId = peek.tagId;
                this.namespace = peek.namespace;
                this.prefix = peek.prefix;
                this.name = peek.name;
                break;
            }
            case 2: {
                this.type = 6;
                char c = (char)this.readInt();
                this.text = "" + c;
                this.name = "#" + c;
                break;
            }
            case 3: {
                this.type = 4;
                this.text = this.readStrI();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 128: 
            case 129: 
            case 130: 
            case 192: 
            case 193: 
            case 194: {
                this.type = 64;
                this.parseExtension(id, 0, 0);
                break;
            }
            case 195: {
                this.type = 65;
                int len = this.readInt();
                this.parseOpaque(len, 0, 0);
                break;
            }
            case 67: {
                this.processInstruction();
                break;
            }
            case 131: {
                this.type = 4;
                int pos = this.readInt();
                int end = this.stringTable.indexOf(0, pos);
                this.text = this.stringTable.substring(pos, end);
                break;
            }
            default: {
                this.parseElement(id);
            }
        }
    }

    protected void endAttributes() throws IOException, XmlPullParserException {
    }

    protected void endTag(Tag tag) throws IOException, XmlPullParserException {
    }

    protected void processInstruction() throws IOException, XmlPullParserException {
        this.readAttr(0);
    }

    protected Object parseOpaque(int len, int tagId, int attId) throws IOException, XmlPullParserException {
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)this.readByte();
        }
        this.wapExtensionData = buf;
        return buf;
    }

    protected Object parseExtension(int id, int tagId, int attId) throws IOException, XmlPullParserException {
        switch (id) {
            case 64: 
            case 65: 
            case 66: {
                this.wapExtensionData = this.readStrI();
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                this.wapExtensionData = new Integer(this.readInt());
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                this.wapExtensionData = null;
                break;
            }
            default: {
                this.exception("illegal extension id: " + id + "(" + Integer.toHexString(id) + ")");
            }
        }
        return this.wapExtensionData;
    }

    public void readAttr(int tagId) throws IOException, XmlPullParserException {
        int id = this.readByte();
        while (id != 1) {
            while (id == 0) {
                this.selectPage(this.readByte(), false);
                id = this.readByte();
            }
            int attId = id;
            String name = this.resolveId("ATTRSTART", this.attrStartTable, id);
            ArrayList<Object> value = new ArrayList<Object>();
            int cut = name.indexOf(61);
            if (cut != -1) {
                value.add(name.substring(cut + 1));
                name = name.substring(0, cut);
            }
            id = this.readByte();
            while (id > 128 || id == 0 || id == 2 || id == 3 || id == 131 || id >= 64 && id <= 66 || id >= 128 && id <= 130) {
                switch (id) {
                    case 0: {
                        this.selectPage(this.readByte(), false);
                        break;
                    }
                    case 2: {
                        value.add(new Integer(this.readInt()));
                        break;
                    }
                    case 3: {
                        value.add(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: {
                        value.add(this.parseExtension(id, tagId, attId));
                        break;
                    }
                    case 195: {
                        int len = this.readInt();
                        value.add(this.parseOpaque(len, tagId, attId));
                        break;
                    }
                    case 131: {
                        value.add(this.readStrT());
                        break;
                    }
                    default: {
                        value.add(this.resolveId("ATTRVALUE", this.attrValueTable, id));
                    }
                }
                id = this.readByte();
            }
            this.addAttribute(attId, "", null, name, value);
        }
        this.endAttributes();
    }

    private int peekId() throws IOException {
        if (this.nextId == -2) {
            this.nextId = this.in.read();
        }
        return this.nextId;
    }

    protected String resolveId(String type, String[] tab, int id) throws IOException {
        int idx = (id & 0x7F) - 5;
        if (idx == -1) {
            return this.readStrT();
        }
        if (idx < 0 || tab == null || idx >= tab.length || tab[idx] == null) {
            throw new IOException(type + " id " + id + " (0x" + Integer.toHexString(id) + ") undefined.");
        }
        return tab[idx];
    }

    protected void parseElement(int id) throws IOException, XmlPullParserException {
        this.type = 2;
        this.tagId = id & 0x3F;
        this.name = this.resolveId("TAG", this.tagTable, this.tagId);
        this.attributes.clear();
        if ((id & 0x80) != 0) {
            this.readAttr(this.tagId);
        }
        this.degenerated = (id & 0x40) == 0;
        ++this.depth;
        if (this.depth >= this.nspCounts.length) {
            int[] bigger = new int[this.depth + 4];
            System.arraycopy(this.nspCounts, 0, bigger, 0, this.nspCounts.length);
            this.nspCounts = bigger;
        }
        this.nspCounts[this.depth] = this.nspCounts[this.depth - 1];
        this.namespace = "";
        this.tags.push(new Tag(this.tagId, this.prefix, this.namespace, this.name));
    }

    protected int readByte() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("Unexpected EOF");
        }
        return i;
    }

    protected int readInt() throws IOException {
        int i;
        int result = 0;
        do {
            i = this.readByte();
            result = result << 7 | i & 0x7F;
        } while ((i & 0x80) != 0);
        return result;
    }

    protected float readFloat() throws IOException {
        return this.in.readFloat();
    }

    protected double readDouble() throws IOException {
        return this.in.readDouble();
    }

    protected int readInt32() throws IOException {
        return this.in.readInt();
    }

    protected long readInt64() throws IOException {
        return this.in.readLong();
    }

    protected String readStrI() throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean wsp = true;
        while (true) {
            int i;
            if ((i = this.in.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (i == 0) break;
            if (i > 32) {
                wsp = false;
            }
            buf.append((char)i);
        }
        this.isWhitespace = wsp;
        return buf.toString();
    }

    protected String readStrT() throws IOException {
        int pos = this.readInt();
        int end = this.stringTable.indexOf(0, pos);
        return this.stringTable.substring(pos, end);
    }

    public void setTagTable(int page, String[] table) {
        this.setTable(page, this.TAG_TABLE, table);
    }

    public void setAttrStartTable(int page, String[] table) {
        this.setTable(page, this.ATTR_START_TABLE, table);
    }

    public void setAttrValueTable(int page, String[] table) {
        this.setTable(page, this.ATTR_VALUE_TABLE, table);
    }

    public static String getWapExtension(int id) {
        switch (id) {
            case 64: {
                return "EXT_I_0";
            }
            case 65: {
                return "EXT_I_1";
            }
            case 66: {
                return "EXT_I_2";
            }
            case 128: {
                return "EXT_T_0";
            }
            case 129: {
                return "EXT_T_1";
            }
            case 130: {
                return "EXT_T_2";
            }
            case 192: {
                return "EXT_0";
            }
            case 193: {
                return "EXT_1";
            }
            case 194: {
                return "EXT_2";
            }
            case 195: {
                return "OPAQUE";
            }
        }
        return "Unknown token: " + id + "(" + Integer.toHexString(id) + ")";
    }

    class Tag {
        int tagId;
        String prefix;
        String namespace;
        String name;

        Tag(int tagId, String prefix, String namespace, String name) {
            this.tagId = tagId;
            this.prefix = prefix;
            this.namespace = namespace;
            this.name = name;
        }
    }

    class Attribute {
        int attId;
        String prefix;
        String namespace;
        String name;
        Object value;

        Attribute(int attId, String prefix, String namespace, String name, Object value) {
            this.attId = attId;
            this.prefix = prefix;
            this.namespace = namespace;
            this.name = name;
            this.value = value instanceof List && ((List)value).size() == 1 ? ((List)value).get(0) : value;
        }
    }
}

