/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.wbxml;

import hep.graphics.heprep.xml.XMLTagWriter;
import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kxml2.wap.Wbxml;

public class BHepRepWriter
implements XMLTagWriter,
Wbxml {
    public static final int WBXML_VERSION = 3;
    public static final int UNKNOWN_PID = 1;
    public static final int UTF8 = 106;
    public static final int CONTENT = 64;
    public static final int ATTRIBUTE = 128;
    public static final int STR_D = 64;
    public static final int STR_R = 128;
    private static Map tags = new HashMap();
    private static Map attributes;
    private static Map values;
    private DataOutputStream os;
    private boolean singlePrecision;
    private Map stringValues;
    Map stringAttributes;
    Map colorAttributes;
    Map longAttributes;
    Map intAttributes;
    Map booleanAttributes;
    Map doubleAttributes;
    List points;

    public BHepRepWriter(OutputStream os) {
        this.os = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        this.singlePrecision = true;
        this.stringValues = new HashMap();
        this.stringAttributes = new HashMap();
        this.colorAttributes = new HashMap();
        this.longAttributes = new HashMap();
        this.intAttributes = new HashMap();
        this.booleanAttributes = new HashMap();
        this.doubleAttributes = new HashMap();
        this.points = new ArrayList();
    }

    @Override
    public void openTag(String ns, String name) throws IOException {
        this.openTag(ns.equals("heprep") ? name : ns + ":" + name);
    }

    @Override
    public void printTag(String ns, String name) throws IOException {
        this.openTag(ns.equals("heprep") ? name : ns + ":" + name);
    }

    @Override
    public void setAttribute(String ns, String name, String value) {
        this.setAttribute(ns.equals("heprep") ? name : ns + ":" + name, value);
    }

    @Override
    public void setAttribute(String ns, String name, double value) {
        this.setAttribute(ns.equals("heprep") ? name : ns + ":" + name, value);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void openDoc() throws IOException {
        this.openDoc("BinaryHepRep/1.0", "UTF-8", false);
    }

    @Override
    public void openDoc(String version, String encoding, boolean standalone) throws IOException {
        this.stringValues.clear();
        this.writeByte(3);
        this.writeMultiByteInt(1L);
        this.writeMultiByteInt(106L);
        version = "BinaryHepRep/1.0";
        this.writeMultiByteInt(version.length() + 1);
        this.writeString(version);
    }

    @Override
    public void closeDoc() throws IOException {
        this.writeByte(67);
        this.writeByte((Integer)attributes.get("eof"));
        this.writeByte(1);
    }

    @Override
    public void openTag(String name) throws IOException {
        this.writeTag(name, true);
    }

    @Override
    public void closeTag() throws IOException {
        this.writePoints();
        this.writeByte(1);
    }

    @Override
    public void printTag(String name) throws IOException {
        this.writeTag(name, false);
    }

    private void writeTag(String tagName, boolean hasContent) throws IOException {
        boolean hasAttributes;
        String s = tagName.toLowerCase();
        Integer tag = (Integer)tags.get(s);
        if (tag == null) {
            throw new IOException("Cannot find tag '" + s + "' in tags table.");
        }
        boolean isPoint = s.equals("point");
        boolean bl = this.stringAttributes.size() > 0 || this.doubleAttributes.size() > (isPoint ? 3 : 0) ? true : (hasAttributes = false);
        if (!hasAttributes && isPoint) {
            this.points.add((Double)this.doubleAttributes.get("x"));
            this.points.add((Double)this.doubleAttributes.get("y"));
            this.points.add((Double)this.doubleAttributes.get("z"));
            return;
        }
        this.writePoints();
        this.writeByte(tag | (hasContent || isPoint ? 64 : 0) | (hasAttributes ? 128 : 0));
        if (hasAttributes) {
            Object value;
            for (String name : this.stringAttributes.keySet()) {
                value = (String)this.stringAttributes.get(name);
                this.writeByte((Integer)attributes.get(name));
                String v = ((String)value).toLowerCase();
                if (values.get(v) != null) {
                    this.writeByte((Integer)values.get(v));
                    continue;
                }
                if (this.stringValues.get(value) == null) {
                    this.writeStringDefine((String)value);
                    int index = this.stringValues.size();
                    this.stringValues.put(value, new Integer(index));
                    continue;
                }
                this.writeByte(128);
                this.writeMultiByteInt((Integer)this.stringValues.get(value));
            }
            this.stringAttributes.clear();
            for (String name : this.colorAttributes.keySet()) {
                value = (Color)this.colorAttributes.get(name);
                this.writeByte((Integer)attributes.get(name));
                this.writeByte(195);
                this.writeMultiByteInt(((Color)value).getAlpha() < 255 ? 4L : 3L);
                this.writeByte(((Color)value).getRed());
                this.writeByte(((Color)value).getGreen());
                this.writeByte(((Color)value).getBlue());
                if (((Color)value).getAlpha() >= 255) continue;
                this.writeByte(((Color)value).getAlpha());
            }
            this.colorAttributes.clear();
            for (String name : this.longAttributes.keySet()) {
                value = (Long)this.longAttributes.get(name);
                this.writeByte((Integer)attributes.get(name));
                this.writeByte(195);
                this.writeMultiByteInt(8L);
                this.writeLong((Long)value);
            }
            this.longAttributes.clear();
            for (String name : this.intAttributes.keySet()) {
                value = (Integer)this.intAttributes.get(name);
                this.writeByte((Integer)attributes.get(name));
                this.writeByte(195);
                this.writeMultiByteInt(4L);
                this.writeInt((Integer)value);
            }
            this.intAttributes.clear();
            for (String name : this.booleanAttributes.keySet()) {
                value = (Boolean)this.booleanAttributes.get(name);
                this.writeByte((Integer)attributes.get(name));
                this.writeByte(((Boolean)value).booleanValue() ? (Integer)values.get("true") : (Integer)values.get("false"));
            }
            this.booleanAttributes.clear();
            for (String name : this.doubleAttributes.keySet()) {
                value = (Double)this.doubleAttributes.get(name);
                if (isPoint || name.equals("x") || name.equals("y") || name.equals("z")) continue;
                this.writeByte((Integer)attributes.get(name));
                this.writeByte(195);
                this.writeMultiByteInt(this.singlePrecision ? 4L : 8L);
                this.writeReal((Double)value);
            }
            this.doubleAttributes.clear();
            this.writeByte(1);
        }
        if (s == "point") {
            this.writeByte(195);
            this.writeMultiByteInt(this.singlePrecision ? 12L : 24L);
            this.writeReal((Double)this.doubleAttributes.get("x"));
            this.writeReal((Double)this.doubleAttributes.get("y"));
            this.writeReal((Double)this.doubleAttributes.get("z"));
        }
        if (isPoint && !hasContent) {
            this.writeByte(1);
        }
    }

    private void writePoints() throws IOException {
        if (this.points.size() <= 0) {
            return;
        }
        this.writeByte((int)((Integer)tags.get("point") | 0x40));
        this.writeByte(195);
        this.writeMultiByteInt(this.points.size() * (this.singlePrecision ? 4 : 8));
        Iterator i = this.points.iterator();
        while (i.hasNext()) {
            this.writeReal((Double)i.next());
        }
        this.writeByte(1);
        this.points.clear();
    }

    @Override
    public void setAttribute(String name, String value) {
        if (name.equals("value")) {
            name = name + "String";
        }
        if (attributes.get(name) == null) {
            throw new RuntimeException("Cannot find attribute name '" + name + "' in attributes table.");
        }
        this.stringAttributes.put(name, value);
    }

    @Override
    public void setAttribute(String name, Color value) {
        if (name.equals("value")) {
            name = name + "Color";
        }
        if (attributes.get(name) == null) {
            throw new RuntimeException("Cannot find attribute name '" + name + "' in attributes table.");
        }
        this.colorAttributes.put(name, value);
    }

    @Override
    public void setAttribute(String name, long value) {
        if (name.equals("value")) {
            name = name + "Long";
        }
        if (attributes.get(name) == null) {
            throw new RuntimeException("Cannot find attribute name '" + name + "' in attributes table.");
        }
        this.longAttributes.put(name, new Long(value));
    }

    @Override
    public void setAttribute(String name, int value) {
        if (name.equals("value")) {
            name = name + "Int";
        }
        if (attributes.get(name) == null) {
            throw new RuntimeException("Cannot find attribute name '" + name + "' in attributes table.");
        }
        this.intAttributes.put(name, new Integer(value));
    }

    @Override
    public void setAttribute(String name, boolean value) {
        if (name.equals("value")) {
            name = name + "Boolean";
        }
        if (attributes.get(name) == null) {
            throw new RuntimeException("Cannot find attribute name '" + name + "' in attributes table.");
        }
        this.booleanAttributes.put(name, new Boolean(value));
    }

    @Override
    public void setAttribute(String name, double value) {
        if (name.equals("value")) {
            name = name + "Double";
        }
        if (attributes.get(name) == null) {
            throw new RuntimeException("Cannot find attribute name '" + name + "' in attributes table.");
        }
        this.doubleAttributes.put(name, new Double(value));
    }

    private void writeStringDefine(String s) throws IOException {
        this.writeByte(64);
        this.writeString(s);
    }

    private void writeMultiByteInt(Number n) throws IOException {
        this.writeMultiByteInt(n.longValue());
    }

    private void writeMultiByteInt(long ui) throws IOException {
        int[] buf = new int[5];
        int idx = 0;
        do {
            buf[idx++] = (int)(ui & 0x7FL);
        } while ((ui >>= 7) != 0L);
        while (idx > 1) {
            this.writeByte(buf[--idx] | 0x80);
        }
        this.writeByte(buf[0]);
    }

    private void writeReal(Double d) throws IOException {
        if (this.singlePrecision) {
            this.os.writeFloat(d.floatValue());
        } else {
            this.os.writeDouble(d);
        }
    }

    private void writeLong(Long i) throws IOException {
        this.os.writeLong(i);
    }

    private void writeInt(Integer i) throws IOException {
        this.os.writeInt(i);
    }

    private void writeByte(Integer b) throws IOException {
        this.writeByte((int)b);
    }

    private void writeByte(int b) throws IOException {
        this.os.writeByte(b);
    }

    private void writeString(String s) throws IOException {
        this.os.writeBytes(s);
        this.os.writeByte(0);
    }

    static {
        tags.put("heprep", new Integer(5));
        tags.put("attdef", new Integer(6));
        tags.put("attvalue", new Integer(7));
        tags.put("instance", new Integer(8));
        tags.put("treeid", new Integer(9));
        tags.put("action", new Integer(10));
        tags.put("instancetree", new Integer(11));
        tags.put("type", new Integer(12));
        tags.put("typetree", new Integer(13));
        tags.put("layer", new Integer(14));
        tags.put("point", new Integer(15));
        attributes = new HashMap();
        attributes.put("version", new Integer(5));
        attributes.put("xmlns", new Integer(6));
        attributes.put("xmlns:xsi", new Integer(7));
        attributes.put("xsi:schemaLocation", new Integer(8));
        attributes.put("valueString", new Integer(16));
        attributes.put("valueColor", new Integer(17));
        attributes.put("valueLong", new Integer(18));
        attributes.put("valueInt", new Integer(19));
        attributes.put("valueBoolean", new Integer(20));
        attributes.put("valueDouble", new Integer(21));
        attributes.put("name", new Integer(32));
        attributes.put("type", new Integer(34));
        attributes.put("showlabel", new Integer(35));
        attributes.put("desc", new Integer(36));
        attributes.put("category", new Integer(37));
        attributes.put("extra", new Integer(38));
        attributes.put("x", new Integer(39));
        attributes.put("y", new Integer(40));
        attributes.put("z", new Integer(41));
        attributes.put("qualifier", new Integer(42));
        attributes.put("expression", new Integer(43));
        attributes.put("typetreename", new Integer(44));
        attributes.put("typetreeversion", new Integer(45));
        attributes.put("order", new Integer(46));
        attributes.put("eof", new Integer(127));
        values = new HashMap();
        values.put("drawas", new Integer(133));
        values.put("drawasoptions", new Integer(134));
        values.put("visibility", new Integer(135));
        values.put("label", new Integer(136));
        values.put("fontname", new Integer(137));
        values.put("fontstyle", new Integer(138));
        values.put("fontsize", new Integer(139));
        values.put("fontcolor", new Integer(140));
        values.put("fonthasframe", new Integer(141));
        values.put("fontframecolor", new Integer(142));
        values.put("fontframewidth", new Integer(143));
        values.put("fonthasbanner", new Integer(144));
        values.put("fontbannercolor", new Integer(145));
        values.put("color", new Integer(146));
        values.put("framecolor", new Integer(147));
        values.put("layer", new Integer(148));
        values.put("markname", new Integer(149));
        values.put("marksize", new Integer(150));
        values.put("marksizemultiplier", new Integer(151));
        values.put("marktype", new Integer(152));
        values.put("hasframe", new Integer(153));
        values.put("framecolor", new Integer(154));
        values.put("framewidth", new Integer(155));
        values.put("linestyle", new Integer(156));
        values.put("linewidth", new Integer(157));
        values.put("linewidthmultiplier", new Integer(158));
        values.put("linehasarrow", new Integer(159));
        values.put("fillcolor", new Integer(160));
        values.put("filltype", new Integer(161));
        values.put("fill", new Integer(162));
        values.put("radius", new Integer(163));
        values.put("phi", new Integer(164));
        values.put("theta", new Integer(165));
        values.put("omega", new Integer(166));
        values.put("radius1", new Integer(167));
        values.put("radius2", new Integer(168));
        values.put("radius3", new Integer(169));
        values.put("curvature", new Integer(170));
        values.put("flylength", new Integer(171));
        values.put("faces", new Integer(172));
        values.put("text", new Integer(173));
        values.put("hpos", new Integer(174));
        values.put("vpos", new Integer(175));
        values.put("halign", new Integer(176));
        values.put("valign", new Integer(177));
        values.put("ispickable", new Integer(178));
        values.put("showparentvalues", new Integer(179));
        values.put("pickparent", new Integer(180));
        values.put("false", new Integer(208));
        values.put("true", new Integer(209));
        values.put("point", new Integer(210));
        values.put("line", new Integer(211));
        values.put("helix", new Integer(212));
        values.put("polygon", new Integer(213));
        values.put("circle", new Integer(214));
        values.put("curve", new Integer(215));
        values.put("ellipse", new Integer(216));
        values.put("ellipsoid", new Integer(217));
        values.put("prism", new Integer(218));
        values.put("cylinder", new Integer(219));
        values.put("ellipseprism", new Integer(220));
        values.put("text", new Integer(221));
        values.put("nonzero", new Integer(222));
        values.put("evenodd", new Integer(223));
        values.put("circle", new Integer(224));
        values.put("box", new Integer(225));
        values.put("uptriangle", new Integer(226));
        values.put("dntriangle", new Integer(227));
        values.put("diamond", new Integer(228));
        values.put("cross", new Integer(229));
        values.put("star", new Integer(230));
        values.put("plus", new Integer(231));
        values.put("hline", new Integer(232));
        values.put("vline", new Integer(233));
        values.put("solid", new Integer(234));
        values.put("dotted", new Integer(235));
        values.put("dashed", new Integer(236));
        values.put("dotdash", new Integer(237));
        values.put("none", new Integer(238));
        values.put("start", new Integer(239));
        values.put("end", new Integer(240));
        values.put("both", new Integer(241));
        values.put("serif", new Integer(242));
        values.put("sansserif", new Integer(243));
        values.put("monotype", new Integer(244));
        values.put("symbol", new Integer(245));
        values.put("plain", new Integer(246));
        values.put("bold", new Integer(247));
        values.put("italic", new Integer(248));
        values.put("top", new Integer(249));
        values.put("baseline", new Integer(250));
        values.put("center", new Integer(251));
        values.put("bottom", new Integer(252));
        values.put("left", new Integer(253));
        values.put("right", new Integer(254));
        values.put("default", new Integer(255));
    }
}

