/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.wbxml;

import hep.graphics.heprep.wbxml.WbxmlParser;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class BHepRepParser
extends WbxmlParser {
    protected static final int HEPREP = 5;
    protected static final int ATTDEF = 6;
    protected static final int ATTVALUE = 7;
    protected static final int INSTANCE = 8;
    protected static final int TREEID = 9;
    protected static final int ACTION = 10;
    protected static final int INSTANCETREE = 11;
    protected static final int TYPE = 12;
    protected static final int TYPETREE = 13;
    protected static final int LAYER = 14;
    protected static final int POINT = 15;
    private static final String[] tags = new String[]{"heprep", "attdef", "attvalue", "instance", "treeid", "action", "instancetree", "type", "typetree", "layer", "point"};
    protected static final int VALUE_STRING = 16;
    protected static final int VALUE_COLOR = 17;
    protected static final int VALUE_LONG = 18;
    protected static final int VALUE_INT = 19;
    protected static final int VALUE_BOOLEAN = 20;
    protected static final int VALUE_DOUBLE = 21;
    protected static final int EOF = 127;
    private static final String[] attributes = new String[]{"version", "xmlns", "xmlns:xsi", "xsi:schemaLocation", null, null, null, null, null, null, null, "valueString", "valueColor", "valueLong", "valueInt", "valueBoolean", "valueDouble", null, null, null, null, null, null, null, null, null, null, "name", null, "type", "showlabel", "desc", "category", "extra", "x", "y", "z", "qualifier", "expression", "typetreename", "typetreeversion", "order", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "eof"};
    private static final String[] values = new String[]{"drawas", "drawasoptions", "visibility", "label", "fontname", "fontstyle", "fontsize", "fontcolor", "fonthasframe", "fontframecolor", "fontframewidth", "fonthasbanner", "fontbannercolor", "color", "framecolor", "layer", "markname", "marksize", "marksizemultiplier", "marktype", "hasframe", "framecolor", "framewidth", "linestyle", "linewidth", "linewidthmultiplier", "linehasarrow", "fillcolor", "filltype", "fill", "radius", "phi", "theta", "omega", "radius1", "radius2", "radius3", "curvature", "flylength", "faces", "text", "hpos", "vpos", "halign", "valign", "ispickable", "showparentvalues", "pickparent", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "false", "true", "point", "line", "helix", "polygon", "circle", "curve", "ellipse", "ellipsoid", "prism", "cylinder", "ellipseprism", "text", "nonzero", "evenodd", "circle", "box", "uptriangle", "dntriangle", "diamond", "cross", "star", "plus", "hline", "vline", "solid", "dotted", "dashed", "dotdash", "none", "start", "end", "both", "serif", "sansserif", "monotype", "symbol", "plain", "bold", "italic", "top", "baseline", "center", "bottom", "left", "right", "default"};
    private List strings = new ArrayList();
    private double[] points = new double[32];

    public BHepRepParser() {
        this.setTagTable(0, tags);
        this.setAttrStartTable(0, attributes);
        this.setAttrValueTable(0, values);
    }

    @Override
    protected void processInstruction() throws IOException, XmlPullParserException {
        super.processInstruction();
        if (this.getAttributeValue("eof") != null) {
            this.type = 1;
        }
    }

    @Override
    protected Object parseExtension(int id, int tagId, int attId) throws IOException, XmlPullParserException {
        Object param = super.parseExtension(id, tagId, attId);
        switch (id) {
            case 64: {
                this.strings.add(param.toString());
                break;
            }
            case 128: {
                param = this.strings.get((Integer)param);
                break;
            }
        }
        return param;
    }

    @Override
    protected Object parseOpaque(int len, int tagId, int attId) throws IOException, XmlPullParserException {
        block0 : switch (tagId) {
            case 0: {
                if (len % 12 != 0) break;
                int n = len / 4;
                if (n > this.points.length) {
                    this.points = new double[Math.max(this.points.length * 2, n)];
                }
                for (int i = 0; i < n; ++i) {
                    this.points[i] = this.readFloat();
                }
                return this.points;
            }
            case 7: {
                switch (attId) {
                    case 16: {
                        break block0;
                    }
                    case 17: {
                        int r = this.readByte();
                        int g = this.readByte();
                        int b = this.readByte();
                        int a = len == 4 ? this.readByte() : 255;
                        return new Color(r, g, b, a);
                    }
                    case 18: {
                        return new Long(this.readInt64());
                    }
                    case 19: {
                        return new Integer(this.readInt32());
                    }
                    case 20: {
                        break block0;
                    }
                    case 21: {
                        return new Double(this.readFloat());
                    }
                }
                break;
            }
        }
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)this.readByte();
        }
        System.out.println("WARNING: Unknown OPAQUE with length: " + len);
        return buf;
    }
}

