/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepInstance;
import hep.graphics.heprep.ref.DefaultHepRepTreeID;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultHepRepInstanceTree
extends DefaultHepRepTreeID
implements HepRepInstanceTree,
Serializable {
    private HepRepTreeID typeTree;
    private Set instanceTrees = new HashSet();
    private List instanceTreeList = new ArrayList();
    private List instanceList;

    protected DefaultHepRepInstanceTree(String name, String version, HepRepTreeID typeTree) {
        super(name, version);
        this.typeTree = typeTree;
    }

    @Override
    public void overlay(HepRepInstanceTree instanceTree) {
        if (!this.typeTree.equals(instanceTree.getTypeTree())) {
            throw new RuntimeException("HepRepInstanceTree cannot overlay; different typeTrees given.");
        }
        if (this.getInstanceTreeList().size() != instanceTree.getInstanceTreeList().size()) {
            throw new RuntimeException("HepRepInstanceTree cannot overlay; number of related instanceTrees not equal.");
        }
        if (this.getInstances().size() != instanceTree.getInstances().size()) {
            throw new RuntimeException("HepRepInstanceTree cannot overlay; structure incompatible.");
        }
        Iterator j = instanceTree.getInstances().iterator();
        for (HepRepInstance instance : this.getInstances()) {
            instance.overlay((HepRepInstance)j.next());
        }
    }

    @Override
    public HepRepInstanceTree copy(HepRepTypeTree typeTree) throws CloneNotSupportedException {
        return this.copy(typeTree, null);
    }

    @Override
    public HepRepInstanceTree copy(HepRepTypeTree typeTree, HepRepSelectFilter filter) throws CloneNotSupportedException {
        DefaultHepRepInstanceTree copy = new DefaultHepRepInstanceTree(this.getName(), this.getVersion(), typeTree);
        for (HepRepInstance instance : this.getInstances()) {
            if (filter != null && !filter.select(instance)) continue;
            instance.copy(typeTree, copy, filter);
        }
        for (HepRepTreeID id : this.getInstanceTreeList()) {
            copy.addInstanceTree(new DefaultHepRepTreeID(id.getName(), id.getVersion(), id.getQualifier()));
        }
        return copy;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    public void addInstance(HepRepInstance instance) {
        if (this.instanceList == null) {
            this.instanceList = new ArrayList();
        }
        this.instanceList.add(instance);
    }

    @Override
    public void removeInstance(HepRepInstance instance) throws UnsupportedOperationException {
        if (this.instanceList != null) {
            this.instanceList.remove(instance);
        }
    }

    @Override
    public List getInstances() {
        if (this.instanceList == null) {
            return Collections.EMPTY_LIST;
        }
        return this.instanceList;
    }

    @Override
    public void addInstanceTree(HepRepTreeID instanceTree) {
        instanceTree.setQualifier("relatedinstancetree");
        this.instanceTrees.add(instanceTree);
        this.instanceTreeList.add(instanceTree);
    }

    @Override
    public HepRepTreeID getTypeTree() {
        return this.typeTree;
    }

    @Override
    public Set getInstanceTrees() {
        return this.instanceTrees;
    }

    @Override
    public List getInstanceTreeList() {
        return this.instanceTreeList;
    }

    @Override
    public String toString() {
        return "HepRepInstanceTree: " + this.getQualifier() + ":" + this.getName() + ":" + this.getVersion();
    }

    public void display(String indent) {
        System.out.println(indent + this.toString());
        int n = 0;
        int p = 0;
        int v = 0;
        for (DefaultHepRepInstance instance : this.getInstances()) {
            n += instance.getNoOfInstances();
            p += instance.getNoOfPoints();
            v += instance.getNoOfAttValues();
        }
        System.out.println(indent + "   #Instances: " + n);
        System.out.println(indent + "   #Points: " + p);
        System.out.println(indent + "   #Atts: " + v);
    }
}

