/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corba;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.corba.HepRepInstanceAdapter;
import hep.graphics.heprep.corba.HepRepTreeIDAdapter;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class HepRepInstanceTreeAdapter
implements HepRepInstanceTree {
    private HepRep heprep;
    private hep.graphics.heprep.corba.idl.HepRepInstanceTree hepRepInstanceTree;
    private transient List instances;

    public HepRepInstanceTreeAdapter(HepRep heprep, hep.graphics.heprep.corba.idl.HepRepInstanceTree hepRepInstanceTree) {
        this.heprep = heprep;
        this.hepRepInstanceTree = hepRepInstanceTree;
    }

    @Override
    public void overlay(HepRepInstanceTree instanceTree) {
        throw new RuntimeException("HepRepInstanceTreeAdapter.overlay is not implemented.");
    }

    @Override
    public HepRepInstanceTree copy(HepRepTypeTree typeTree) throws CloneNotSupportedException {
        return this.copy(typeTree, null);
    }

    @Override
    public HepRepInstanceTree copy(HepRepTypeTree typeTree, HepRepSelectFilter filter) throws CloneNotSupportedException {
        DefaultHepRepFactory factory = new DefaultHepRepFactory();
        HepRepInstanceTree copy = ((HepRepFactory)factory).createHepRepInstanceTree(this.getName(), this.getVersion(), this.getTypeTree());
        for (HepRepInstance instance : this.getInstances()) {
            if (filter != null && !filter.select(instance)) continue;
            copy.addInstance(instance.copy(typeTree, copy, filter));
        }
        for (HepRepTreeID id : this.getInstanceTreeList()) {
            copy.addInstanceTree(((HepRepFactory)factory).createHepRepTreeID(id.getName(), id.getVersion(), id.getQualifier()));
        }
        return copy;
    }

    @Override
    public String getQualifier() {
        return "top-level";
    }

    @Override
    public void setQualifier(String qualifier) {
        throw new UnsupportedOperationException("HepRepInstanceTreeAdapter.setQualifier is not implemented.");
    }

    @Override
    public String getName() {
        return this.hepRepInstanceTree.id.name;
    }

    @Override
    public String getVersion() {
        return this.hepRepInstanceTree.id.version;
    }

    @Override
    public List getInstances() {
        if (this.instances == null) {
            this.instances = new LinkedList();
            int n = this.hepRepInstanceTree.instances.length;
            HepRepTreeIDAdapter treeID = new HepRepTreeIDAdapter(this.hepRepInstanceTree.typeTreeID);
            HepRepTypeTree typeTree = this.heprep.getTypeTree(treeID.getName(), treeID.getVersion());
            for (int i = 0; i < n; ++i) {
                this.instances.add(new HepRepInstanceAdapter(typeTree, this.hepRepInstanceTree.instances[i], null));
            }
        }
        return this.instances;
    }

    @Override
    public void addInstance(HepRepInstance instance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceTreeAdapter.addInstance is not implemented.");
    }

    @Override
    public void addInstanceTree(HepRepTreeID instanceTree) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceTreeAdapter.addInstanceTree is not implemented.");
    }

    @Override
    public void removeInstance(HepRepInstance instance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HepRepInstanceAdapter.removeInstance is not implemented.");
    }

    @Override
    public HepRepTreeID getTypeTree() {
        return new HepRepTreeIDAdapter(this.hepRepInstanceTree.typeTreeID);
    }

    @Override
    public Set getInstanceTrees() {
        int n = this.hepRepInstanceTree.instanceTreeIDs.length;
        HashSet<HepRepTreeIDAdapter> out = new HashSet<HepRepTreeIDAdapter>(n);
        for (int i = 0; i < n; ++i) {
            out.add(new HepRepTreeIDAdapter(this.hepRepInstanceTree.instanceTreeIDs[i]));
        }
        return out;
    }

    @Override
    public List getInstanceTreeList() {
        int n = this.hepRepInstanceTree.instanceTreeIDs.length;
        ArrayList<HepRepTreeIDAdapter> out = new ArrayList<HepRepTreeIDAdapter>(n);
        for (int i = 0; i < n; ++i) {
            out.add(new HepRepTreeIDAdapter(this.hepRepInstanceTree.instanceTreeIDs[i]));
        }
        return out;
    }

    public String toString() {
        return "[HepRepInstanceTree (corba):" + this.getQualifier() + ":" + this.getName() + ":" + this.getVersion() + "]";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof HepRepInstanceTree) {
            HepRepInstanceTree ref = (HepRepInstanceTree)o;
            if (!ref.getTypeTree().getName().equals(this.getTypeTree().getName())) {
                return false;
            }
            if (!ref.getTypeTree().getVersion().equals(this.getTypeTree().getVersion())) {
                return false;
            }
            if (!ref.getInstances().equals(this.getInstances())) {
                return false;
            }
            return ref.getInstanceTreeList().equals(this.getInstanceTreeList());
        }
        return false;
    }

    public int hashCode() {
        long code = this.getTypeTree().hashCode();
        code += (long)this.getInstances().hashCode();
        return (int)(code += (long)this.getInstanceTreeList().hashCode());
    }
}

