/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corba;

import hep.graphics.heprep.HepRepTypeException;
import hep.graphics.heprep.corba.idl.HepRepAttValue;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import hep.graphics.heprep.util.HepRepColor;
import hep.graphics.heprep.util.HepRepUtil;
import java.awt.Color;

public class HepRepAttValueAdapter
implements hep.graphics.heprep.HepRepAttValue {
    private HepRepAttValue hepRepAttValue;
    private String lowerCaseName;
    private int type;
    private Color color;

    public HepRepAttValueAdapter(HepRepAttValue hepRepAttValue) {
        this.hepRepAttValue = hepRepAttValue;
        this.lowerCaseName = hepRepAttValue.name.toLowerCase().intern();
        this.type = 0;
        this.color = null;
    }

    @Override
    public hep.graphics.heprep.HepRepAttValue copy() throws CloneNotSupportedException {
        switch (this.getType()) {
            case 1: {
                return new DefaultHepRepAttValue(this.getName(), this.getString(), this.showLabel());
            }
            case 2: {
                return new DefaultHepRepAttValue(this.getName(), this.getColor(), this.showLabel());
            }
            case 11: {
                return new DefaultHepRepAttValue(this.getName(), this.getInteger(), this.showLabel());
            }
            case 10: {
                return new DefaultHepRepAttValue(this.getName(), this.getLong(), this.showLabel());
            }
            case 20: {
                return new DefaultHepRepAttValue(this.getName(), this.getDouble(), this.showLabel());
            }
            case 30: {
                return new DefaultHepRepAttValue(this.getName(), this.getBoolean(), this.showLabel());
            }
        }
        throw new CloneNotSupportedException("Type not supported: " + this.getType());
    }

    @Override
    public String getName() {
        return this.hepRepAttValue.name;
    }

    @Override
    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    @Override
    public int getType() {
        if (this.type == 0) {
            switch (this.hepRepAttValue.value.type().kind().value()) {
                case 18: 
                case 27: {
                    String typeName = DefaultHepRepAttValue.guessType(this.getName(), null, null);
                    this.type = DefaultHepRepAttValue.toType(typeName);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    this.type = 11;
                    break;
                }
                case 23: 
                case 24: {
                    this.type = 10;
                    break;
                }
                case 6: 
                case 7: 
                case 25: {
                    this.type = 20;
                    break;
                }
                case 8: {
                    this.type = 30;
                    break;
                }
                default: {
                    this.type = -1;
                }
            }
        }
        return this.type;
    }

    @Override
    public String getTypeName() {
        return DefaultHepRepAttValue.toString(this.getType());
    }

    @Override
    public int showLabel() {
        return this.hepRepAttValue.showLabel;
    }

    @Override
    public String getString() throws HepRepTypeException {
        switch (this.hepRepAttValue.value.type().kind().value()) {
            case 18: {
                return this.hepRepAttValue.value.extract_string().intern();
            }
            case 27: {
                return this.hepRepAttValue.value.extract_wstring().intern();
            }
        }
        throw new HepRepTypeException("Attribute Value of type '" + this.getTypeName() + "' cannot be converted to type 'String'");
    }

    @Override
    public String getLowerCaseString() throws HepRepTypeException {
        return this.getString().toLowerCase().intern();
    }

    @Override
    public Color getColor() throws HepRepTypeException {
        if (this.color == null) {
            this.color = HepRepColor.get(this.getString());
        }
        return this.color;
    }

    @Override
    public long getLong() throws HepRepTypeException {
        switch (this.hepRepAttValue.value.type().kind().value()) {
            case 23: {
                return this.hepRepAttValue.value.extract_longlong();
            }
            case 24: {
                return this.hepRepAttValue.value.extract_ulonglong();
            }
        }
        throw new HepRepTypeException("Attribute Value of type '" + this.getTypeName() + "' cannot be converted to type 'long'");
    }

    @Override
    public int getInteger() throws HepRepTypeException {
        switch (this.hepRepAttValue.value.type().kind().value()) {
            case 2: {
                return this.hepRepAttValue.value.extract_short();
            }
            case 3: {
                return this.hepRepAttValue.value.extract_long();
            }
            case 4: {
                return this.hepRepAttValue.value.extract_ushort();
            }
            case 5: {
                return this.hepRepAttValue.value.extract_ulong();
            }
        }
        throw new HepRepTypeException("Attribute Value of type '" + this.getTypeName() + "' cannot be converted to type 'int'");
    }

    @Override
    public double getDouble() throws HepRepTypeException {
        switch (this.hepRepAttValue.value.type().kind().value()) {
            case 7: 
            case 25: {
                return this.hepRepAttValue.value.extract_double();
            }
            case 6: {
                return this.hepRepAttValue.value.extract_float();
            }
        }
        throw new HepRepTypeException("Attribute Value of type '" + this.getTypeName() + "' cannot be converted to type 'double'");
    }

    @Override
    public boolean getBoolean() throws HepRepTypeException {
        switch (this.hepRepAttValue.value.type().kind().value()) {
            case 8: {
                return this.hepRepAttValue.value.extract_boolean();
            }
            case 2: {
                return this.hepRepAttValue.value.extract_short() != 0;
            }
            case 3: {
                return this.hepRepAttValue.value.extract_long() != 0;
            }
            case 4: {
                return this.hepRepAttValue.value.extract_ushort() != 0;
            }
            case 5: {
                return this.hepRepAttValue.value.extract_ulong() != 0;
            }
        }
        throw new HepRepTypeException("Attribute Value of type '" + this.getTypeName() + "' cannot be converted to type 'boolean'");
    }

    @Override
    public String getAsString() {
        return DefaultHepRepAttValue.getAsString(this);
    }

    public String toString() {
        return this.getClass() + "[" + "name(lcase)=" + this.getLowerCaseName() + ", " + "value=" + this.getAsString() + ", " + "showLabel=" + DefaultHepRepAttValue.toShowLabel(this.showLabel()) + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof hep.graphics.heprep.HepRepAttValue) {
            boolean r;
            hep.graphics.heprep.HepRepAttValue attValue = (hep.graphics.heprep.HepRepAttValue)o;
            boolean bl = r = attValue.getLowerCaseName().equals(this.getLowerCaseName()) && attValue.getType() == this.getType() && attValue.showLabel() == this.showLabel();
            if (r) {
                switch (attValue.getType()) {
                    case 1: {
                        r = r && attValue.getString().equals(this.getString());
                        break;
                    }
                    case 2: {
                        r = r && attValue.getColor().equals(this.getColor());
                        break;
                    }
                    case 10: {
                        r = r && attValue.getLong() == this.getLong();
                        break;
                    }
                    case 11: {
                        r = r && attValue.getInteger() == this.getInteger();
                        break;
                    }
                    case 20: {
                        break;
                    }
                    case 30: {
                        r = r && attValue.getBoolean() == this.getBoolean();
                        break;
                    }
                    default: {
                        r = false;
                    }
                }
            }
            if (HepRepUtil.debug() && !r) {
                System.out.println(this + " != " + attValue);
            }
            return r;
        }
        return false;
    }

    public int hashCode() {
        long hash = this.getLowerCaseName().hashCode();
        hash |= (long)this.getType();
        hash |= (long)this.showLabel();
        switch (this.getType()) {
            default: {
                hash |= (long)this.getString().hashCode();
                break;
            }
            case 2: {
                hash |= (long)this.getColor().hashCode();
                break;
            }
            case 10: {
                hash |= this.getLong();
                break;
            }
            case 11: {
                hash |= (long)this.getInteger();
                break;
            }
            case 20: {
                hash |= Double.doubleToLongBits(this.getDouble());
                break;
            }
            case 30: {
                hash |= this.getBoolean() ? 1L : 2L;
            }
        }
        return (int)hash;
    }
}

