/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.test.pdf;

import hep.aida.IBaseHistogram;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IModelFunction;
import hep.aida.ref.pdf.FunctionConverter;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.test.pdf.AbstractPdfTestCase;
import java.util.Random;

public class Chi2GaussianFit
extends AbstractPdfTestCase {
    private IHistogram1D h1 = this.histogramFactory().createHistogram1D("Histogram 1D", 50, -10.0, 10.0);

    public Chi2GaussianFit(String name) {
        super(name);
        Random r = new Random();
        for (int i = 0; i < 100000; ++i) {
            this.h1.fill(r.nextGaussian());
        }
    }

    public void testFit() {
        Gaussian g = new Gaussian("myGauss");
        IModelFunction gauss = FunctionConverter.getIModelFunction(g);
        gauss.setParameter("norm", this.h1.maxBinHeight());
        gauss.setParameter("mean", this.h1.mean());
        gauss.setParameter("sigma", this.h1.rms());
        IFitter gaussFit = this.fitFactory().createFitter("Chi2", "minuit", "noClone=true");
        long start = System.currentTimeMillis();
        IFitResult gaussFitResult = gaussFit.fit((IBaseHistogram)this.h1, (IFunction)gauss);
        long end = System.currentTimeMillis();
        long time = end - start;
        Chi2GaussianFit.assertEquals((double)this.h1.mean(), (double)g.getParameter("mean").value(), (double)0.01);
        Chi2GaussianFit.assertEquals((double)this.h1.rms(), (double)g.getParameter("sigma").value(), (double)0.02);
        Chi2GaussianFit.assertEquals((double)this.h1.maxBinHeight(), (double)g.getParameter("norm").value(), (double)500.0);
        IFunction gauss2 = this.functionFactory().createFunctionByName("gauss", "g");
        gauss2.setParameter("amplitude", this.h1.maxBinHeight());
        gauss2.setParameter("mean", this.h1.mean());
        gauss2.setParameter("sigma", this.h1.rms());
        long start2 = System.currentTimeMillis();
        IFitResult gauss2FitResult = gaussFit.fit((IBaseHistogram)this.h1, gauss2);
        long end2 = System.currentTimeMillis();
        long time2 = end2 - start2;
        Chi2GaussianFit.assertEquals((double)gauss2FitResult.fittedFunction().parameter("amplitude"), (double)g.getParameter("norm").value(), (double)1.0E-5);
        Chi2GaussianFit.assertEquals((double)gauss2FitResult.fittedFunction().parameter("mean"), (double)g.getParameter("mean").value(), (double)1.0E-6);
        Chi2GaussianFit.assertEquals((double)gauss2FitResult.fittedFunction().parameter("sigma"), (double)g.getParameter("sigma").value(), (double)1.0E-6);
        Chi2GaussianFit.assertEquals((float)time, (float)100.0f, (float)10.0f);
    }
}

