/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.converters;

import hep.aida.IAnnotation;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.ref.Annotation;
import hep.aida.ref.remote.RemoteDataPointSet;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import hep.aida.ref.remote.rmi.data.RmiAnnotationItem;
import hep.aida.ref.remote.rmi.data.RmiDataPointSetData;
import java.text.DateFormat;
import java.util.Date;

public class RmiDataPointSetConverter
extends RmiConverter {
    private static RmiDataPointSetConverter converter = null;

    public static RmiDataPointSetConverter getInstance() {
        if (converter == null) {
            converter = new RmiDataPointSetConverter();
        }
        return converter;
    }

    private RmiDataPointSetConverter() {
        this.dataType = "RmiDataPointSetData";
        this.aidaType = "IDataPointSet";
    }

    @Override
    public Object createAidaObject(String name) {
        RemoteDataPointSet result = new RemoteDataPointSet(name);
        return result;
    }

    @Override
    public Object extractData(Object aidaObject) {
        if (!(aidaObject instanceof IDataPointSet)) {
            throw new IllegalArgumentException("Not supported data type: " + aidaObject.getClass().getName());
        }
        RmiDataPointSetData data = this.createData((IDataPointSet)aidaObject);
        return data;
    }

    @Override
    public boolean updateAidaObject(Object aidaObject, Object newData) {
        RmiDataPointSetData data = null;
        if (newData instanceof RmiDataPointSetData) {
            data = (RmiDataPointSetData)newData;
        }
        if (!(aidaObject instanceof RemoteDataPointSet)) {
            throw new IllegalArgumentException("Not supported object type: " + aidaObject.getClass().getName());
        }
        if (data == null || !(data instanceof RmiDataPointSetData)) {
            throw new IllegalArgumentException("Not supported data type: " + (newData == null ? "null" : newData.getClass().getName()));
        }
        this.updateData((RemoteDataPointSet)aidaObject, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject updateData(RemoteDataPointSet hist, RmiDataPointSetData data) {
        if (data == null) {
            return hist;
        }
        RemoteDataPointSet remoteDataPointSet = hist;
        synchronized (remoteDataPointSet) {
            hist.setFillable(true);
            RmiAnnotationItem[] items = data.getAnnotationItems();
            if (items != null && items.length > 0) {
                boolean sticky = false;
                IAnnotation localAnnotation = hist.annotation();
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(true);
                }
                for (int i = 0; i < items.length; ++i) {
                    String key = items[i].key;
                    String newValue = items[i].value;
                    String oldValue = null;
                    try {
                        oldValue = localAnnotation.value(key);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (oldValue == null) {
                        localAnnotation.addItem(key, newValue, sticky);
                        continue;
                    }
                    if (newValue.equals(oldValue)) continue;
                    localAnnotation.setValue(key, newValue);
                    localAnnotation.setSticky(key, sticky);
                }
                Date date = new Date();
                DateFormat df = DateFormat.getTimeInstance();
                String dateString = df.format(date);
                try {
                    String value = localAnnotation.value("stat.Updated");
                    if (value == null || value.equals("0") || value.equals("")) {
                        localAnnotation.setValue("stat.Updated", dateString);
                    }
                }
                catch (IllegalArgumentException e) {
                    localAnnotation.addItem("stat.Updated", dateString);
                }
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(false);
                }
            }
            hist.setDimension(data.getDimension());
            hist.setUpperExtent(data.getUpperExtent());
            hist.setLowerExtent(data.getLowerExtent());
            hist.setValues(data.getValues());
            hist.setPlusErrors(data.getPlusErrors());
            hist.setMinusErrors(data.getMinusErrors());
            hist.setFillable(false);
            hist.setDataValid(true);
        }
        return hist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiDataPointSetData createData(IDataPointSet hist) {
        RmiDataPointSetData data = new RmiDataPointSetData();
        RmiAnnotationItem[] rAnnotation = null;
        int dimension = 0;
        double[] upperExtent = null;
        double[] lowerExtent = null;
        double[] values = null;
        double[] plusErrors = null;
        double[] minusErrors = null;
        Object xAxisType = null;
        Object yAxisType = null;
        long timeOfLastUpdate = 0L;
        IDataPointSet iDataPointSet = hist;
        synchronized (iDataPointSet) {
            boolean sticky = false;
            IAnnotation lAnnotation = hist.annotation();
            if (lAnnotation != null && lAnnotation.size() > 0) {
                rAnnotation = new RmiAnnotationItem[lAnnotation.size()];
                for (int i = 0; i < lAnnotation.size(); ++i) {
                    String key = lAnnotation.key(i);
                    String value = lAnnotation.value(key);
                    rAnnotation[i] = new RmiAnnotationItem(key, value, sticky);
                }
            }
            int nPoints = hist.size();
            dimension = hist.dimension();
            if (nPoints > 0) {
                upperExtent = new double[dimension];
                lowerExtent = new double[dimension];
                values = new double[dimension * nPoints];
                plusErrors = new double[dimension * nPoints];
                minusErrors = new double[dimension * nPoints];
                for (int dim = 0; dim < dimension; ++dim) {
                    upperExtent[dim] = hist.upperExtent(dim);
                    lowerExtent[dim] = hist.lowerExtent(dim);
                }
                int index = 0;
                for (int ip = 0; ip < nPoints; ++ip) {
                    IDataPoint p = hist.point(ip);
                    for (int dim = 0; dim < dimension; ++dim) {
                        index = ip * dimension + dim;
                        IMeasurement m = p.coordinate(dim);
                        values[index] = m.value();
                        plusErrors[index] = m.errorPlus();
                        minusErrors[index] = m.errorMinus();
                    }
                }
            }
            if (hist instanceof RemoteManagedObject) {
                RemoteManagedObject rdps = (RemoteManagedObject)hist;
            }
        }
        data.setAnnotationItems(rAnnotation);
        data.setDimension(dimension);
        data.setUpperExtent(upperExtent);
        data.setLowerExtent(lowerExtent);
        data.setValues(values);
        data.setPlusErrors(plusErrors);
        data.setMinusErrors(minusErrors);
        return data;
    }
}

