/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.converters;

import hep.aida.IAnnotation;
import hep.aida.ICloud2D;
import hep.aida.IHistogram2D;
import hep.aida.IManagedObject;
import hep.aida.ref.Annotation;
import hep.aida.ref.remote.RemoteCloud2D;
import hep.aida.ref.remote.RemoteHistogram2D;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import hep.aida.ref.remote.rmi.converters.RmiHist2DConverter;
import hep.aida.ref.remote.rmi.data.RmiAnnotationItem;
import hep.aida.ref.remote.rmi.data.RmiCloud2DData;
import hep.aida.ref.remote.rmi.data.RmiHist2DData;
import java.text.DateFormat;
import java.util.Date;

public class RmiCloud2DConverter
extends RmiConverter {
    private static RmiCloud2DConverter converter = null;

    public static RmiCloud2DConverter getInstance() {
        if (converter == null) {
            converter = new RmiCloud2DConverter();
        }
        return converter;
    }

    private RmiCloud2DConverter() {
        this.dataType = "RmiCloud2DData";
        this.aidaType = "ICloud2D";
    }

    @Override
    public Object createAidaObject(String name) {
        RemoteCloud2D result = new RemoteCloud2D(name);
        return result;
    }

    @Override
    public Object extractData(Object aidaObject) {
        RmiCloud2DData data = null;
        if (aidaObject instanceof ICloud2D) {
            data = this.createData((ICloud2D)aidaObject);
        } else if (aidaObject instanceof Object[] && ((Object[])aidaObject)[0] instanceof ICloud2D) {
            ICloud2D[] arr = new ICloud2D[((Object[])aidaObject).length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (ICloud2D)((Object[])aidaObject)[i];
            }
            data = this.createData(arr);
        } else {
            throw new IllegalArgumentException("Not supported data type: " + aidaObject.getClass().getName());
        }
        return data;
    }

    @Override
    public boolean updateAidaObject(Object aidaObject, Object newData) {
        RmiCloud2DData data = null;
        if (newData instanceof RmiCloud2DData) {
            data = (RmiCloud2DData)newData;
        }
        if (!(aidaObject instanceof RemoteCloud2D)) {
            throw new IllegalArgumentException("Not supported object type: " + aidaObject.getClass().getName());
        }
        if (data == null || !(data instanceof RmiCloud2DData)) {
            throw new IllegalArgumentException("Not supported data type: " + (newData == null ? "null" : newData.getClass().getName()));
        }
        this.updateData((RemoteCloud2D)aidaObject, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject updateData(RemoteCloud2D cloud, RmiCloud2DData data) {
        if (data == null) {
            return cloud;
        }
        RemoteCloud2D remoteCloud2D = cloud;
        synchronized (remoteCloud2D) {
            cloud.setFillable(true);
            RmiHist2DData histData = data.getHist();
            RemoteHistogram2D hist = (RemoteHistogram2D)cloud.histogram();
            RmiHist2DConverter.getInstance().updateData(hist, histData);
            hist.setFillable(true);
            hist.setDataValid(true);
            Date date = new Date();
            DateFormat df = DateFormat.getTimeInstance();
            String dateString = df.format(date);
            IAnnotation localAnnotation = cloud.annotation();
            if (localAnnotation instanceof Annotation) {
                ((Annotation)localAnnotation).setFillable(true);
            }
            try {
                String value = localAnnotation.value("stat.Updated");
                if (value == null || value.equals("0") || value.equals("")) {
                    localAnnotation.setValue("stat.Updated", dateString);
                }
            }
            catch (IllegalArgumentException e) {
                localAnnotation.addItem("stat.Updated", dateString);
            }
            if (localAnnotation instanceof Annotation) {
                ((Annotation)localAnnotation).setFillable(false);
            }
            cloud.setConverted(data.getConverted());
            cloud.setEntries(data.getEntries());
            cloud.setSummOfWeights(data.getSumOfWeights());
            cloud.setMaxEntries(data.getMaxEntries());
            cloud.setNanEntries(data.getNanEntries());
            cloud.setLowerEdgeX(data.getLowerEdgeX());
            cloud.setLowerEdgeY(data.getLowerEdgeY());
            cloud.setUpperEdgeX(data.getUpperEdgeX());
            cloud.setUpperEdgeY(data.getUpperEdgeY());
            cloud.setMeanX(data.getMeanX());
            cloud.setMeanY(data.getMeanY());
            cloud.setRmsX(data.getRmsX());
            cloud.setRmsY(data.getRmsY());
            cloud.setValuesX(data.getValuesX());
            cloud.setValuesY(data.getValuesY());
            cloud.setWeights(data.getWeights());
            cloud.setFillable(false);
            cloud.setDataValid(true);
        }
        return cloud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiCloud2DData createData(ICloud2D cloud) {
        RmiCloud2DData data = new RmiCloud2DData();
        RmiHist2DData histData = null;
        RmiAnnotationItem[] rAnnotation = null;
        boolean isConverted = false;
        int maxEntries = 0;
        int nanEntries = 0;
        int entries = 0;
        double sumOfWeights = 0.0;
        double lowerEdgeX = Double.NaN;
        double lowerEdgeY = Double.NaN;
        double upperEdgeX = Double.NaN;
        double upperEdgeY = Double.NaN;
        double meanX = Double.NaN;
        double meanY = Double.NaN;
        double rmsX = Double.NaN;
        double rmsY = Double.NaN;
        double[] valuesX = null;
        double[] valuesY = null;
        double[] weights = null;
        ICloud2D iCloud2D = cloud;
        synchronized (iCloud2D) {
            isConverted = cloud.isConverted();
            maxEntries = cloud.maxEntries();
            nanEntries = cloud.nanEntries();
            entries = cloud.entries();
            sumOfWeights = cloud.sumOfWeights();
            lowerEdgeX = cloud.lowerEdgeX();
            lowerEdgeY = cloud.lowerEdgeY();
            upperEdgeX = cloud.upperEdgeX();
            upperEdgeY = cloud.upperEdgeY();
            if (isConverted) {
                IHistogram2D hist = cloud.histogram();
                histData = RmiHist2DConverter.getInstance().createData(hist);
            } else {
                int i;
                boolean sticky = false;
                IAnnotation lAnnotation = cloud.annotation();
                if (lAnnotation != null && lAnnotation.size() > 0) {
                    rAnnotation = new RmiAnnotationItem[lAnnotation.size()];
                    for (i = 0; i < lAnnotation.size(); ++i) {
                        String key = lAnnotation.key(i);
                        String value = lAnnotation.value(key);
                        rAnnotation[i] = new RmiAnnotationItem(key, value, sticky);
                    }
                }
                meanX = cloud.meanX();
                meanY = cloud.meanY();
                rmsX = cloud.rmsX();
                rmsY = cloud.rmsY();
                if (entries > 0) {
                    valuesX = new double[entries];
                    valuesY = new double[entries];
                    weights = new double[entries];
                    i = 0;
                    for (i = 0; i < entries; ++i) {
                        valuesX[i] = cloud.valueX(i);
                        valuesY[i] = cloud.valueY(i);
                        weights[i] = cloud.weight(i);
                    }
                }
            }
        }
        if (isConverted) {
            data.setHist(histData);
        } else {
            histData = new RmiHist2DData();
            histData.setAnnotationItems(rAnnotation);
        }
        data.setValuesX(valuesX);
        data.setValuesY(valuesY);
        data.setWeights(weights);
        data.setConverted(isConverted);
        data.setEntries(entries);
        data.setSumOfWeights(sumOfWeights);
        data.setMaxEntries(maxEntries);
        data.setNanEntries(nanEntries);
        data.setLowerEdgeX(lowerEdgeX);
        data.setLowerEdgeY(lowerEdgeY);
        data.setUpperEdgeX(upperEdgeX);
        data.setUpperEdgeY(upperEdgeY);
        data.setMeanX(meanX);
        data.setMeanY(meanY);
        data.setRmsX(rmsX);
        data.setRmsY(rmsY);
        return data;
    }

    public RmiCloud2DData createData(ICloud2D[] arr) {
        RmiCloud2DData[] allData = new RmiCloud2DData[arr.length];
        for (int i = 0; i < allData.length; ++i) {
            allData[i] = this.createData(arr[i]);
        }
        return allData[0];
    }
}

