/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.dev.IDevTree;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.RemoteServant;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RemoteServer
implements AidaTreeServer,
AIDAListener {
    private IDevTree tree;
    private String treeName;
    private boolean duplex;
    protected boolean blocking;
    private boolean useValidation;
    private boolean appendAxisType;
    private Map servantHash;
    private boolean acceptNewConnections;
    private long timeOut;
    protected Logger remoteLogger;

    public RemoteServer(IDevTree tree) {
        this(tree, true);
    }

    public RemoteServer(IDevTree tree, boolean duplex) {
        this(tree, duplex, false);
    }

    public RemoteServer(IDevTree tree, boolean duplex, boolean appendAxisType) {
        this.tree = tree;
        this.duplex = duplex;
        this.blocking = false;
        this.appendAxisType = appendAxisType;
        this.useValidation = true;
        this.treeName = tree.storeName();
        this.servantHash = new Hashtable();
        this.acceptNewConnections = true;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.timeOut = 5000L;
        if (tree instanceof IsObservable) {
            ((IsObservable)((Object)tree)).addListener(this);
        }
    }

    public void setBlocking(boolean b) {
        this.blocking = b;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setTimeout(long t) {
        this.timeOut = t;
    }

    public long getTimeout() {
        return this.timeOut;
    }

    public synchronized void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AidaTreeServant connect(Object clientRef) {
        this.remoteLogger.info("New connection from Client:  " + clientRef + ", acceptNewConnections=" + this.acceptNewConnections);
        if (clientRef == null) {
            throw new RemoteConnectionException("Can not connect with NULL Client Reference.");
        }
        AidaTreeServant servant = null;
        if (!this.acceptNewConnections) {
            return servant;
        }
        Map map = this.servantHash;
        synchronized (map) {
            servant = (AidaTreeServant)this.servantHash.get(clientRef);
            if (servant != null) {
                throw new RemoteConnectionException("This client is already connected. Please disconnect first.\nClient: " + clientRef.toString());
            }
            if (clientRef instanceof String) {
                servant = new RemoteServant(this.tree, (String)clientRef);
                boolean tmpBlocking = this.blocking;
                if (((String)clientRef).indexOf("blocking") >= 0) {
                    tmpBlocking = true;
                }
                ((RemoteServant)servant).setBlocking(tmpBlocking);
            } else if (clientRef instanceof AidaTreeClient) {
                servant = new RemoteServant(this.tree, (AidaTreeClient)clientRef);
            }
            ((RemoteServant)servant).setAppendAxisType(this.appendAxisType);
            ((RemoteServant)servant).setUseValidation(this.useValidation);
            this.servantHash.put(clientRef, servant);
        }
        return servant;
    }

    private boolean disconnect(Object clientRef) {
        this.remoteLogger.info("\tDisconnecting Client: " + clientRef + ", acceptNewConnections=" + this.acceptNewConnections);
        AidaTreeServant servant = (AidaTreeServant)this.servantHash.get(clientRef);
        try {
            if (servant instanceof RemoteServant) {
                ((RemoteServant)servant).close();
            }
            this.servantHash.remove(clientRef);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAll() {
        Map map = this.servantHash;
        synchronized (map) {
            if (!this.servantHash.isEmpty()) {
                Set keySet = this.servantHash.keySet();
                int size = keySet.size();
                Object[] a = new Object[size];
                keySet.toArray(a);
                for (int i = 0; i < size; ++i) {
                    Object clientRef = a[i];
                    this.disconnect(clientRef);
                }
                this.servantHash.clear();
            }
        }
    }

    public void close() {
        this.acceptNewConnections = false;
        try {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).removeListener(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.disconnectAll();
        this.servantHash.clear();
        this.servantHash = null;
        this.tree = null;
    }

    @Override
    public AidaTreeServant connectDuplex(AidaTreeClient client) {
        return this.connect(client);
    }

    @Override
    public AidaTreeServant connectNonDuplex(String clientID) {
        return this.connect(clientID);
    }

    @Override
    public boolean disconnectDuplex(AidaTreeClient client) {
        return this.disconnect(client);
    }

    @Override
    public boolean disconnectNonDuplex(String clientID) {
        return this.disconnect(clientID);
    }

    @Override
    public boolean supportDuplexMode() {
        return this.duplex;
    }

    @Override
    public String treeName() {
        return this.treeName;
    }

    @Override
    public void stateChanged(EventObject event) {
        boolean closeTree = false;
        if (event instanceof TreeEvent) {
            if (((TreeEvent)event).getID() == 5) {
                closeTree = true;
            }
        } else if (event instanceof AidaUpdateEvent && ((AidaUpdateEvent)((Object)event)).id() == 3) {
            closeTree = true;
        }
        if (!closeTree) {
            return;
        }
        this.acceptNewConnections = false;
        this.remoteLogger.info("Got TREE_CLOSED event. Closing this RemoteServer after delay: " + this.timeOut);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(RemoteServer.this.timeOut);
                    RemoteServer.this.close();
                    RemoteServer.this.remoteLogger.info("Server is closed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }
}

