/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.ITreeFactory;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.rmi.converters.RmiHist2DConverter;
import hep.aida.ref.remote.rmi.data.RmiHist2DData;
import java.util.EventObject;
import java.util.Random;

public class RemoteHistogram2D
extends RemoteManagedObject
implements IHistogram2D {
    private Annotation annotation = null;
    private IAxis xAxis = null;
    private IAxis yAxis = null;
    private double[][] heights = null;
    private double[][] errors = null;
    private int[][] entries = null;
    private double[][] binMeansX = null;
    private double[][] binRmssX = null;
    private double[][] binMeansY = null;
    private double[][] binRmssY = null;
    private int[] binEntriesX;
    private int[] binEntriesY;
    private double[] binHeightsX;
    private double[] binHeightsY;
    private double meanX = 0.0;
    private double rmsX = 0.0;
    private double meanY = 0.0;
    private double rmsY = 0.0;
    private double equivalentBinEntries = 0.0;
    private int inRangeEntries = DEFAULT_INT;
    private int extraEntries = 0;
    private int nanEntries = DEFAULT_INT;
    private int minBinEntries = DEFAULT_INT;
    private int maxBinEntries = DEFAULT_INT;
    private double inRangeBinHeights = DEFAULT_DOUBLE;
    private double extraBinHeights = 0.0;
    private double minBinHeights = DEFAULT_DOUBLE;
    private double maxBinHeights = DEFAULT_DOUBLE;

    public RemoteHistogram2D(String name) {
        this(null, name);
    }

    public RemoteHistogram2D(IDevMutableStore store, String name) {
        super(name);
        this.aidaType = "IHistogram2D";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, name, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
        this.xAxis = new FixedAxis(1, 0.0, 1.0);
        this.yAxis = new FixedAxis(1, 0.0, 1.0);
    }

    public RemoteHistogram2D(IDevMutableStore store, String name, String title) {
        super(name);
        this.aidaType = "IHistogram2D";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
        this.xAxis = new FixedAxis(1, 0.0, 1.0);
        this.yAxis = new FixedAxis(1, 0.0, 1.0);
    }

    @Override
    protected EventObject createEvent() {
        return new HistogramEvent((IBaseHistogram)this);
    }

    @Override
    public void setTreeFolder(String treeFolder) {
        super.setTreeFolder(treeFolder);
        boolean flbl = this.annotation.isFillable();
        if (!flbl) {
            this.annotation.setFillable(true);
        }
        if (this.annotation.hasKey(Annotation.fullPathKey)) {
            this.annotation.setValue(Annotation.fullPathKey, this.treePath);
        } else {
            this.annotation.addItem(Annotation.fullPathKey, this.treePath, true);
        }
        if (!flbl) {
            this.annotation.setFillable(false);
        }
    }

    private int convertAIDAIndex(IAxis axis, int index) {
        int mi = index == -2 ? 0 : (index == -1 ? axis.bins() + 1 : index + 1);
        return mi;
    }

    public void setAnnotation(Annotation a) {
        this.annotation = a;
    }

    public void setXAxis(int bins, double min, double max) {
        this.xAxis = new FixedAxis(bins, min, max);
    }

    public void setYAxis(int bins, double min, double max) {
        this.yAxis = new FixedAxis(bins, min, max);
    }

    public void setRmsX(double rms) {
        this.rmsX = rms;
    }

    public void setRmsY(double rms) {
        this.rmsY = rms;
    }

    public void setMeanX(double mean) {
        this.meanX = mean;
    }

    public void setMeanY(double mean) {
        this.meanY = mean;
    }

    public void setHeights(double[][] h) {
        if (h == null || h.length == 0) {
            this.heights = null;
            this.inRangeBinHeights = DEFAULT_DOUBLE;
            this.extraBinHeights = DEFAULT_DOUBLE;
            this.minBinHeights = DEFAULT_DOUBLE;
            this.maxBinHeights = DEFAULT_DOUBLE;
            return;
        }
        this.heights = h;
    }

    public void setEntries(int[][] h) {
        if (h == null || h.length == 0) {
            this.entries = null;
            this.inRangeEntries = DEFAULT_INT;
            this.extraEntries = DEFAULT_INT;
            this.equivalentBinEntries = DEFAULT_DOUBLE;
            return;
        }
        this.entries = h;
    }

    public void setErrors(double[][] h) {
        if (h == null || h.length == 0) {
            this.errors = null;
            return;
        }
        this.errors = h;
    }

    public void setBinMeansX(double[][] h) {
        if (h == null || h.length == 0) {
            this.binMeansX = null;
            return;
        }
        this.binMeansX = h;
    }

    public void setBinRmssX(double[][] h) {
        if (h == null || h.length == 0) {
            this.binRmssX = null;
            return;
        }
        this.binRmssX = h;
    }

    public void setBinMeansY(double[][] h) {
        if (h == null || h.length == 0) {
            this.binMeansY = null;
            return;
        }
        this.binMeansY = h;
    }

    public void setBinRmssY(double[][] h) {
        if (h == null || h.length == 0) {
            this.binRmssY = null;
            return;
        }
        this.binRmssY = h;
    }

    public void setBinEntriesX(int[] h) {
        if (h == null || h.length == 0) {
            this.binEntriesX = null;
            return;
        }
        this.binEntriesX = h;
    }

    public void setBinEntriesY(int[] h) {
        if (h == null || h.length == 0) {
            this.binEntriesY = null;
            return;
        }
        this.binEntriesY = h;
    }

    public void setBinHeightsX(double[] h) {
        if (h == null || h.length == 0) {
            this.binHeightsX = null;
            return;
        }
        this.binHeightsX = h;
    }

    public void setBinHeightsY(double[] h) {
        if (h == null || h.length == 0) {
            this.binHeightsY = null;
            return;
        }
        this.binHeightsY = h;
    }

    public void setEquivalentBinEntries(double d) {
        this.equivalentBinEntries = d;
    }

    public void setNanEntries(int d) {
        this.nanEntries = d;
    }

    public void setInRangeEntries(int d) {
        this.inRangeEntries = d;
    }

    public void setExtraEntries(int d) {
        this.extraEntries = d;
    }

    public void setMinBinEntries(int d) {
        this.minBinEntries = d;
    }

    public void setMaxBinEntries(int d) {
        this.maxBinEntries = d;
    }

    public void setInRangeBinHeights(double d) {
        this.inRangeBinHeights = d;
    }

    public void setExtraBinHeights(double d) {
        this.extraBinHeights = d;
    }

    public void setMinBinHeights(double d) {
        this.minBinHeights = d;
    }

    public void setMaxBinHeights(double d) {
        this.maxBinHeights = d;
    }

    public int getNanEntries() {
        return this.nanEntries;
    }

    public double getEquivalentBinEntries() {
        return this.equivalentBinEntries;
    }

    public int getInRangeEntries() {
        return this.inRangeEntries;
    }

    public int getExtraEntries() {
        return this.extraEntries;
    }

    public int getMinBinEntries() {
        return this.minBinEntries;
    }

    public int getMaxBinEntries() {
        return this.maxBinEntries;
    }

    public double getInRangeBinHeights() {
        return this.inRangeBinHeights;
    }

    public double getExtraBinHeights() {
        return this.extraBinHeights;
    }

    public double getMinBinHeights() {
        return this.minBinHeights;
    }

    public double getMaxBinHeights() {
        return this.maxBinHeights;
    }

    public int[][] getBinEntries() {
        return this.entries;
    }

    public double[][] getBinHeights() {
        return this.heights;
    }

    public double[][] getBinErrors() {
        return this.errors;
    }

    public double[][] getBinMeansX() {
        return this.binMeansX;
    }

    public double[][] getBinRmssX() {
        return this.binRmssX;
    }

    public double[][] getBinMeansY() {
        return this.binMeansY;
    }

    public double[][] getBinRmssY() {
        return this.binRmssY;
    }

    public int[] getBinEntriesX() {
        return this.binEntriesX;
    }

    public int[] getBinEntriesY() {
        return this.binEntriesY;
    }

    public double[] getBinHeightsX() {
        return this.binHeightsX;
    }

    public double[] getBinHeightsY() {
        return this.binHeightsY;
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.annotation;
    }

    public int dimension() {
        return 2;
    }

    public int entries() {
        this.makeSureDataIsValid();
        if (this.entries == null && this.heights != null) {
            return (int)this.inRangeBinHeights;
        }
        return this.inRangeEntries;
    }

    public void reset() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public String title() {
        return this.annotation.value(Annotation.titleKey);
    }

    public void setTitle(String title) throws IllegalArgumentException {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.annotation.setFillable(true);
        this.annotation.setValue(Annotation.titleKey, title);
        this.annotation.setFillable(false);
    }

    public double equivalentBinEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            return DEFAULT_INT;
        }
        return this.equivalentBinEntries;
    }

    public int allEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            if (this.heights != null) {
                return (int)this.sumAllBinHeights();
            }
            return DEFAULT_INT;
        }
        return this.entries() + this.extraEntries();
    }

    public int extraEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            if (this.heights != null) {
                return (int)this.extraBinHeights;
            }
            return DEFAULT_INT;
        }
        return this.extraEntries;
    }

    public int nanEntries() {
        this.makeSureDataIsValid();
        return this.nanEntries;
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public double maxBinHeight() {
        this.makeSureDataIsValid();
        if (this.heights == null && this.entries != null) {
            return this.maxBinEntries;
        }
        return this.maxBinHeights;
    }

    public double minBinHeight() {
        this.makeSureDataIsValid();
        if (this.heights == null && this.entries != null) {
            return this.minBinEntries;
        }
        return this.minBinHeights;
    }

    public double sumAllBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            if (this.entries != null) {
                return this.allEntries();
            }
            return DEFAULT_DOUBLE;
        }
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public double sumBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null && this.entries != null) {
            return this.inRangeEntries;
        }
        return this.inRangeBinHeights;
    }

    public double sumExtraBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            if (this.entries != null) {
                return this.extraEntries;
            }
            return DEFAULT_DOUBLE;
        }
        return this.extraBinHeights;
    }

    public void add(IHistogram2D iHistogram2D) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public int binEntries(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            if (this.heights != null) {
                return (int)this.binHeight(param1, param2);
            }
            return DEFAULT_INT;
        }
        return this.entries[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public int binEntriesX(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binEntriesX == null) {
            if (this.binHeightsX != null) {
                return (int)this.binHeightX(param);
            }
            return DEFAULT_INT;
        }
        return this.binEntriesX[this.convertAIDAIndex(this.xAxis, param)];
    }

    public int binEntriesY(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binEntriesY == null) {
            if (this.binHeightsY != null) {
                return (int)this.binHeightY(param);
            }
            return DEFAULT_INT;
        }
        return this.binEntriesX[this.convertAIDAIndex(this.xAxis, param)];
    }

    public double binError(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.errors == null) {
            return Math.sqrt(this.binHeight(param1, param2));
        }
        return this.errors[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binHeight(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            if (this.entries != null) {
                return this.binEntries(param1, param2);
            }
            return DEFAULT_DOUBLE;
        }
        return this.heights[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binHeightX(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binHeightsX == null) {
            if (this.binEntriesX != null) {
                return this.binEntriesX(param);
            }
            return DEFAULT_DOUBLE;
        }
        return this.binHeightsX[this.convertAIDAIndex(this.xAxis, param)];
    }

    public double binHeightY(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binHeightsY == null) {
            if (this.binEntriesY != null) {
                return this.binEntriesY(param);
            }
            return DEFAULT_DOUBLE;
        }
        return this.binHeightsY[this.convertAIDAIndex(this.yAxis, param)];
    }

    public double binMeanX(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        double d = DEFAULT_DOUBLE;
        d = this.binMeansX == null ? (param1 == -2 ? Double.NEGATIVE_INFINITY : (param1 == -1 ? Double.POSITIVE_INFINITY : this.xAxis.binCenter(param1))) : this.binMeansX[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
        return d;
    }

    public double binMeanY(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        double d = DEFAULT_DOUBLE;
        d = this.binMeansY == null ? (param2 == -2 ? Double.NEGATIVE_INFINITY : (param2 == -1 ? Double.POSITIVE_INFINITY : this.yAxis.binCenter(param2))) : this.binMeansY[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
        return d;
    }

    public double binRmsX(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        double d = DEFAULT_DOUBLE;
        d = this.binRmssX == null ? (param1 == -2 ? DEFAULT_DOUBLE : (param1 == -1 ? DEFAULT_DOUBLE : this.xAxis.binWidth(param1) / rmsFactor)) : this.binRmssX[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
        return d;
    }

    public double binRmsY(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        double d = DEFAULT_DOUBLE;
        d = this.binRmssY == null ? (param2 == -2 ? DEFAULT_DOUBLE : (param2 == -1 ? DEFAULT_DOUBLE : this.yAxis.binWidth(param2) / rmsFactor)) : this.binRmssY[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
        return d;
    }

    public int coordToIndexX(double param) {
        this.makeSureDataIsValid();
        return this.xAxis.coordToIndex(param);
    }

    public int coordToIndexY(double param) {
        this.makeSureDataIsValid();
        return this.xAxis.coordToIndex(param);
    }

    public void fill(double param, double param1) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1, double param2) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public double meanX() {
        this.makeSureDataIsValid();
        return this.meanX;
    }

    public double meanY() {
        this.makeSureDataIsValid();
        return this.meanY;
    }

    public double rmsX() {
        this.makeSureDataIsValid();
        return this.rmsX;
    }

    public double rmsY() {
        this.makeSureDataIsValid();
        return this.rmsY;
    }

    public IAxis xAxis() {
        this.makeSureDataIsValid();
        return this.xAxis;
    }

    public IAxis yAxis() {
        this.makeSureDataIsValid();
        return this.yAxis;
    }

    public static void main(String[] args) throws Exception {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        IHistogramFactory hf = af.createHistogramFactory(null);
        IHistogram2D h21 = hf.createHistogram2D("Histogram 2D-1", 300, -3.0, 3.0, 300, -3.0, 3.0);
        RemoteHistogram2D rh2 = new RemoteHistogram2D(null, "Histogram 2D");
        rh2.setConnected(false);
        Random r = new Random();
        for (int i = 0; i < 100000; ++i) {
            double xVal = r.nextGaussian();
            double yVal = r.nextGaussian();
            double w = r.nextDouble();
            h21.fill(xVal, yVal, w);
        }
        RmiHist2DData data1 = null;
        RmiHist2DData data2 = null;
        RmiHist2DConverter converter = RmiHist2DConverter.getInstance();
        for (int k = 0; k < 10; ++k) {
            for (int i = 0; i < 10000; ++i) {
                double xVal = r.nextGaussian();
                double yVal = r.nextGaussian();
                double w = r.nextDouble();
                h21.fill(xVal, yVal, w);
            }
            long t0 = System.currentTimeMillis();
            data1 = (RmiHist2DData)converter.extractData(h21);
            long t1 = System.currentTimeMillis();
            converter.updateAidaObject(rh2, data1);
            long t2 = System.currentTimeMillis();
            data2 = (RmiHist2DData)converter.extractData(rh2);
            long t3 = System.currentTimeMillis();
            long tExtract1 = t1 - t0;
            long tSet1 = t2 - t1;
            long tRExtract1 = t3 - t2;
            System.out.println(k + " Extract data: " + tExtract1 + " msec, Set data: " + tSet1 + " msec, Extract from Remote: " + tRExtract1 + " msec :: " + data2.getEquivalentBinEntries());
            Thread.sleep(2000L);
        }
    }
}

