/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.AlreadyConvertedException;
import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud2D;
import hep.aida.IHistogram2D;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.remote.RemoteHistogram2D;
import hep.aida.ref.remote.RemoteManagedObject;
import java.util.EventObject;

public class RemoteCloud2D
extends RemoteManagedObject
implements ICloud2D {
    private RemoteHistogram2D hist;
    private boolean isConverted;
    private int entries;
    private int nanEntries;
    private int maxEntries;
    protected double sumOfWeights;
    private double lowerEdgeX;
    private double lowerEdgeY;
    private double upperEdgeX;
    private double upperEdgeY;
    private double meanX;
    private double meanY;
    private double rmsX;
    private double rmsY;
    private double[] valuesX;
    private double[] valuesY;
    private double[] weights;

    public RemoteCloud2D(String name) {
        this(null, name);
    }

    public RemoteCloud2D(IDevMutableStore store, String name) {
        this(store, name, name);
    }

    public RemoteCloud2D(IDevMutableStore store, String name, String title) {
        super(name);
        this.aidaType = "ICloud2D";
        this.store = store;
        this.hist = new RemoteHistogram2D(name);
        this.hist.setFillable(true);
        this.hist.setDataValid(true);
        if (!name.equals(title)) {
            this.hist.setTitle(title);
        }
        this.dataIsValid = false;
    }

    @Override
    protected EventObject createEvent() {
        return new HistogramEvent((IBaseHistogram)this);
    }

    @Override
    public void setTreeFolder(String treeFolder) {
        boolean flbl;
        super.setTreeFolder(treeFolder);
        boolean bl = flbl = !(this.hist.annotation() instanceof Annotation) || this.hist.annotation() instanceof Annotation && ((Annotation)this.hist.annotation()).isFillable();
        if (!flbl) {
            ((Annotation)this.hist.annotation()).setFillable(true);
        }
        if (this.hist.annotation().hasKey(Annotation.fullPathKey)) {
            this.hist.annotation().setValue(Annotation.fullPathKey, this.treePath);
        } else {
            this.hist.annotation().addItem(Annotation.fullPathKey, this.treePath, true);
        }
        if (!flbl) {
            ((Annotation)this.hist.annotation()).setFillable(false);
        }
    }

    public void setConverted(boolean b) {
        this.isConverted = b;
    }

    public void setMaxEntries(int i) {
        this.maxEntries = i;
    }

    public void setNanEntries(int i) {
        this.nanEntries = i;
    }

    public void setEntries(int i) {
        this.entries = i;
    }

    public void setLowerEdgeX(double d) {
        this.lowerEdgeX = d;
    }

    public void setLowerEdgeY(double d) {
        this.lowerEdgeY = d;
    }

    public void setUpperEdgeX(double d) {
        this.upperEdgeX = d;
    }

    public void setUpperEdgeY(double d) {
        this.upperEdgeY = d;
    }

    public void setSummOfWeights(double d) {
        this.sumOfWeights = d;
    }

    public void setMeanX(double d) {
        this.meanX = d;
    }

    public void setMeanY(double d) {
        this.meanY = d;
    }

    public void setRmsX(double d) {
        this.rmsX = d;
    }

    public void setRmsY(double d) {
        this.rmsY = d;
    }

    public void setValuesX(double[] a) {
        this.valuesX = a;
    }

    public void setValuesY(double[] a) {
        this.valuesY = a;
    }

    public void setWeights(double[] a) {
        this.weights = a;
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.hist.annotation();
    }

    public int dimension() {
        this.makeSureDataIsValid();
        return 2;
    }

    public int entries() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.allEntries();
        }
        return this.entries;
    }

    public int nanEntries() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.nanEntries();
        }
        return this.nanEntries;
    }

    public IHistogram2D histogram() throws RuntimeException {
        this.makeSureDataIsValid();
        return this.hist;
    }

    public boolean isConverted() {
        this.makeSureDataIsValid();
        return this.isConverted;
    }

    public double lowerEdgeX() {
        this.makeSureDataIsValid();
        return this.lowerEdgeX;
    }

    public double lowerEdgeY() {
        this.makeSureDataIsValid();
        return this.lowerEdgeY;
    }

    public int maxEntries() {
        this.makeSureDataIsValid();
        return this.maxEntries;
    }

    public double meanX() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.meanX();
        }
        return this.meanX;
    }

    public double meanY() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.meanY();
        }
        return this.meanY;
    }

    public double rmsX() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.rmsX();
        }
        return this.rmsX;
    }

    public double rmsY() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.rmsY();
        }
        return this.rmsY;
    }

    public void setTitle(String str) throws IllegalArgumentException {
        this.hist.setTitle(str);
    }

    public double sumOfWeights() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.sumAllBinHeights();
        }
        return this.sumOfWeights;
    }

    public String title() {
        return this.hist.title();
    }

    public double upperEdgeX() {
        this.makeSureDataIsValid();
        return this.upperEdgeX;
    }

    public double upperEdgeY() {
        this.makeSureDataIsValid();
        return this.upperEdgeY;
    }

    public double valueX(int param) throws AlreadyConvertedException {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            throw new RuntimeException("Cloud has been converted");
        }
        return this.valuesX[param];
    }

    public double valueY(int param) throws AlreadyConvertedException {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            throw new RuntimeException("Cloud has been converted");
        }
        return this.valuesY[param];
    }

    public double weight(int param) throws AlreadyConvertedException {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            throw new RuntimeException("Cloud has been converted");
        }
        return this.weights[param];
    }

    public void setConversionParameters(int binsx, double lex, double uex, int binsy, double ley, double uey) {
        throw new ReadOnlyException();
    }

    public void convert(double[] values, double[] values1) throws AlreadyConvertedException {
        throw new ReadOnlyException();
    }

    public void convert(int param, double param1, double param2, int param3, double param4, double param5) throws AlreadyConvertedException {
        throw new ReadOnlyException();
    }

    public void convertToHistogram() throws AlreadyConvertedException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1, double param2) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fillHistogram(IHistogram2D iHistogram2D) throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void reset() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }
}

