/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IProfile;
import hep.aida.IProfile2D;
import hep.aida.ref.plotter.adapter.AIDAProfileAdapter;
import hep.aida.ref.plotter.adapter.AIDAProfileStatistics2D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;

class AIDAProfileAdapter2D
extends AIDAProfileAdapter
implements Rebinnable2DHistogramData,
HasStatistics {
    protected IProfile2D profile;

    AIDAProfileAdapter2D(IProfile2D profile) {
        super((IProfile)profile);
        this.profile = profile;
        String tmp = null;
        try {
            tmp = profile.annotation().value("xAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            tmp = profile.annotation().value("yAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        this.setValid();
        double[][][] data = new double[2][this.profile.xAxis().bins()][this.profile.yAxis().bins()];
        for (int i = 0; i < this.profile.xAxis().bins(); ++i) {
            for (int j = 0; j < this.profile.yAxis().bins(); ++j) {
                data[0][i][j] = this.profile.binHeight(i, j);
                if (Double.isInfinite(data[0][i][j])) {
                    data[0][i][j] = Double.NaN;
                }
                data[1][i][j] = this.errorMode() == USE_ERROR_ON_MEAN ? this.profile.binError(i, j) : this.profile.binRms(i, j);
            }
        }
        return data;
    }

    public double getXMin() {
        return this.profile.xAxis().lowerEdge();
    }

    public double getXMax() {
        return this.profile.xAxis().upperEdge();
    }

    public double getYMin() {
        return this.profile.yAxis().lowerEdge();
    }

    public double getYMax() {
        return this.profile.yAxis().upperEdge();
    }

    public int getXBins() {
        return this.profile.xAxis().bins();
    }

    public int getYBins() {
        return this.profile.yAxis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getXAxisType() {
        return this.xAxisType;
    }

    public int getYAxisType() {
        return this.yAxisType;
    }

    public void setXAxisType(int type) {
        this.xAxisType = type;
    }

    public void setYAxisType(int type) {
        this.yAxisType = type;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.profile.title();
    }

    public Statistics getStatistics() {
        return new AIDAProfileStatistics2D(this.profile);
    }
}

