/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;

public class Step
extends Function {
    private static int INCLUDE_BOUNDS = 0;
    private static int EXCLUDE_BOUNDS = 1;
    private static int INCLUDE_UPPER_BOUND = 2;
    private static int INCLUDE_LOWER_BOUND = 2;
    private Dependent x;
    private Parameter a;
    private Parameter b;
    private double aVal;
    private double bVal;
    private double xVal;
    private int type;

    public Step(String name) {
        this(name, INCLUDE_BOUNDS);
    }

    public Step(String name, int type) {
        this(name, type, (Dependent)null);
    }

    public Step(String name, Dependent x) {
        this(name, INCLUDE_BOUNDS, x, null, null);
    }

    public Step(String name, int type, Dependent x) {
        this(name, type, x, null, null);
    }

    public Step(String name, Dependent x, Parameter a, Parameter b) {
        this(name, INCLUDE_BOUNDS, x, a, b);
    }

    public Step(String name, int type, Dependent x, Parameter a, Parameter b) {
        super(name);
        this.x = x;
        this.a = a;
        this.b = b;
        this.type = type;
        this.initializeVariables();
    }

    private void initializeVariables() {
        if (this.x == null) {
            this.x = new Dependent("x", -10.0, 10.0);
        }
        if (this.a == null) {
            this.a = new Parameter("a");
        }
        if (this.b == null) {
            this.b = new Parameter("b");
        }
        VariableList list = new VariableList();
        list.add(this.x);
        list.add(this.a);
        list.add(this.b);
        this.addVariables(list);
    }

    @Override
    public void variableChanged(Variable var) {
        if (var == this.a) {
            this.aVal = this.a.value();
        } else if (var == this.b) {
            this.bVal = this.b.value();
        } else if (var == this.x) {
            this.xVal = this.x.value();
        }
        if (this.bVal < this.aVal) {
            System.out.println("The value of parameter " + this.b.name() + " is less than paramter's " + this.a.name() + " " + this.bVal + " " + this.aVal);
        }
    }

    @Override
    public double functionValue() {
        double r = 0.0;
        if (this.xVal < this.bVal && this.xVal > this.aVal) {
            r = 1.0;
        } else if (this.xVal == this.aVal && (this.type == INCLUDE_BOUNDS || this.type == INCLUDE_LOWER_BOUND)) {
            r = 1.0;
        } else if (this.xVal == this.bVal && (this.type == INCLUDE_BOUNDS || this.type == INCLUDE_UPPER_BOUND)) {
            r = 1.0;
        }
        return r;
    }

    @Override
    public boolean hasAnalyticalVariableGradient(Variable var) {
        return true;
    }

    @Override
    public double evaluateAnalyticalVariableGradient(Variable var) {
        return 0.0;
    }

    @Override
    public boolean hasAnalyticalNormalization(Dependent dep) {
        return dep == this.x;
    }

    @Override
    public double evaluateAnalyticalNormalization(Dependent dep) {
        double[] xMax = this.x.range().upperBounds();
        double[] xMin = this.x.range().lowerBounds();
        if (xMax.length != 1 || xMin.length != 1) {
            throw new IllegalArgumentException("Normalization over multiple ranges is not supported for Function Step.");
        }
        double le = xMin[0] < this.aVal ? this.aVal : xMin[0];
        double ue = xMax[0] < this.bVal ? xMax[0] : this.bVal;
        return ue - le;
    }
}

