/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IMeasurement;
import hep.aida.ref.event.AIDAObservable;
import hep.aida.ref.event.IsObservable;
import java.io.Serializable;

public class Measurement
extends AIDAObservable
implements IMeasurement,
IsObservable,
Serializable {
    private double value;
    private double errorPlus;
    private double errorMinus;

    public Measurement() {
        this.setIsValidAfterNotify(true);
        this.value = Double.NaN;
        this.errorPlus = Double.NaN;
        this.errorMinus = Double.NaN;
    }

    public Measurement(IMeasurement m) {
        this.setIsValidAfterNotify(true);
        this.value = m.value();
        this.errorPlus = m.errorPlus();
        this.errorMinus = m.errorMinus();
    }

    public Measurement(double val) {
        this.setIsValidAfterNotify(true);
        this.value = val;
        this.errorPlus = Double.NaN;
        this.errorMinus = Double.NaN;
    }

    public Measurement(double val, double err) {
        this.setIsValidAfterNotify(true);
        this.value = val;
        this.errorPlus = err;
        this.errorMinus = err;
    }

    public Measurement(double val, double errMinus, double errPlus) {
        this.setIsValidAfterNotify(true);
        this.value = val;
        this.errorPlus = errMinus;
        this.errorMinus = errPlus;
    }

    public double value() {
        return this.value;
    }

    public double errorPlus() {
        if (Double.isNaN(this.errorPlus)) {
            return 0.0;
        }
        return this.errorPlus;
    }

    public double errorMinus() {
        if (Double.isNaN(this.errorMinus)) {
            return this.errorPlus();
        }
        return this.errorMinus;
    }

    public void setValue(double value) throws IllegalArgumentException {
        this.value = value;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void setErrorPlus(double errorPlus) throws IllegalArgumentException {
        if (errorPlus < 0.0) {
            throw new IllegalArgumentException("Attempt to set negative value for \"errorPlus\" in Measurement");
        }
        this.errorPlus = errorPlus;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void setErrorMinus(double errorMinus) throws IllegalArgumentException {
        if (errorMinus < 0.0) {
            throw new IllegalArgumentException("Attempt to set negative value for \"errorMinus\" in Measurement");
        }
        this.errorMinus = errorMinus;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }
}

