/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.AbstractDevModelFunction;

public class PolynomialModelFunction
extends AbstractDevModelFunction {
    public PolynomialModelFunction(String str) {
        if (!str.toLowerCase().startsWith("p")) {
            throw new IllegalArgumentException("PolynomialModelFunction Function Qualifier must start with \"P\"");
        }
        int dim = Integer.parseInt(str.substring(1));
        this.setDimension(1);
        this.setNumberOfParameters(dim + 1);
        this.setCodeletString("PolynomialModelFunction of power " + dim);
        this.setTitle(str);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int numberOfParameters() {
        return this.p.length;
    }

    @Override
    public double functionValue(double[] var) {
        double val = 0.0;
        for (int i = 1; i < this.numberOfParameters(); ++i) {
            val += this.p[i] * Math.pow(var[0], i);
        }
        return val + this.p[0];
    }
}

