/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;
import jas.hist.Handle;
import java.awt.Cursor;
import org.freehep.util.images.ImageHandler;

public class LorentzianCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public LorentzianCoreNotNorm(String str) {
        super(1, 3, new double[]{1.0, 1.0, 1.0});
        this.setTitle("LorentzianCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "mu", "gamma"};
        this.setParameterNames(names);
    }

    public LorentzianCoreNotNorm(String str, double[] pVal) {
        super(1, 3, pVal);
        this.setTitle("LorentzianCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "mu", "gamma"};
        this.setParameterNames(names);
    }

    @Override
    public double functionValue(double[] var) {
        double x = var[0];
        double n = this.p[0] / Math.PI;
        double mu = this.p[1];
        double gamma = this.p[2];
        double gammaHalf = gamma / 2.0;
        double gammaHalfSquared = gammaHalf * gammaHalf;
        return n * gammaHalf / ((x - mu) * (x - mu) + gammaHalfSquared);
    }

    @Override
    public boolean providesGradient() {
        return false;
    }

    @Override
    public double[] gradient(double[] var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean providesParameterGradient() {
        return false;
    }

    @Override
    public double[] parameterGradient(double[] var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    @Override
    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        Handle[] result = new Handle[]{new Handle(){

            public void moveTo(double x, double y) {
                LorentzianCoreNotNorm.this.p[1] = x;
                LorentzianCoreNotNorm.this.p[0] = y * LorentzianCoreNotNorm.this.p[2] * Math.PI / 2.0;
                LorentzianCoreNotNorm.this.notifyCoreChanged();
            }

            public double getX() {
                return LorentzianCoreNotNorm.this.p[1];
            }

            public double getY() {
                return LorentzianCoreNotNorm.this.p[0] * 2.0 / (LorentzianCoreNotNorm.this.p[2] * Math.PI);
            }

            public Cursor cursor() {
                return ImageHandler.getBestCursor("moveCursor.png", LorentzianCoreNotNorm.class, 0, 0);
            }
        }, new Handle(){

            public void moveTo(double x, double y) {
                LorentzianCoreNotNorm.this.p[2] = 2.0 * (x - LorentzianCoreNotNorm.this.p[1]);
                LorentzianCoreNotNorm.this.p[0] = y * Math.PI * LorentzianCoreNotNorm.this.p[2];
                LorentzianCoreNotNorm.this.notifyCoreChanged();
            }

            public double getY() {
                return LorentzianCoreNotNorm.this.p[0] / (Math.PI * LorentzianCoreNotNorm.this.p[2]);
            }

            public double getX() {
                return LorentzianCoreNotNorm.this.p[1] + LorentzianCoreNotNorm.this.p[2] / 2.0;
            }

            public Cursor cursor() {
                return ImageHandler.getBestCursor("moveCursor.png", LorentzianCoreNotNorm.class, 0, 0);
            }
        }};
        return result;
    }
}

