/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ext.IFitMethod;
import java.util.ArrayList;

public class InternalFitFunction
implements IFunction {
    private IDevFitDataIterator dataIterator;
    private IModelFunction func;
    private ArrayList varSimpleConstraint1;
    private ArrayList varSimpleConstraint2;
    private IFitMethod fitMethod;

    public InternalFitFunction(IDevFitDataIterator dataIterator, IModelFunction func, IFitMethod fitMethod) {
        this.dataIterator = dataIterator;
        this.func = func;
        this.varSimpleConstraint1 = new ArrayList();
        this.varSimpleConstraint2 = new ArrayList();
        this.fitMethod = fitMethod;
    }

    public int dimension() {
        return this.func.numberOfParameters();
    }

    public double value(double[] x) {
        if (this.varSimpleConstraint1.size() != 0) {
            this.applySimpleConstraint(x);
        }
        this.func.setParameters(x);
        return this.fitMethod.evaluate(this.dataIterator, (IFunction)this.func);
    }

    public boolean providesGradient() {
        return this.func.providesParameterGradient();
    }

    public String variableName(int i) {
        return this.func.parameterNames()[i];
    }

    public String[] variableNames() {
        return this.func.parameterNames();
    }

    public int numberOfParameters() {
        return 0;
    }

    public double[] gradient(double[] x) {
        if (this.varSimpleConstraint1.size() != 0) {
            this.applySimpleConstraint(x);
        }
        this.func.setParameters(x);
        double[] result = this.fitMethod.evaluateGradient(this.dimension(), this.dataIterator, (IFunction)this.func);
        return result;
    }

    public boolean isEqual(IFunction f) {
        throw new UnsupportedOperationException();
    }

    public IAnnotation annotation() {
        throw new UnsupportedOperationException();
    }

    public String codeletString() {
        throw new UnsupportedOperationException();
    }

    public void setParameters(double[] params) {
        throw new UnsupportedOperationException();
    }

    public double[] parameters() {
        throw new UnsupportedOperationException();
    }

    public int indexOfParameter(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] parameterNames() {
        throw new UnsupportedOperationException();
    }

    public void setParameter(String name, double x) {
        throw new UnsupportedOperationException();
    }

    public double parameter(String name) {
        throw new UnsupportedOperationException();
    }

    public void setTitle(String str) {
        throw new UnsupportedOperationException();
    }

    public String title() {
        throw new UnsupportedOperationException();
    }

    public String normalizationParameter() {
        throw new UnsupportedOperationException();
    }

    protected int dataEntries() {
        return this.dataIterator.entries();
    }

    protected int indexOfVariable(String varName) {
        return this.func.indexOfParameter(varName);
    }

    protected void setSimpleConstraint(String varName1, String varName2) {
        int ind1 = this.indexOfVariable(varName1);
        int ind2 = this.indexOfVariable(varName2);
        if (ind1 > -1 && ind2 > -1) {
            this.varSimpleConstraint1.add(new Integer(ind1));
            this.varSimpleConstraint2.add(new Integer(ind2));
        }
    }

    protected boolean isValidSimpleConstraint(String varName1, String varName2) {
        int ind1 = this.indexOfVariable(varName1);
        int ind2 = this.indexOfVariable(varName2);
        return ind1 > -1 && ind2 > -1;
    }

    protected void applySimpleConstraint(double[] x) {
        for (int i = 0; i < this.varSimpleConstraint1.size(); ++i) {
            int ind1 = (Integer)this.varSimpleConstraint1.get(i);
            int ind2 = (Integer)this.varSimpleConstraint2.get(i);
            x[ind1] = x[ind2];
        }
    }
}

