/*
 * Decompiled with CFR 0.152.
 */
package proto;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import promc.io.ProMC;
import promc.io.ProMCDescriptionFile;
import promc.io.ProMCHeaderFile;
import promc.io.ProMCStatFile;

public class FileMC {
    private FileOutputStream oof = null;
    private FileInputStream iif = null;
    private long nev = 0L;
    private long requested_nev = 0L;
    private static final int FILE_VERSION = 1;
    private ZipOutputStream zout;
    static final int BUFFER = 2048;
    private byte[] data;
    private ZipInputStream zin;
    private ZipFile zipFile;
    private String description = "none";
    private long version = -1L;
    private long timestamp = -1L;
    private String ProMCDescriptionTxt;
    private String ProMCHeaderTxt;
    private String ProMCTxt;
    private String ProMCStatTxt;
    private String LastModifiedTxt;
    private String LogFile = "not found";
    private ProMCHeaderFile.ProMCHeader recordHeader = null;
    private Map<String, Object> storedProto;
    private Map<String, String> storedString;
    private ArrayList<byte[]> storedEvents;
    private boolean isURL = false;
    private boolean debug = false;

    public FileMC(String file, String option) {
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.oof = new FileOutputStream(file);
                this.zout = new ZipOutputStream(new BufferedOutputStream(this.oof));
                this.data = new byte[2048];
                this.zipFile = null;
                ZipEntry entry = new ZipEntry("version");
                this.zout.putNextEntry(entry);
                String a = new String(Integer.toString(1));
                byte[] theByteArray = a.getBytes();
                entry.setSize(theByteArray.length);
                this.zout.write(theByteArray);
                this.zout.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("r")) {
            if (file.startsWith("http") || file.startsWith("ftp")) {
                URL url = null;
                try {
                    url = new URL(file);
                }
                catch (MalformedURLException e) {
                    System.out.println("Error in accessing the URL=" + url.toString());
                }
                try {
                    URLConnection urlConn = url.openConnection();
                    urlConn.setDoInput(true);
                    urlConn.setUseCaches(false);
                    this.zin = new ZipInputStream(urlConn.getInputStream());
                    this.fetchDescriptionURL();
                    this.isURL = true;
                }
                catch (MalformedURLException e) {
                    System.out.println(e.toString());
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
            } else {
                try {
                    this.isURL = false;
                    this.zipFile = new ZipFile(file);
                    this.iif = new FileInputStream(file);
                    this.zin = new ZipInputStream(this.iif);
                    this.fetchDescription();
                    this.readMeta();
                }
                catch (IOException e) {
                    System.err.println("Error in opening=" + file);
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    public boolean getIsURL() {
        return this.isURL;
    }

    public void fetchDescriptionURL() {
        if (this.debug) {
            System.out.println("fetchDescriptionURL(): Fetching the description..");
        }
        this.storedString = new HashMap<String, String>();
        this.storedProto = new HashMap<String, Object>();
        this.storedEvents = new ArrayList();
        ZipEntry zipEntry = null;
        try {
            zipEntry = this.zin.getNextEntry();
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println("fetchDescriptionURL(): No first zipEntry??");
            }
            return;
        }
        this.LogFile = "none";
        int tot = 0;
        try {
            while (zipEntry != null) {
                String sname = zipEntry.getName();
                if (this.debug) {
                    System.out.println("fetchDescriptionURL(): read:" + sname);
                }
                if (sname.equals("promc_nevents")) {
                    Date d = new Date(zipEntry.getTime());
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.LastModifiedTxt = formatter.format((Object)d);
                    String snev = new Scanner(this.zin).next();
                    this.nev = Integer.parseInt(snev);
                    this.storedString.put(sname, snev);
                } else if (sname.equals("version")) {
                    String sversion = new Scanner(this.zin).next();
                    this.version = Integer.parseInt(sversion);
                    this.storedString.put(sname, sversion);
                } else if (sname.equals("promc_description")) {
                    this.description = this.getTextFromScanner(this.zin);
                    this.storedString.put(sname, this.description);
                } else if (sname.equals("ProMCDescription.proto")) {
                    this.ProMCDescriptionTxt = this.getTextFromScanner(this.zin);
                    this.storedString.put(sname, this.ProMCDescriptionTxt);
                } else if (sname.equals("ProMCHeader.proto")) {
                    this.ProMCHeaderTxt = this.getTextFromScanner(this.zin);
                    this.storedString.put(sname, this.ProMCHeaderTxt);
                } else if (sname.equals("ProMC.proto")) {
                    this.ProMCTxt = this.getTextFromScanner(this.zin);
                    this.storedString.put(sname, this.ProMCTxt);
                } else if (sname.equals("ProMCStat.proto")) {
                    this.ProMCStatTxt = this.getTextFromScanner(this.zin);
                    this.storedString.put(sname, this.ProMCStatTxt);
                } else if (sname.equals("header")) {
                    this.storedProto.put(sname, ProMCHeaderFile.ProMCHeader.parseFrom(this.zin));
                } else if (sname.equals("statistics")) {
                    this.storedProto.put(sname, ProMCStatFile.ProMCStat.parseFrom(this.zin));
                } else if (sname.equals("description")) {
                    this.storedProto.put(sname, ProMCDescriptionFile.ProMCDescription.parseFrom(this.zin));
                } else if (sname.equals("logfile.txt")) {
                    this.LogFile = sname;
                    String log = this.getTextFromScanner(this.zin);
                    this.storedString.put(sname, log);
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buf = new byte[4096];
                    try {
                        int readNum;
                        while ((readNum = this.zin.read(buf)) != -1) {
                            bos.write(buf, 0, readNum);
                        }
                    }
                    catch (IOException ex) {
                        System.out.println(ex);
                    }
                    byte[] bytes = bos.toByteArray();
                    this.storedEvents.add(bytes);
                    ++tot;
                }
                this.zin.closeEntry();
                zipEntry = this.zin.getNextEntry();
            }
            if (this.debug) {
                System.out.println("Number of stored entries=" + this.storedEvents.size());
            }
            this.zin.close();
            if (this.debug) {
                System.out.println("Close ZIP");
            }
        }
        catch (IOException e) {
            this.ErrorMessage("Error in openning the file?");
        }
        if ((long)tot != this.nev) {
            this.ErrorMessage("The number records stored in the file is not equal metadata info. The file is corrupted?");
            return;
        }
    }

    public Map<String, Object> getStoredProtoURL() {
        return this.storedProto;
    }

    public void readMeta() {
        ZipEntry entry = this.zipFile.getEntry("promc_nevents");
        Date d = new Date(entry.getTime());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.LastModifiedTxt = formatter.format((Object)d);
        try {
            InputStream inputstream = this.zipFile.getInputStream(entry);
            this.nev = new Scanner(inputstream).nextLong();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in reading metadata promc_nevents. No event information is found.");
        }
        this.description = this.getStringZip("promc_description");
        this.ProMCDescriptionTxt = this.getStringZip("ProMCDescription.proto");
        this.ProMCHeaderTxt = this.getStringZip("ProMCHeader.proto");
        this.ProMCTxt = this.getStringZip("ProMC.proto");
        this.ProMCStatTxt = this.getStringZip("ProMCStat.proto");
        ZipEntry en = this.zipFile.getEntry("logfile.txt");
        this.LogFile = en != null ? "logfile.txt" : "none";
    }

    public String getLogfileTxt() {
        return this.LogFile;
    }

    public String readLogfile() {
        if (this.isURL) {
            return this.storedString.get("logfile.txt");
        }
        ZipEntry en = this.zipFile.getEntry("logfile.txt");
        if (en != null) {
            return this.getStringZip("logfile.txt");
        }
        return "";
    }

    public String getLastModified() {
        return this.LastModifiedTxt;
    }

    public String getProMCDescriptionTxt() {
        return this.ProMCDescriptionTxt;
    }

    public String getProMCHeaderTxt() {
        return this.ProMCHeaderTxt;
    }

    public String getProMCTxt() {
        return this.ProMCTxt;
    }

    public String getProMCStatTxt() {
        return this.ProMCStatTxt;
    }

    public long getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public long getEvents() {
        return this.nev;
    }

    public long getRequestedEvents() {
        return this.requested_nev;
    }

    public FileMC(String file) {
        this(file, "r");
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public long size() {
        return this.nev;
    }

    public long getNEntries() {
        return this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decompress(byte[] compressedData) {
        Inflater iflr = new Inflater();
        iflr.setInput(compressedData);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tmp = new byte[4096];
        try {
            while (!iflr.finished()) {
                int size = iflr.inflate(tmp);
                baos.write(tmp, 0, size);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return baos.toByteArray();
    }

    public String entriesToString() {
        String tmp = "";
        if (this.iif == null) {
            return tmp;
        }
        try {
            ZipEntry ze;
            while ((ze = this.zin.getNextEntry()) != null) {
                String a = ze.getName();
                if (!a.equals("info")) {
                    tmp = tmp + a + "\n";
                }
                this.zin.closeEntry();
            }
            this.zin.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public ProMC.ProMCEvent read() {
        ++this.nev;
        return this.read(this.nev);
    }

    public ProMCHeaderFile.ProMCHeader getHeader() {
        ProMCHeaderFile.ProMCHeader ob = null;
        ZipEntry entry = null;
        if (this.isURL) {
            return (ProMCHeaderFile.ProMCHeader)this.storedProto.get("header");
        }
        entry = this.zipFile.getEntry("header");
        if (entry == null) {
            return ob;
        }
        InputStream zz = null;
        ProMCHeaderFile.ProMCHeader record = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = ProMCHeaderFile.ProMCHeader.parseFrom(zz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ob;
        }
        if (record == null) {
            return ob;
        }
        return record;
    }

    public ProMCStatFile.ProMCStat getStat() {
        ProMCStatFile.ProMCStat record = null;
        if (this.isURL) {
            return (ProMCStatFile.ProMCStat)this.storedProto.get("statistics");
        }
        if (this.zipFile == null) {
            return record;
        }
        ZipEntry entry = this.zipFile.getEntry("statistics");
        if (entry == null) {
            return record;
        }
        InputStream zz = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = ProMCStatFile.ProMCStat.parseFrom(zz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return record;
    }

    public ProMCDescriptionFile.ProMCDescription fetchDescription() {
        ProMCDescriptionFile.ProMCDescription record = null;
        if (this.isURL) {
            return (ProMCDescriptionFile.ProMCDescription)this.storedProto.get("description");
        }
        if (this.zipFile == null) {
            return record;
        }
        ZipEntry entry = this.zipFile.getEntry("description");
        if (entry == null) {
            return record;
        }
        InputStream zz = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = ProMCDescriptionFile.ProMCDescription.parseFrom(zz);
            this.description = record.getDescription();
            this.version = record.getVersion();
            this.timestamp = record.getTimestamp();
            this.requested_nev = record.getEvents();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return record;
    }

    public ProMC.ProMCEvent read(long index) {
        ProMC.ProMCEvent record = null;
        if (this.isURL) {
            try {
                return ProMC.ProMCEvent.parseFrom(this.storedEvents.get((int)index));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Invalid data");
            }
        }
        ZipEntry entry = this.zipFile.getEntry(Long.toString(index));
        if (entry == null) {
            return record;
        }
        InputStream zz = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = ProMC.ProMCEvent.parseFrom(zz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return record;
    }

    public ProMC.ProMCEvent read(String key) {
        ProMC.ProMCEvent record = null;
        if (this.isURL) {
            int index = Integer.parseInt(key);
            try {
                return ProMC.ProMCEvent.parseFrom(this.storedEvents.get(index));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Invalid data");
            }
        }
        if (this.zipFile == null) {
            return record;
        }
        ZipEntry entry = this.zipFile.getEntry(key);
        if (entry == null) {
            return record;
        }
        InputStream zz = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = ProMC.ProMCEvent.parseFrom(zz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return record;
    }

    public boolean close() {
        boolean success = true;
        this.storedEvents = null;
        this.storedString = null;
        this.storedEvents = null;
        try {
            if (this.iif != null) {
                this.iif.close();
                this.zin.close();
                this.zipFile.close();
                this.iif = null;
                this.zin = null;
                this.zipFile = null;
            }
            if (this.oof != null) {
                this.zout.finish();
                this.zout.close();
                this.oof.flush();
                this.oof.close();
                this.oof = null;
            }
            if (this.zin != null) {
                this.zin = null;
            }
            System.gc();
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    private String getStringZip(String key) {
        String tmp = "";
        if (this.isURL) {
            tmp = this.storedString.get(key);
            return tmp;
        }
        if (this.zipFile == null) {
            return tmp;
        }
        ZipEntry entry = null;
        try {
            entry = this.zipFile.getEntry(key);
            if (entry != null) {
                InputStream inputstream = this.zipFile.getInputStream(entry);
                Scanner sc = new Scanner(inputstream);
                while (sc.hasNextLine()) {
                    tmp = tmp + sc.nextLine() + "\n";
                }
            }
        }
        catch (IOException e) {
            tmp = "Self-description " + key + " is not found";
        }
        return tmp;
    }

    private String getTextFromScanner(ZipInputStream xzin) {
        boolean err = false;
        int nli = 0;
        String tmp = "";
        Scanner sc = new Scanner(xzin);
        String str = " ";
        while (sc.hasNextLine()) {
            str = sc.nextLine();
            if (++nli > 10000) {
                err = true;
                break;
            }
            if (str == null) continue;
            tmp = tmp + str + "\n";
        }
        if (err) {
            String s = "File logfile.txt has more than 10,000 lines. \nProMC Browser for WWW files truncated it!\nPlease reduce the size of the log file.";
            tmp = tmp + "\n......\n\nProMC BROWSER WARNING:\n" + s;
        }
        return tmp;
    }

    private void ErrorMessage(String a) {
        System.err.println(a);
    }
}

