/*
 * Decompiled with CFR 0.152.
 */
package probrowser.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import probrowser.editor.ProtoSyntaxDocument;

public class SimpleEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ProtoSyntaxDocument archiveModel;
    private Action openAction = new OpenAction();
    private Action saveAction = new SaveAction();
    private JTextComponent textComp;
    private Hashtable actionHash = new Hashtable();

    public static void main(String[] args) {
        SimpleEditor editor = new SimpleEditor();
        editor.setDefaultCloseOperation(2);
        editor.setVisible(true);
    }

    public SimpleEditor() {
        super("ProMC Editor");
        this.setDefaultCloseOperation(2);
        this.textComp = this.createTextComponent();
        this.textComp.setFont(new Font("Monospaced", 0, 14));
        this.makeActionsPretty();
        Container content = this.getContentPane();
        content.add((Component)this.textComp, "Center");
        this.setJMenuBar(this.createMenuBar());
        this.setSize(320, 240);
        this.setVisible(true);
    }

    public SimpleEditor(String pro_txt, boolean isLog) {
        super("ProMC Editor");
        this.setDefaultCloseOperation(2);
        this.textComp = isLog ? this.createTextComponentLog() : this.createTextComponent();
        this.textComp.setFont(new Font("Monospaced", 0, 14));
        this.makeActionsPretty();
        Container content = this.getContentPane();
        JScrollPane scroller = new JScrollPane(this.textComp);
        this.textComp.setText(pro_txt);
        if (!isLog) {
            scroller.getViewport().setViewPosition(new Point(0, 0));
            this.textComp.setCaretPosition(0);
        }
        content.add((Component)scroller, "Center");
        content.add((Component)this.createToolBar(), "North");
        this.setJMenuBar(this.createMenuBar());
        this.setSize(600, 400);
        this.setVisible(true);
    }

    protected JTextComponent createTextComponent() {
        this.archiveModel = new ProtoSyntaxDocument();
        JTextPane ta = new JTextPane(this.archiveModel);
        ta.setEditable(false);
        return ta;
    }

    protected JTextComponent createTextComponentLog() {
        this.archiveModel = new ProtoSyntaxDocument();
        JTextArea ta = new JTextArea();
        ta.setLineWrap(true);
        ta.setEditable(false);
        return ta;
    }

    protected void makeActionsPretty() {
    }

    protected JToolBar createToolBar() {
        JToolBar bar = new JToolBar();
        return bar;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenu edit = new JMenu("Edit");
        menubar.add(file);
        menubar.add(edit);
        file.add(this.getOpenAction());
        file.add(this.getSaveAction());
        file.add(new ExitAction());
        edit.add(this.textComp.getActionMap().get("cut-to-clipboard"));
        edit.add(this.textComp.getActionMap().get("copy-to-clipboard"));
        edit.add(this.textComp.getActionMap().get("paste-from-clipboard"));
        edit.add(this.textComp.getActionMap().get("select-all"));
        return menubar;
    }

    protected Action getOpenAction() {
        return this.openAction;
    }

    protected Action getSaveAction() {
        return this.saveAction;
    }

    protected JTextComponent getTextComponent() {
        return this.textComp;
    }

    class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super("Save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ev) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(SimpleEditor.this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                SimpleEditor.this.textComp.write(writer);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(SimpleEditor.this, "File Not Saved", "ERROR", 0);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OpenAction() {
            super("Open");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ev) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showOpenDialog(SimpleEditor.this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                SimpleEditor.this.textComp.read(reader, null);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(SimpleEditor.this, "File Not Found", "ERROR", 0);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            SimpleEditor.this.setVisible(false);
            SimpleEditor.this.dispose();
        }
    }
}

