/*
 * Decompiled with CFR 0.152.
 */
package probrowser;

import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

class HighlightTableCellRenderer
extends JTextField
implements TableCellRenderer {
    private static final Color backgroundSelectionColor = new Color(220, 240, 255);
    private static final Highlighter.HighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private String pattern = "";
    private String prev = null;

    public boolean setPattern(String str) {
        if (str == null || str.equals(this.pattern)) {
            return false;
        }
        this.prev = this.pattern;
        this.pattern = str;
        return true;
    }

    public HighlightTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setEditable(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Matcher matcher;
        String txt = Objects.toString(value, "");
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
        this.setText(txt);
        this.setBackground(isSelected ? backgroundSelectionColor : Color.WHITE);
        if (this.pattern != null && !this.pattern.isEmpty() && !this.pattern.equals(this.prev) && (matcher = Pattern.compile(this.pattern).matcher(txt)).find()) {
            int start = matcher.start();
            int end = matcher.end();
            try {
                highlighter.addHighlight(start, end, highlightPainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return this;
    }
}

