/*
 * Decompiled with CFR 0.152.
 */
package hepsim;

import hepsim.HepSim;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import promc.io.ProMC;
import promc.io.ProMCDescriptionFile;
import promc.io.ProMCHeaderFile;
import promc.io.ProMCStatFile;
import proto.FileMC;

public class Zip64 {
    static final int BUFFER = 4096;
    private static byte[] data;
    static FileOutputStream oof;
    static ZipOutputStream zout;

    public static void main(String[] args) {
        if (args.length > 0) {
            DecimalFormat formatter = new DecimalFormat("0.#####E0");
            DecimalFormat formatter1 = new DecimalFormat("0.###E0");
            String surl = args[0].trim();
            FileMC promc = new FileMC(surl, "r");
            long version = promc.getVersion();
            String decription = promc.getDescription();
            long nev1 = promc.getNEntries();
            ProMCDescriptionFile.ProMCDescription desc = promc.fetchDescription();
            ProMCHeaderFile.ProMCHeader header = promc.getHeader();
            int unit = header.getMomentumUnit();
            int lunit = header.getLengthUnit();
            boolean isLog = true;
            if (promc.getLogfileTxt().indexOf("logfile") == -1) {
                isLog = false;
            }
            ProMCStatFile.ProMCStat stat = promc.getStat();
            System.out.println("File          = " + surl);
            String cross = formatter.format(stat.getCrossSectionAccumulated());
            String error = formatter.format(stat.getCrossSectionErrorAccumulated());
            System.out.println("Events        = " + Long.toString(nev1));
            if (promc.getRequestedEvents() > 0L) {
                System.out.println("Requested     = " + Long.toString(promc.getRequestedEvents()));
            }
            System.out.println("Lumi   (pb-1) = " + formatter.format(stat.getLuminosityAccumulated()));
            if (!isLog) {
                System.err.println("\u001b[33mWarning: Log file \"logfile.txt\" was not attached!\u001b[0m");
            }
            String zipFile = surl.replace(".promc", "_zip64.promc");
            try {
                data = new byte[4096];
                new File(zipFile).delete();
                oof = new FileOutputStream(zipFile);
                zout = new ZipOutputStream(new BufferedOutputStream(oof));
                Zip64.writeInfo("version", Long.toString(version));
                ProMCDescriptionFile.ProMCDescription.Builder desc_header = desc.toBuilder();
                try {
                    data = desc_header.build().toByteArray();
                    ZipEntry entry = new ZipEntry("description");
                    zout.putNextEntry(entry);
                    entry.setSize(data.length);
                    zout.write(data);
                    zout.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ProMCHeaderFile.ProMCHeader.Builder rec_header = header.toBuilder();
                try {
                    data = rec_header.build().toByteArray();
                    ZipEntry entry = new ZipEntry("header");
                    zout.putNextEntry(entry);
                    entry.setSize(data.length);
                    zout.write(data);
                    zout.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int event = 0;
                while ((long)event < nev1) {
                    ProMC.ProMCEvent ss = promc.read(event);
                    ProMC.ProMCEvent.Builder record = ss.toBuilder();
                    try {
                        data = record.build().toByteArray();
                        ZipEntry entry = new ZipEntry(Integer.toString(event));
                        zout.putNextEntry(entry);
                        entry.setSize(data.length);
                        zout.write(data);
                        zout.closeEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++event;
                }
                Zip64.writeInfo("promc_description", decription);
                Zip64.writeInfo("promc_nevents", Long.toString(nev1));
                ProMCStatFile.ProMCStat.Builder rec_stat = stat.toBuilder();
                try {
                    data = rec_stat.build().toByteArray();
                    ZipEntry entry = new ZipEntry("statistics");
                    zout.putNextEntry(entry);
                    entry.setSize(data.length);
                    zout.write(data);
                    zout.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Zip64.writeInfo("ProMCHeader.proto", promc.getProMCHeaderTxt());
                Zip64.writeInfo("ProMC.proto", promc.getProMCTxt());
                Zip64.writeInfo("ProMCStat.proto", promc.getProMCStatTxt());
                Zip64.writeInfo("ProMCDescription.proto", promc.getProMCDescriptionTxt());
                Zip64.writeInfo("logfile.txt", promc.readLogfile());
                zout.finish();
                zout.close();
                oof.flush();
                oof.close();
                oof = null;
                System.out.println("\u001b[32mCreated " + zipFile + "  using ZIP64 with " + Long.toString(nev1) + " events" + "\u001b[0m");
            }
            catch (IOException ioe) {
                System.out.println("Error creating zip file: " + ioe);
            }
            promc.close();
        } else {
            HepSim.ErrorMessage("Usage: It takes 1 argument:  ProMC file location (or its URL)");
            System.exit(1);
        }
    }

    static void writeInfo(String key, String info) {
        try {
            ZipEntry entry = new ZipEntry(key);
            zout.putNextEntry(entry);
            String a = new String(info);
            byte[] theByteArray = a.getBytes();
            entry.setSize(theByteArray.length);
            zout.write(theByteArray);
            zout.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

