/*
 * Decompiled with CFR 0.152.
 */
package hepsim;

import hepsim.Get;
import hepsim.HepSim;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Exec {
    public static void main(String[] args) {
        int j;
        String root = "";
        String surl = null;
        String mess = "";
        String delphes = "";
        String delphes_tcl = "";
        int nfiles = -1;
        if (args.length > 0) {
            for (String arg : args) {
                String ss = arg.toLowerCase().trim();
                if (ss.startsWith("http")) {
                    surl = ss;
                }
                if (ss.indexOf(".root") > -1) {
                    root = ss;
                }
                if (ss.indexOf("delphespromc") > -1) {
                    delphes = arg.trim();
                }
                if (ss.indexOf(".tcl") > -1) {
                    delphes_tcl = arg.trim();
                }
                mess = mess + arg + " ";
            }
            try {
                nfiles = Integer.parseInt(args[args.length - 1]);
                System.out.println("HepSim: Nr of input files limitted to " + Integer.toString(nfiles));
            }
            catch (NumberFormatException e) {
                nfiles = -1;
            }
            if (surl == null) {
                System.err.println("\u001b[31mHepSim: Wrong usage. No URL of HepSim was detected. Exit!\u001b[0m");
                System.exit(1);
            }
        } else {
            System.err.println("\u001b[31mHepSim: It takes arguments for execution. One should be URL of HepSim. Exit!\u001b[0m");
            System.exit(1);
        }
        if (!HepSim.isValidURL(surl)) {
            System.err.println("\u001b[31mHepSim: First argument is not valid URL. Exit!\u001b[0m");
            System.exit(0);
        }
        long tot = 0L;
        System.out.println("HepSim: Looking for " + surl);
        ArrayList<ArrayList<String>> ar = HepSim.getArray(surl);
        ArrayList tmp = new ArrayList();
        ArrayList<ArrayList<String>> arr = new ArrayList<ArrayList<String>>();
        for (j = 0; j < ar.size() && (nfiles <= -1 || j <= nfiles - 1); ++j) {
            arr.add(ar.get(j));
        }
        for (j = 0; j < arr.size(); ++j) {
            ArrayList s1 = (ArrayList)arr.get(j);
            String sfile = ((String)s1.get(0)).trim();
            String sizes = ((String)s1.get(1)).trim();
            long xs = Long.parseLong(sizes);
            tot += xs;
        }
        double xdd = 0.001 * (double)tot;
        String fileSize = Integer.toString((int)xdd);
        System.out.println("HepSim: Input: Nr of files=" + Integer.toString(arr.size()) + "  Total size=" + fileSize + " MB");
        System.out.println("\u001b[32mHepSim: Start running..\u001b[0m");
        String theDir = "";
        String theDirOut = "";
        if (delphes.length() > 1 && delphes_tcl.length() > 0) {
            theDir = "hepsim_input";
            Exec.makeDir(theDir);
            theDirOut = "hepsim_output";
            Exec.makeDir(theDirOut);
        }
        for (int j2 = 0; j2 < arr.size(); ++j2) {
            ArrayList s1 = (ArrayList)arr.get(j2);
            String sfile = ((String)s1.get(0)).trim();
            String inputURL = surl + "/" + sfile;
            String destFile = theDir + File.separator + sfile;
            File dest = new File(destFile);
            Get d = new Get(inputURL, dest);
            if (delphes.length() > 1 && delphes_tcl.length() > 0) {
                String base = sfile.replace(".promc", "");
                mess = mess.replace(surl, destFile);
                String outputbase = root.replace(".root", "");
                String outputroot = root.replace(".root", "_" + base + ".root");
                mess = mess.replace(root, outputroot);
                mess = delphes + " " + delphes_tcl + " " + theDirOut + File.separator + outputroot + " " + destFile;
            }
            System.out.println(mess);
            try {
                String s;
                Process p = Runtime.getRuntime().exec(mess);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = stdInput.readLine()) != null) {
                    System.out.println(s);
                }
                while ((s = stdError.readLine()) != null) {
                    System.out.println(s);
                }
            }
            catch (IOException e) {
                System.err.println("\u001b[31mHepSim: Exception happened:\u001b[0m");
                e.printStackTrace();
                System.exit(-1);
            }
            try {
                if (dest.delete()) continue;
                System.out.println("HepSim: Cleaning of tmp file has failed. Exit!");
                System.exit(1);
                continue;
            }
            catch (Exception e) {
                System.err.println("\u001b[31mHepSim: Exception happened:\u001b[0m");
                e.printStackTrace();
            }
        }
        Exec.purgeDirectory(new File(theDir));
        System.out.println("\u001b[32mHepSim: End! Output files are in " + theDirOut + "\u001b[0m");
    }

    static void purgeDirectory(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Exec.purgeDirectory(file);
            }
            file.delete();
        }
        dir.delete();
    }

    static void purgeDirectoryAndRemove(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Exec.purgeDirectory(file);
            }
            file.delete();
        }
        dir.delete();
    }

    static void makeDir(String theD) {
        File theDir = new File(theD);
        if (!theDir.exists()) {
            boolean result = false;
            try {
                theDir.mkdir();
                result = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (result) {
                System.out.println("HepSim: creating directory: " + theDir);
            }
        }
    }
}

