/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple2i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Tuple4f;
import javax.vecmath.Tuple4i;

abstract class ShaderAttributeObjectRetained
extends ShaderAttributeRetained {
    private int classType;
    private Class baseClass;
    AttrWrapper attrWrapper;
    static final int TYPE_INTEGER = 0;
    static final int TYPE_FLOAT = 1;
    static final int TYPE_TUPLE2I = 2;
    static final int TYPE_TUPLE2F = 3;
    static final int TYPE_TUPLE3I = 4;
    static final int TYPE_TUPLE3F = 5;
    static final int TYPE_TUPLE4I = 6;
    static final int TYPE_TUPLE4F = 7;
    static final int TYPE_MATRIX3F = 8;
    static final int TYPE_MATRIX4F = 9;
    static final Class[] classTable = new Class[]{Integer.class, Float.class, Tuple2i.class, Tuple2f.class, Tuple3i.class, Tuple3f.class, Tuple4i.class, Tuple4f.class, Matrix3f.class, Matrix4f.class};
    static final Class[] classTableArr = new Class[]{Integer[].class, Float[].class, Tuple2i[].class, Tuple2f[].class, Tuple3i[].class, Tuple3f[].class, Tuple4i[].class, Tuple4f[].class, Matrix3f[].class, Matrix4f[].class};

    ShaderAttributeObjectRetained() {
    }

    void createObjectData(Object object) {
        this.classType = this.computeClassType(object);
        this.baseClass = this.getBaseClass(this.classType);
        this.attrWrapper = this.createAttrWrapper(object, this.classType);
    }

    void initValue(Object object) {
        this.attrWrapper.set(object);
    }

    Object getValue() {
        return this.attrWrapper.get();
    }

    void setValue(Object object) {
        this.initValue(object);
        AttrWrapper attrWrapper = this.createAttrWrapper(object, this.classType);
        this.sendMessage(8, attrWrapper);
    }

    Class getValueClass() {
        return this.baseClass;
    }

    synchronized void initMirrorObject() {
        super.initMirrorObject();
        ((ShaderAttributeObjectRetained)this.mirror).initValue(this.getValue());
    }

    synchronized void updateMirrorObject(int n, Object object) {
        ShaderAttributeObjectRetained shaderAttributeObjectRetained = (ShaderAttributeObjectRetained)this.mirror;
        if ((n & 8) != 0) {
            shaderAttributeObjectRetained.attrWrapper = (AttrWrapper)object;
        }
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 63;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 63;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    abstract int computeClassType(Object var1);

    abstract Class getBaseClass(int var1);

    abstract AttrWrapper createAttrWrapper(Object var1, int var2);

    int getClassType() {
        return this.classType;
    }

    void setClassType(int n) {
        this.classType = n;
    }

    void setFrequencyChangeMask(int n, int n2) {
        if (this.source.getCapability(n)) {
            this.changedFrequent |= n2;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~n2;
        }
    }

    void handleFrequencyChange(int n) {
        if (n == 1) {
            this.setFrequencyChangeMask(n, 1);
        }
    }

    static abstract class AttrWrapper {
        AttrWrapper() {
        }

        abstract void set(Object var1);

        abstract Object get();

        abstract Object getRef();
    }
}

