/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.J3dNotification;
import javax.media.j3d.RenderingError;
import javax.media.j3d.ShaderError;
import javax.media.j3d.VirtualUniverse;

class NotificationThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private volatile boolean running = true;
    private boolean waiting = false;
    private boolean ready = false;
    private ArrayList<J3dNotification> notificationQueue = new ArrayList();

    NotificationThread(ThreadGroup threadGroup) {
        super(threadGroup, "J3D-NotificationThread");
    }

    synchronized void addNotification(J3dNotification j3dNotification) {
        this.notificationQueue.add(j3dNotification);
        this.runMonitor(1);
    }

    private synchronized J3dNotification[] getNotifications() {
        J3dNotification[] j3dNotificationArray = new J3dNotification[this.notificationQueue.size()];
        j3dNotificationArray = this.notificationQueue.toArray(j3dNotificationArray);
        this.notificationQueue.clear();
        return j3dNotificationArray;
    }

    private void processNotifications() {
        J3dNotification[] j3dNotificationArray = this.getNotifications();
        block4: for (int i = 0; i < j3dNotificationArray.length; ++i) {
            J3dNotification j3dNotification = j3dNotificationArray[i];
            switch (j3dNotification.type) {
                case 0: {
                    j3dNotification.universe.notifyShaderErrorListeners((ShaderError)j3dNotification.args[0]);
                    continue block4;
                }
                case 1: {
                    VirtualUniverse.notifyRenderingErrorListeners((RenderingError)j3dNotification.args[0]);
                    continue block4;
                }
                default: {
                    System.err.println("J3dNotification.processNotifications: unrecognized type = " + j3dNotification.type);
                }
            }
        }
    }

    void finish() {
        this.runMonitor(2);
    }

    public void run() {
        while (this.running) {
            this.runMonitor(0);
            this.processNotifications();
        }
    }

    private synchronized void runMonitor(int n) {
        switch (n) {
            case 0: {
                while (this.running && !this.ready) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

