/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RenderDataProvider;

public class DefaultOutlineCellRenderer
extends DefaultTableCellRenderer {
    private static int expansionHandleWidth = 0;
    private static int expansionHandleHeight = 0;
    private boolean expanded = false;
    private boolean leaf = true;
    private boolean showHandle = true;
    private int nestingDepth = 0;
    private final JCheckBox theCheckBox;
    private final CellRendererPane fakeCellRendererPane;
    private JCheckBox checkBox;
    private Reference<RenderDataProvider> lastRendererRef = new WeakReference<Object>(null);
    private Reference<Object> lastRenderedValueRef = new WeakReference<Object>(null);
    private static final Border expansionBorder = new ExpansionHandleBorder();

    public DefaultOutlineCellRenderer() {
        this.theCheckBox = new JCheckBox();
        this.theCheckBox.setSize(this.theCheckBox.getPreferredSize());
        this.theCheckBox.setBorderPainted(false);
        this.theCheckBox.setOpaque(false);
        this.fakeCellRendererPane = new CellRendererPane();
        this.fakeCellRendererPane.add(this.theCheckBox);
    }

    public final void setBorder(Border border) {
        if (border == expansionBorder) {
            super.setBorder(border);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(border, expansionBorder));
        }
    }

    private static Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    private static Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    private static Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    static Icon getExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    static Icon getCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    static int getNestingWidth() {
        return DefaultOutlineCellRenderer.getExpansionHandleWidth();
    }

    static int getExpansionHandleWidth() {
        if (expansionHandleWidth == 0) {
            expansionHandleWidth = DefaultOutlineCellRenderer.getExpandedIcon().getIconWidth();
        }
        return expansionHandleWidth;
    }

    static int getExpansionHandleHeight() {
        if (expansionHandleHeight == 0) {
            expansionHandleHeight = DefaultOutlineCellRenderer.getExpandedIcon().getIconHeight();
        }
        return expansionHandleHeight;
    }

    private void setNestingDepth(int n) {
        this.nestingDepth = n;
    }

    private void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    private void setLeaf(boolean bl) {
        this.leaf = bl;
    }

    private void setShowHandle(boolean bl) {
        this.showHandle = bl;
    }

    private void setCheckBox(JCheckBox jCheckBox) {
        this.checkBox = jCheckBox;
    }

    private boolean isLeaf() {
        return this.leaf;
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    private boolean isShowHandle() {
        return this.showHandle;
    }

    private int getNestingDepth() {
        return this.nestingDepth;
    }

    private JCheckBox getCheckBox() {
        return this.checkBox;
    }

    int getTheCheckBoxWidth() {
        return this.theCheckBox.getSize().width;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        Outline outline = (Outline)jTable;
        if (outline.isTreeColumnIndex(n2)) {
            int n3;
            AbstractLayoutCache abstractLayoutCache = outline.getLayoutCache();
            n = outline.convertRowIndexToModel(n);
            boolean bl3 = outline.getOutlineModel().isLeaf(object);
            this.setLeaf(bl3);
            this.setShowHandle(true);
            TreePath treePath = abstractLayoutCache.getPathForRow(n);
            boolean bl4 = abstractLayoutCache.isExpanded(treePath);
            this.setExpanded(bl4);
            int n4 = treePath == null ? 0 : (n3 = treePath.getPathCount() - (outline.isRootVisible() ? 1 : 2));
            if (n3 < 0) {
                n3 = 0;
            }
            this.setNestingDepth(n3);
            RenderDataProvider renderDataProvider = outline.getRenderDataProvider();
            Icon icon = null;
            if (renderDataProvider != null && object != null) {
                CheckRenderDataProvider checkRenderDataProvider;
                String string = renderDataProvider.getDisplayName(object);
                if (string != null) {
                    this.setText(string);
                }
                this.lastRendererRef = new WeakReference<RenderDataProvider>(renderDataProvider);
                this.lastRenderedValueRef = new WeakReference<Object>(object);
                Color color = renderDataProvider.getBackground(object);
                Color color2 = renderDataProvider.getForeground(object);
                if (color != null && !bl) {
                    this.setBackground(color);
                } else {
                    this.setBackground(bl ? outline.getSelectionBackground() : outline.getBackground());
                }
                if (color2 != null && !bl) {
                    this.setForeground(color2);
                } else {
                    this.setForeground(bl ? outline.getSelectionForeground() : outline.getForeground());
                }
                icon = renderDataProvider.getIcon(object);
                JCheckBox jCheckBox = null;
                if (renderDataProvider instanceof CheckRenderDataProvider && (checkRenderDataProvider = (CheckRenderDataProvider)renderDataProvider).isCheckable(object)) {
                    jCheckBox = this.theCheckBox;
                    Boolean bl5 = checkRenderDataProvider.isSelected(object);
                    jCheckBox.setSelected(!Boolean.FALSE.equals(bl5));
                    jCheckBox.getModel().setArmed(bl5 == null);
                    jCheckBox.getModel().setPressed(bl5 == null);
                    jCheckBox.setEnabled(checkRenderDataProvider.isCheckEnabled(object));
                    jCheckBox.setBackground(this.getBackground());
                }
                this.setCheckBox(jCheckBox);
            }
            if (icon == null) {
                if (!bl3) {
                    if (bl4) {
                        this.setIcon(DefaultOutlineCellRenderer.getDefaultOpenIcon());
                    } else {
                        this.setIcon(DefaultOutlineCellRenderer.getDefaultClosedIcon());
                    }
                } else {
                    this.setIcon(DefaultOutlineCellRenderer.getDefaultLeafIcon());
                }
            } else {
                this.setIcon(icon);
            }
        } else {
            this.setIcon(null);
            this.setShowHandle(false);
        }
        return this;
    }

    public String getToolTipText() {
        String string;
        RenderDataProvider renderDataProvider = this.lastRendererRef.get();
        Object object = this.lastRenderedValueRef.get();
        if (renderDataProvider != null && object != null && (string = renderDataProvider.getTooltipText(object)) != null && (string = string.trim()).length() > 0) {
            return string;
        }
        return super.getToolTipText();
    }

    private static class ExpansionHandleBorder
    implements Border {
        private static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
        private Insets insets = new Insets(0, 0, 0, 0);
        private static JLabel lExpandedIcon = null;
        private static JLabel lCollapsedIcon = null;

        private ExpansionHandleBorder() {
            if (isGtk) {
                lExpandedIcon = new JLabel(DefaultOutlineCellRenderer.getExpandedIcon(), 11);
                lCollapsedIcon = new JLabel(DefaultOutlineCellRenderer.getCollapsedIcon(), 11);
            }
        }

        public Insets getBorderInsets(Component component) {
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)component;
            if (defaultOutlineCellRenderer.isShowHandle()) {
                this.insets.left = DefaultOutlineCellRenderer.getExpansionHandleWidth() + defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            } else {
                this.insets.left = 1;
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            }
            if (defaultOutlineCellRenderer.getCheckBox() != null) {
                this.insets.left += ((DefaultOutlineCellRenderer)defaultOutlineCellRenderer).getCheckBox().getSize().width;
            }
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Object object;
            int n5;
            Object object2;
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)component;
            if (defaultOutlineCellRenderer.isShowHandle() && !defaultOutlineCellRenderer.isLeaf()) {
                object2 = defaultOutlineCellRenderer.isExpanded() ? DefaultOutlineCellRenderer.getExpandedIcon() : DefaultOutlineCellRenderer.getCollapsedIcon();
                int n6 = defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                n5 = object2.getIconHeight() < n4 ? n4 / 2 - object2.getIconHeight() / 2 : 0;
                if (isGtk) {
                    object = defaultOutlineCellRenderer.isExpanded() ? lExpandedIcon : lCollapsedIcon;
                    ((Component)object).setSize(Math.max(DefaultOutlineCellRenderer.getExpansionHandleWidth(), n6 + DefaultOutlineCellRenderer.getExpansionHandleWidth()), n4);
                    ((JComponent)object).paint(graphics);
                } else {
                    object2.paintIcon(component, graphics, n6, n5);
                }
            }
            if ((object2 = defaultOutlineCellRenderer.getCheckBox()) != null) {
                n5 = DefaultOutlineCellRenderer.getExpansionHandleWidth() + defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                Dimension dimension = ((Component)object2).getSize();
                object = graphics.create(n5, 0, dimension.width, dimension.height);
                ((JComponent)object2).paint((Graphics)object);
            }
        }
    }
}

