/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class Binomial {
    public static boolean test(int k, int n, double p, boolean is_twoTailed, double aLevel) {
        if (k < 0 || n <= 0 || p < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double pvalue = Binomial.scoreToPvalue(k, n, p);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n, double p) {
        double z = (score + 0.5 - (double)n * p) / Math.sqrt((double)n * p * (1.0 - p));
        return ContinuousDistributions.gaussCdf(z);
    }
}

