/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.mathematics.discrete;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Combinatorics {
    public static <T> Collection<List<T>> permutations(Collection<T> elements) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (elements.isEmpty()) {
            result.add(new LinkedList());
            return result;
        }
        LinkedList<T> rest = new LinkedList<T>(elements);
        Object head = rest.remove(0);
        for (List<T> permutations : Combinatorics.permutations(rest)) {
            ArrayList subLists = new ArrayList();
            for (int i = 0; i <= permutations.size(); ++i) {
                ArrayList<Object> subList = new ArrayList<Object>();
                subList.addAll(permutations);
                subList.add(i, head);
                subLists.add(subList);
            }
            result.addAll(subLists);
        }
        return result;
    }

    public static <T> Set<Set<T>> combinations(Set<T> elements, int subsetSize) {
        return Combinatorics.combinationsStream(elements, subsetSize).collect(Collectors.toSet());
    }

    public static <T> Stream<Set<T>> combinationsStream(Set<T> elements, int subsetSize) {
        if (subsetSize == 0) {
            return Stream.of(new HashSet());
        }
        if (subsetSize <= elements.size()) {
            Set<T> remainingElements = elements;
            Iterator<T> it = remainingElements.iterator();
            Object X = it.next();
            it.remove();
            Stream<Set<T>> combinations = Stream.concat(Combinatorics.combinationsStream(remainingElements, subsetSize), Combinatorics.combinationsStream(remainingElements, subsetSize - 1).map(s -> {
                s.add(X);
                return s;
            }));
            remainingElements.add(X);
            return combinations;
        }
        return Stream.empty();
    }

    public static <T> Iterator<T[]> combinationsIterator(final T[] elements, final int subsetSize) {
        return new Iterator<T[]>(){
            private int r = 0;
            private int index = 0;
            private final int[] selectedIndexes = new int[subsetSize];
            private Boolean hasNext = null;

            @Override
            public boolean hasNext() {
                if (this.hasNext == null) {
                    this.hasNext = this.locateNext();
                }
                return this.hasNext;
            }

            @Override
            public T[] next() {
                this.hasNext = null;
                Object[] combination = (Object[])Array.newInstance(elements[0].getClass(), subsetSize);
                for (int i = 0; i < subsetSize; ++i) {
                    combination[i] = elements[this.selectedIndexes[i]];
                }
                return combination;
            }

            private boolean locateNext() {
                if (subsetSize == 0) {
                    return false;
                }
                int N = elements.length;
                while (true) {
                    if (this.index <= N + (this.r - subsetSize)) {
                        ++this.index;
                        if (this.r == subsetSize - 1) {
                            return true;
                        }
                        ++this.r;
                        continue;
                    }
                    --this.r;
                    if (this.r < 0) {
                        return false;
                    }
                    this.index = this.selectedIndexes[this.r] + 1;
                }
            }
        };
    }
}

