/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.modelselection.metrics;

import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelselection.AbstractMetrics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassificationMetrics
extends AbstractMetrics {
    private static final long serialVersionUID = 1L;
    private double accuracy = 0.0;
    private double macroPrecision = 0.0;
    private double macroRecall = 0.0;
    private double macroF1 = 0.0;
    private final Map<Object, Double> microPrecision = new HashMap<Object, Double>();
    private final Map<Object, Double> microRecall = new HashMap<Object, Double>();
    private final Map<Object, Double> microF1 = new HashMap<Object, Double>();
    private final Map<List<Object>, Double> contingencyTable = new HashMap<List<Object>, Double>();

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getMacroPrecision() {
        return this.macroPrecision;
    }

    public double getMacroRecall() {
        return this.macroRecall;
    }

    public double getMacroF1() {
        return this.macroF1;
    }

    public Map<Object, Double> getMicroPrecision() {
        return this.microPrecision;
    }

    public Map<Object, Double> getMicroRecall() {
        return this.microRecall;
    }

    public Map<Object, Double> getMicroF1() {
        return this.microF1;
    }

    public Map<List<Object>, Double> getContingencyTable() {
        return this.contingencyTable;
    }

    public ClassificationMetrics(Dataframe predictedData) {
        super(predictedData);
        HashSet<Object> classesSet = new HashSet<Object>();
        for (Record record : predictedData) {
            classesSet.add(record.getY());
            classesSet.add(record.getYPredicted());
        }
        for (Record record : classesSet) {
            this.contingencyTable.put(Arrays.asList(new Object[]{record, SensitivityRates.TRUE_POSITIVE}), 0.0);
            this.contingencyTable.put(Arrays.asList(new Object[]{record, SensitivityRates.FALSE_POSITIVE}), 0.0);
            this.contingencyTable.put(Arrays.asList(new Object[]{record, SensitivityRates.TRUE_NEGATIVE}), 0.0);
            this.contingencyTable.put(Arrays.asList(new Object[]{record, SensitivityRates.FALSE_NEGATIVE}), 0.0);
        }
        int n = predictedData.size();
        int n2 = classesSet.size();
        int correctCount = 0;
        for (Record r : predictedData) {
            List<Object> tpk;
            Object object = r.getYPredicted();
            if (object.equals(r.getY())) {
                ++correctCount;
                for (Object e : classesSet) {
                    if (e.equals(object)) {
                        tpk = Arrays.asList(new Object[]{e, SensitivityRates.TRUE_POSITIVE});
                        this.contingencyTable.put(tpk, this.contingencyTable.get(tpk) + 1.0);
                        continue;
                    }
                    tpk = Arrays.asList(new Object[]{e, SensitivityRates.TRUE_NEGATIVE});
                    this.contingencyTable.put(tpk, this.contingencyTable.get(tpk) + 1.0);
                }
                continue;
            }
            for (Object e : classesSet) {
                if (e.equals(object)) {
                    tpk = Arrays.asList(new Object[]{e, SensitivityRates.FALSE_POSITIVE});
                    this.contingencyTable.put(tpk, this.contingencyTable.get(tpk) + 1.0);
                    continue;
                }
                if (e.equals(r.getY())) {
                    tpk = Arrays.asList(new Object[]{e, SensitivityRates.FALSE_NEGATIVE});
                    this.contingencyTable.put(tpk, this.contingencyTable.get(tpk) + 1.0);
                    continue;
                }
                tpk = Arrays.asList(new Object[]{e, SensitivityRates.TRUE_NEGATIVE});
                this.contingencyTable.put(tpk, this.contingencyTable.get(tpk) + 1.0);
            }
        }
        this.accuracy = (double)correctCount / (double)n;
        int activeClasses = n2;
        for (Object e : classesSet) {
            double tp = this.contingencyTable.get(Arrays.asList(new Object[]{e, SensitivityRates.TRUE_POSITIVE}));
            double fp = this.contingencyTable.get(Arrays.asList(new Object[]{e, SensitivityRates.FALSE_POSITIVE}));
            double fn = this.contingencyTable.get(Arrays.asList(new Object[]{e, SensitivityRates.FALSE_NEGATIVE}));
            double classPrecision = 0.0;
            double classRecall = 0.0;
            double classF1 = 0.0;
            if (tp > 0.0) {
                classPrecision = tp / (tp + fp);
                classRecall = tp / (tp + fn);
                classF1 = 2.0 * classPrecision * classRecall / (classPrecision + classRecall);
            } else if (tp == 0.0 && fp == 0.0 && fn == 0.0) {
                --activeClasses;
            }
            this.microPrecision.put(e, classPrecision);
            this.microRecall.put(e, classRecall);
            this.microF1.put(e, classF1);
            this.macroPrecision += classPrecision;
            this.macroRecall += classRecall;
            this.macroF1 += classF1;
        }
        this.macroPrecision /= (double)activeClasses;
        this.macroRecall /= (double)activeClasses;
        this.macroF1 /= (double)activeClasses;
    }

    public ClassificationMetrics(List<ClassificationMetrics> validationMetricsList) {
        super(validationMetricsList);
        int k = validationMetricsList.size();
        for (ClassificationMetrics vmSample : validationMetricsList) {
            Set<Object> classesSet = vmSample.getMicroPrecision().keySet();
            for (Object theClass : classesSet) {
                Map<List<Object>, Double> ctEntryMap = vmSample.getContingencyTable();
                for (SensitivityRates sr : SensitivityRates.values()) {
                    List<Object> tpk = Arrays.asList(new Object[]{theClass, sr});
                    Double previousValue = this.contingencyTable.getOrDefault(tpk, 0.0);
                    this.contingencyTable.put(tpk, previousValue + ctEntryMap.get(tpk) / (double)k);
                }
                Double previousPrecision = this.microPrecision.getOrDefault(theClass, 0.0);
                this.microPrecision.put(theClass, previousPrecision + vmSample.getMicroPrecision().get(theClass) / (double)k);
                Double previousRecall = this.microRecall.getOrDefault(theClass, 0.0);
                this.microRecall.put(theClass, previousRecall + vmSample.getMicroRecall().get(theClass) / (double)k);
                Double previousF1 = this.microF1.getOrDefault(theClass, 0.0);
                this.microF1.put(theClass, previousF1 + vmSample.getMicroF1().get(theClass) / (double)k);
            }
            this.accuracy += vmSample.getAccuracy() / (double)k;
            this.macroPrecision += vmSample.getMacroPrecision() / (double)k;
            this.macroRecall += vmSample.getMacroRecall() / (double)k;
            this.macroF1 += vmSample.getMacroF1() / (double)k;
        }
    }

    public String toString() {
        String sep = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(":").append(sep);
        sb.append("accuracy=").append(this.accuracy).append(sep);
        sb.append("macroPrecision=").append(this.macroPrecision).append(sep);
        sb.append("macroRecall=").append(this.macroRecall).append(sep);
        sb.append("macroF1=").append(this.macroF1).append(sep);
        sb.append("microPrecision=").append(this.microPrecision).append(sep);
        sb.append("microRecall=").append(this.microRecall).append(sep);
        sb.append("microF1=").append(this.microF1).append(sep);
        sb.append("contingencyTable=").append(this.contingencyTable).append(sep);
        return sb.toString();
    }

    public static enum SensitivityRates {
        TRUE_POSITIVE,
        TRUE_NEGATIVE,
        FALSE_POSITIVE,
        FALSE_NEGATIVE;

    }
}

