/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.dataobjects;

import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.DataframeMatrix;
import java.util.Map;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.AnyMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SparseRealMatrix;

public class MapRealMatrix
extends AbstractRealMatrix
implements SparseRealMatrix {
    private final int id;
    private final int rowDimension;
    private final int columnDimension;
    private final Map<Long, Double> entries;

    protected MapRealMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        super(rowDimension, columnDimension);
        this.rowDimension = rowDimension;
        this.columnDimension = columnDimension;
        if (DataframeMatrix.storageEngine == null) {
            throw new NullPointerException("The DataframeMatrix storage engine is not initialized.");
        }
        this.id = DataframeMatrix.storageId.getAndIncrement();
        this.entries = DataframeMatrix.storageEngine.getBigMap("tmp_mrmentries" + this.id, Long.class, Double.class, StorageEngine.MapType.HASHMAP, StorageEngine.StorageHint.IN_DISK, false, true);
    }

    protected void finalize() throws Throwable {
        try {
            DataframeMatrix.storageEngine.dropBigMap("tmp_mrmentries" + this.id, this.entries);
        }
        finally {
            super.finalize();
        }
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new MapRealMatrix(rowDimension, columnDimension);
    }

    public int getRowDimension() {
        return this.rowDimension;
    }

    public int getColumnDimension() {
        return this.columnDimension;
    }

    public RealMatrix copy() {
        MapRealMatrix copy = new MapRealMatrix(this.rowDimension, this.columnDimension);
        copy.entries.putAll(this.entries);
        return copy;
    }

    public double getEntry(int row, int column) throws OutOfRangeException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        return this.entries.getOrDefault(this.computeKey(row, column), 0.0);
    }

    public void setEntry(int row, int column, double value) throws OutOfRangeException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        if (value == 0.0) {
            this.entries.remove(this.computeKey(row, column));
        } else {
            this.entries.put(this.computeKey(row, column), value);
        }
    }

    private long computeKey(int row, int column) {
        return (long)row * (long)this.columnDimension + (long)column;
    }
}

