/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.concurrency;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

abstract class FixedBatchSpliteratorBase<T>
implements Spliterator<T> {
    private final int batchSize;
    private final int characteristics;
    private long est;

    public FixedBatchSpliteratorBase(int characteristics, int batchSize, long est) {
        this.characteristics = characteristics | 0x4000;
        this.batchSize = batchSize;
        this.est = est;
    }

    public FixedBatchSpliteratorBase(int characteristics, int batchSize) {
        this(characteristics, batchSize, Long.MAX_VALUE);
    }

    @Override
    public Spliterator<T> trySplit() {
        HoldingConsumer holder = new HoldingConsumer();
        if (!this.tryAdvance(holder)) {
            return null;
        }
        Object[] a = new Object[this.batchSize];
        int j = 0;
        do {
            a[j] = holder.value;
        } while (++j < this.batchSize && this.tryAdvance(holder));
        if (this.est != Long.MAX_VALUE) {
            this.est -= (long)j;
        }
        return Spliterators.spliterator(a, 0, j, this.characteristics() | 0x40);
    }

    @Override
    public Comparator<? super T> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    static final class HoldingConsumer<T>
    implements Consumer<T> {
        Object value;

        HoldingConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }
}

