/*
 * Decompiled with CFR 0.152.
 */
package jminhep.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.JPanel;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.gui.SetEnv;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.contour.DefaultContourDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class Plotter
extends JPanel {
    public static final long serialVersionUID = 11214L;
    private JFreeChart chart;
    private XYSeriesCollection dataset;
    private XYPlot xyplot;
    private ChartPanel chartPanel;
    private DefaultContourDataset dataset2D;
    public DataHolder Ndata;
    public int iiX;
    public int iiY;
    private double pwidth = 1.0;
    private double phight = 1.0;
    private ArrayList<XYLineAnnotation> Centers;
    private ArrayList<XYLineAnnotation> Seeds;
    public int MarkSize = 4;
    public Color MarkColor = Color.blue;
    public boolean MarkSelect = false;
    public Color MarkSelectColor = new Color(43690);

    public Plotter() {
        this.setLayout(new BorderLayout());
        this.dataset = new XYSeriesCollection();
        this.Centers = new ArrayList();
        this.Seeds = new ArrayList();
        this.chart = ChartFactory.createScatterPlot((String)"Empty", (String)"", (String)"", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        ChartUtilities.applyCurrentTheme((JFreeChart)this.chart);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setLayout((LayoutManager)new BorderLayout());
        this.add((Component)this.chartPanel);
        this.setVisible(true);
    }

    public void clearData() {
        if (this.dataset != null && this.dataset.getSeriesCount() > 0) {
            this.dataset.removeAllSeries();
        }
        if (this.dataset2D != null && this.dataset2D.getSeriesCount() > 0) {
            this.dataset2D = null;
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void clearPlot() {
        if (this.dataset != null && this.dataset.getSeriesCount() > 0) {
            this.dataset.removeAllSeries();
        }
        if (this.dataset2D != null && this.dataset2D.getSeriesCount() > 0) {
            this.dataset2D = null;
        }
        if (this.chart != null) {
            this.chart.setTitle("Not loaded");
            this.chart.setBackgroundPaint((Paint)Color.gray);
            this.xyplot = this.chart.getXYPlot();
            ValueAxis xx = this.xyplot.getDomainAxis();
            ValueAxis yy = this.xyplot.getRangeAxis();
            xx.setLabel("");
            yy.setLabel("");
        }
    }

    public void drawPoints() {
        this.clearData();
        XYSeries SerData = new XYSeries((Comparable)((Object)"Data"));
        for (int i = 0; i < SetEnv.NRow; ++i) {
            DataPoint dp = SetEnv.DATA.getRow(i);
            double x = dp.getAttribute(SetEnv.JboxX);
            double y = dp.getAttribute(SetEnv.JboxY);
            SerData.add(x, y);
        }
        try {
            this.dataset.addSeries(SerData);
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.chart = ChartFactory.createScatterPlot((String)SetEnv.Mtitle, (String)SetEnv.XYtitle[SetEnv.JboxX], (String)SetEnv.XYtitle[SetEnv.JboxY], (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.xyplot = this.chart.getXYPlot();
        this.xyplot.getRenderer().setSeriesPaint(0, (Paint)Color.black);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.chartPanel.setChart(this.chart);
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        this.pwidth = 10.0;
        this.phight = 20.0;
        ValueAxis xx = this.xyplot.getDomainAxis();
        ValueAxis yy = this.xyplot.getRangeAxis();
        this.pwidth = xx.getRange().getLength();
        this.phight = yy.getRange().getLength();
    }

    public void drawContour() {
        this.clearData();
        this.chart = null;
        int BinX = 30;
        int BinY = 30;
        Double[] Mi = new Double[SetEnv.Dim];
        Double[] Ma = new Double[SetEnv.Dim];
        for (int m = 0; m < SetEnv.Dim; ++m) {
            Mi[m] = SetEnv.Min.getAttribute(m);
            Ma[m] = SetEnv.Max.getAttribute(m);
        }
        double MinX = Mi[SetEnv.JboxX];
        double MinY = Mi[SetEnv.JboxY];
        double MaxX = Ma[SetEnv.JboxX];
        double MaxY = Ma[SetEnv.JboxY];
        double BinWidthX = (MaxX - MinX) / (double)BinX;
        double BinWidthY = (MaxY - MinY) / (double)BinY;
        int AllMax = BinX * BinY;
        Object[] xValues = new Double[AllMax];
        Object[] yValues = new Double[AllMax];
        Object[] zValues = new Double[AllMax];
        int nn = 0;
        for (int i = 0; i < BinX; ++i) {
            for (int j = 0; j < BinY; ++j) {
                double dX = MinX + BinWidthX * (double)i;
                double dY = MinY + BinWidthY * (double)j;
                xValues[nn] = dX + 0.5 * BinWidthX;
                yValues[nn] = dY + 0.5 * BinWidthY;
                int kk = 0;
                for (int m = 0; m < SetEnv.NRow; ++m) {
                    DataPoint dp = SetEnv.DATA.getRow(m);
                    double x = dp.getAttribute(SetEnv.JboxX);
                    double y = dp.getAttribute(SetEnv.JboxY);
                    if (!(x > dX) || !(x < dX + BinWidthX) || !(y > dY) || !(y < dY + BinWidthY)) continue;
                    ++kk;
                }
                zValues[nn] = (double)kk;
                ++nn;
            }
        }
        this.dataset2D = new DefaultContourDataset();
        this.dataset2D.initialize(xValues, yValues, zValues);
        ColorBar Cbar = new ColorBar("Density");
        NumberAxis dAxis = new NumberAxis(SetEnv.XYtitle[SetEnv.JboxX]);
        NumberAxis vAxis = new NumberAxis(SetEnv.XYtitle[SetEnv.JboxY]);
        dAxis.setLowerBound(MinX);
        dAxis.setUpperBound(MaxX);
        vAxis.setLowerBound(MinY);
        vAxis.setUpperBound(MaxY);
        ContourPlot xyzplot = new ContourPlot((ContourDataset)this.dataset2D, (ValueAxis)dAxis, (ValueAxis)vAxis, Cbar);
        xyzplot.setColorBarLocation(RectangleEdge.RIGHT);
        this.chart = new JFreeChart(SetEnv.Mtitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)xyzplot, false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.chartPanel.setChart(this.chart);
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
    }

    public void addSet(String name, DataHolder hold) {
        XYSeries SerData = new XYSeries((Comparable)((Object)name));
        for (int i = 0; i < hold.getSize(); ++i) {
            DataPoint dp = hold.getRow(i);
            double x = dp.getAttribute(SetEnv.JboxX);
            double y = dp.getAttribute(SetEnv.JboxY);
            SerData.add(x, y);
        }
        this.dataset.addSeries(SerData);
    }

    public void removeCenters() {
        this.xyplot = this.chart.getXYPlot();
        for (int i = 0; i < this.Centers.size(); ++i) {
            this.xyplot.removeAnnotation((XYAnnotation)this.Centers.get(i));
        }
        this.Centers.clear();
    }

    public void removeSeeds() {
        this.xyplot = this.chart.getXYPlot();
        for (int i = 0; i < this.Seeds.size(); ++i) {
            this.xyplot.removeAnnotation((XYAnnotation)this.Seeds.get(i));
        }
        this.Seeds.clear();
    }

    public void showCenters(String name, DataHolder hold) {
        this.xyplot = this.chart.getXYPlot();
        for (int i = 0; i < hold.getSize(); ++i) {
            DataPoint dp = hold.getRow(i);
            double x = dp.getAttribute(SetEnv.JboxX);
            double y = dp.getAttribute(SetEnv.JboxY);
            double r = 0.015 * this.pwidth;
            double rr = r * this.phight / this.pwidth;
            XYLineAnnotation a1 = new XYLineAnnotation(x - r, y, x + r, y, (Stroke)new BasicStroke(2.0f), (Paint)Color.red);
            XYLineAnnotation a2 = new XYLineAnnotation(x, y - rr, x, y + rr, (Stroke)new BasicStroke(2.0f), (Paint)Color.red);
            a1.setToolTipText(name + Integer.toString(i + 1));
            a2.setToolTipText(name + Integer.toString(i + 1));
            this.Centers.add(a1);
            this.Centers.add(a2);
            this.xyplot.addAnnotation((XYAnnotation)a1);
            this.xyplot.addAnnotation((XYAnnotation)a2);
        }
    }

    public void showSeeds(String name, DataHolder hold) {
        this.xyplot = this.chart.getXYPlot();
        for (int i = 0; i < hold.getSize(); ++i) {
            DataPoint dp = hold.getRow(i);
            double x = dp.getAttribute(SetEnv.JboxX);
            double y = dp.getAttribute(SetEnv.JboxY);
            double r = 0.015 * this.pwidth;
            double rr = r * this.phight / this.pwidth;
            XYLineAnnotation a1 = new XYLineAnnotation(x - r, y, x + r, y, (Stroke)new BasicStroke(2.0f), (Paint)Color.green);
            XYLineAnnotation a2 = new XYLineAnnotation(x, y - rr, x, y + rr, (Stroke)new BasicStroke(2.0f), (Paint)Color.green);
            a1.setToolTipText(name + Integer.toString(i + 1));
            a2.setToolTipText(name + Integer.toString(i + 1));
            this.Seeds.add(a1);
            this.Seeds.add(a2);
            this.xyplot.addAnnotation((XYAnnotation)a1);
            this.xyplot.addAnnotation((XYAnnotation)a2);
        }
    }

    public void showPlot() {
        this.chart = ChartFactory.createScatterPlot((String)SetEnv.Mtitle, (String)SetEnv.XYtitle[SetEnv.JboxX], (String)SetEnv.XYtitle[SetEnv.JboxY], (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.xyplot = this.chart.getXYPlot();
        XYItemRenderer renderer = this.xyplot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.black);
        renderer.setSeriesPaint(1, (Paint)Color.green);
        renderer.setSeriesPaint(2, (Paint)Color.blue);
        renderer.setSeriesPaint(3, (Paint)Color.magenta);
        renderer.setSeriesPaint(4, (Paint)Color.cyan);
        renderer.setSeriesPaint(5, (Paint)Color.pink);
        renderer.setSeriesPaint(6, (Paint)Color.orange);
        renderer.setSeriesPaint(7, (Paint)Color.darkGray);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.chartPanel.setChart(this.chart);
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
    }
}

