/*
 * Decompiled with CFR 0.152.
 */
package jminhep.clcontrol;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import javax.swing.table.AbstractTableModel;
import jminhep.clcontrol.MyTableModel;
import jminhep.clcontrol.TableOptions;
import jminhep.clcontrol.TableResults;
import jminhep.clcontrol.TableSettings;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.gui.SetEnv;
import jminhep.utils.VEC;

public class Global {
    public static String CPUtime;
    public static double Compactness;
    public static boolean doneAnalysis;
    public static TableResults jInfo;
    public static TableOptions jShowOption;
    public static TableSettings jSetting;
    public static String Description;
    public static String summary;
    public static MyTableModel model;
    public static MyTableModel model2;
    public static int Ncluster;
    public static int Niterations;
    public static double Fuzzines;
    public static double Eps;
    public static boolean ShowSeeds;
    public static boolean ShowCenters;
    public static double ShowProbab;
    public static double[][] mem;
    public static DataPoint MinData;
    public static DataPoint MaxData;
    public static int DimData;
    public static DataHolder Data;
    public static DataHolder CC;
    public static DataHolder SS;
    public static int SizeData;
    public static double PartitionCoefficient;
    public static int[] nPoints;

    public static void init() {
        Description = "summary is not filled yet";
        CPUtime = "";
        Compactness = 0.0;
        Fuzzines = 1.7;
        Niterations = 200;
        Ncluster = 3;
        Eps = 0.01;
        ShowSeeds = false;
        ShowCenters = false;
        PartitionCoefficient = 0.0;
        ShowProbab = 0.68;
        doneAnalysis = false;
        jShowOption = new TableOptions();
        jShowOption.setOpaque(true);
        Global.SetOptions();
        jSetting = new TableSettings();
        jSetting.setOpaque(true);
        jInfo = new TableResults();
        jInfo.setOpaque(true);
    }

    public static void SetOptions() {
        AbstractTableModel s = (AbstractTableModel)Global.jShowOption.table.getModel();
        s.setValueAt(new String("Show Centers"), 0, 0);
        s.setValueAt(new Boolean(ShowCenters), 0, 1);
        s.setValueAt(new String("Show Seeds"), 1, 0);
        s.setValueAt(new Boolean(ShowSeeds), 1, 1);
    }

    public static void GetOptions() {
        AbstractTableModel s = (AbstractTableModel)Global.jShowOption.table.getModel();
        Object s1 = s.getValueAt(0, 1);
        String h1 = s1.toString();
        ShowCenters = false;
        if (h1.equals("true")) {
            ShowCenters = true;
        }
        s1 = s.getValueAt(1, 1);
        h1 = s1.toString();
        ShowSeeds = false;
        if (h1.equals("true")) {
            ShowSeeds = true;
        }
    }

    public static void SetSettings(int N1, double N2, int N3, double N4) {
        Global.jSetting.table.setValueAt(new Integer(N1), 0, 1);
        Global.jSetting.table.setValueAt(new Double(N2), 1, 1);
        Global.jSetting.table.setValueAt(new Integer(N3), 2, 1);
        Global.jSetting.table.setValueAt(new Double(N4), 3, 1);
    }

    public static void GetSettings() {
        Object tmp1 = Global.jSetting.table.getValueAt(0, 1);
        Object tmp2 = Global.jSetting.table.getValueAt(1, 1);
        Object tmp3 = Global.jSetting.table.getValueAt(2, 1);
        Object tmp4 = Global.jSetting.table.getValueAt(3, 1);
        Object tmp5 = Global.jSetting.table.getValueAt(4, 1);
        String s1 = "1";
        String s2 = "1";
        String s3 = "1";
        String s4 = "1";
        String s5 = "0.68";
        if (tmp1 != null) {
            s1 = tmp1.toString();
        }
        if (tmp2 != null) {
            s2 = tmp2.toString();
        }
        if (tmp3 != null) {
            s3 = tmp3.toString();
        }
        if (tmp4 != null) {
            s4 = tmp4.toString();
        }
        if (tmp5 != null) {
            s5 = tmp5.toString();
        }
        try {
            Ncluster = Integer.parseInt(s1.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Fuzzines = Double.parseDouble(s2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Niterations = Integer.parseInt(s3.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Eps = Double.parseDouble(s4.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            ShowProbab = Double.parseDouble(s5.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Ncluster <= 0) {
            Ncluster = 2;
        }
        if (Fuzzines <= 1.0) {
            Fuzzines = 1.1;
        }
        if (Niterations <= 0) {
            Niterations = 1;
        }
        if (Eps <= 0.0) {
            Eps = 1.0E-7;
        }
        if (ShowProbab <= 0.0) {
            ShowProbab = 0.0;
        }
        if (ShowProbab >= 1.0) {
            ShowProbab = 1.0;
        }
    }

    public static void SetInfoTable() {
        DecimalFormat formatter = new DecimalFormat("0.000E00");
        if (Global.jInfo.model.getRowCount() > 0) {
            Global.jInfo.model.setRowCount(0);
        }
        Global.jInfo.model.addRow(new Object[]{new String("CPU"), new String(CPUtime)});
        Global.jInfo.model.addRow(new Object[]{new String("No of clusters"), new String(Integer.toString(Ncluster))});
        String ss = formatter.format(Compactness);
        Global.jInfo.model.addRow(new Object[]{new String("Compactness"), new String(ss)});
        ss = formatter.format(PartitionCoefficient);
        Global.jInfo.model.addRow(new Object[]{new String("Partition"), new String(ss)});
    }

    public static String Summary() {
        String ss;
        int i;
        String s;
        String valString;
        DataPoint dp;
        int j;
        String sum = Description;
        sum = sum + "\nCPU time=" + CPUtime;
        sum = sum + "\nData had dimension: " + SetEnv.Dim + "  with number of rows: " + SetEnv.NRow;
        sum = sum + "\nNumber of final clusters=" + Integer.toString(Ncluster);
        sum = sum + "\nCompactness=" + Double.toString(Compactness);
        sum = sum + "\n\nPositions of the centers:";
        DecimalFormat form1 = new DecimalFormat("0.000E00");
        NumberFormat FormInt = NumberFormat.getNumberInstance();
        FieldPosition fp = new FieldPosition(0);
        int d = 3;
        int w = 5;
        FormInt.setMaximumIntegerDigits(d);
        int dim = SetEnv.Dim;
        for (j = 0; j < CC.getSize(); ++j) {
            dp = CC.getRow(j);
            valString = FormInt.format(j, new StringBuffer(), fp).toString();
            s = VEC.getSpaces(w - fp.getEndIndex()) + valString + "  (";
            for (i = 0; i < dim; ++i) {
                ss = form1.format(dp.getAttribute(i));
                if (i < dim - 1) {
                    s = s + ss + ", ";
                }
                if (i != dim - 1) continue;
                s = s + ss;
            }
            s = s + ")";
            sum = sum + "\n" + s;
        }
        sum = sum + "\n\nCluster assignment:";
        for (j = 0; j < SetEnv.NRow; ++j) {
            dp = SetEnv.DATA.getRow(j);
            valString = FormInt.format(j, new StringBuffer(), fp).toString();
            s = "point  " + VEC.getSpaces(w - fp.getEndIndex()) + valString + "  (";
            for (i = 0; i < dim; ++i) {
                ss = form1.format(dp.getAttribute(i));
                if (i < dim - 1) {
                    s = s + ss + ", ";
                }
                if (i != dim - 1) continue;
                s = s + ss;
            }
            s = s + ")   for  " + dp.getClusterNumber();
            sum = sum + "\n" + s;
        }
        if (mem != null) {
            sum = sum + "\n\nFuzzy membership coefficients:";
            sum = sum + VEC.getMatrix(SetEnv.NRow, Ncluster, mem, 5, 5);
        }
        return sum;
    }

    static {
        doneAnalysis = false;
        mem = null;
    }
}

