/*
 * Decompiled with CFR 0.152.
 */
package QuasiBayesianNetworks;

import BayesianNetworks.BayesNet;
import BayesianNetworks.ConvertInterchangeFormat;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.VertexSet;
import InterchangeFormat.IFProbabilityEntry;
import InterchangeFormat.IFProbabilityFunction;
import InterchangeFormat.InterchangeFormat;
import java.util.Enumeration;
import java.util.Vector;

public class QBConvertInterchangeFormat
extends ConvertInterchangeFormat {
    public QBConvertInterchangeFormat(InterchangeFormat inter_format) {
        super(inter_format);
    }

    @Override
    protected ProbabilityFunction get_probability_function(BayesNet bn, IFProbabilityFunction upf) {
        int i;
        double[][] extreme_points = null;
        DiscreteVariable[] variables = this.create_variables(bn, upf);
        int jump = 1;
        for (i = 1; i < variables.length; ++i) {
            ProbabilityVariable pv = variables[i];
            jump *= pv.number_values();
        }
        int number_of_values = jump * variables[0].number_values();
        double[] values = new double[number_of_values];
        for (i = 0; i < values.length; ++i) {
            values[i] = -1.0;
        }
        extreme_points = this.process_extreme_tables(upf, values);
        this.process_defaults(upf, values, extreme_points, jump);
        this.process_entries(bn, upf, (ProbabilityVariable[])variables, values, extreme_points, jump);
        this.finish_values(values, extreme_points);
        if (extreme_points == null) {
            return new ProbabilityFunction(bn, variables, values, upf.get_properties());
        }
        return new VertexSet(bn, (ProbabilityVariable[])variables, extreme_points, upf.get_properties());
    }

    double[][] process_extreme_tables(IFProbabilityFunction upf, double[] values) {
        int i;
        Vector tables = upf.get_tables();
        int n = tables.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            double[] table = (double[])tables.firstElement();
            this.copy_table_to_values(table, values);
            return null;
        }
        double[][] extreme_points = new double[n][];
        for (i = 0; i < extreme_points.length; ++i) {
            extreme_points[i] = new double[values.length];
            for (int j = 0; j < extreme_points[i].length; ++j) {
                extreme_points[i][j] = -1.0;
            }
        }
        i = 0;
        Enumeration e = tables.elements();
        while (e.hasMoreElements()) {
            double[] table = (double[])e.nextElement();
            this.copy_table_to_values(table, extreme_points[i]);
            ++i;
        }
        return extreme_points;
    }

    void process_defaults(IFProbabilityFunction upf, double[] values, double[][] extreme_points, int jump) {
        Vector ddefaultss = upf.get_defaults();
        if (ddefaultss.size() > 0) {
            double[] ddefaults = (double[])ddefaultss.firstElement();
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < jump; ++j) {
                    int k = i * jump + j;
                    if (values[k] != -1.0) continue;
                    values[k] = ddefaults[i];
                }
            }
        }
    }

    void process_entries(BayesNet bn, IFProbabilityFunction upf, ProbabilityVariable[] variables, double[] values, double[][] extreme_points, int jump) {
        Vector eentries = upf.get_entries();
        if (eentries != null && eentries.size() > 0) {
            Enumeration e = eentries.elements();
            while (e.hasMoreElements()) {
                int k;
                ProbabilityVariable pv;
                int i;
                IFProbabilityEntry entry = (IFProbabilityEntry)e.nextElement();
                String[] eentry_values = entry.get_values();
                double[] eentry_entries = entry.get_entries();
                int[] entry_value_indexes = new int[eentry_values.length];
                for (i = 0; i < entry_value_indexes.length; ++i) {
                    pv = variables[i + 1];
                    entry_value_indexes[i] = pv.index_of_value(eentry_values[i]);
                }
                int pos = 0;
                int step = 1;
                for (k = entry_value_indexes.length; k > 0; --k) {
                    pos += entry_value_indexes[k - 1] * step;
                    step *= variables[k].number_values();
                }
                pv = variables[0];
                for (i = 0; i < pv.number_values(); ++i) {
                    k = i * jump + pos;
                    values[k] = eentry_entries[i];
                }
            }
        }
    }

    void finish_values(double[] values, double[][] extreme_points) {
        if (extreme_points != null) {
            for (int j = 0; j < extreme_points.length; ++j) {
                for (int i = 0; i < extreme_points[j].length; ++i) {
                    if (extreme_points[j][i] != -1.0) continue;
                    extreme_points[j][i] = 0.0;
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != -1.0) continue;
                values[i] = 0.0;
            }
        }
    }
}

