/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;

class PropertyManager {
    private Vector original_properties;
    private Vector modified_properties;
    private boolean are_original_properties_still_valid;
    private int displayed_property_index;
    private TextField text_field;

    PropertyManager(Vector op, TextField tf) {
        this.original_properties = op;
        this.text_field = tf;
        this.modified_properties = new Vector();
        if (op != null) {
            Enumeration e = op.elements();
            while (e.hasMoreElements()) {
                this.modified_properties.addElement(e.nextElement());
            }
        }
        this.are_original_properties_still_valid = true;
        if (this.modified_properties.size() > 0) {
            String property = (String)this.modified_properties.firstElement();
            this.text_field.setText(property);
            this.displayed_property_index = 0;
        } else {
            this.displayed_property_index = -1;
        }
    }

    void new_property() {
        String property = this.displayed_property_index != -1 ? (String)this.modified_properties.elementAt(this.displayed_property_index) : "";
        if (!property.equals(this.text_field.getText())) {
            this.update_property();
        }
        this.displayed_property_index = -1;
        this.text_field.setText("");
    }

    void next_property() {
        String property = this.displayed_property_index != -1 ? (String)this.modified_properties.elementAt(this.displayed_property_index) : "";
        if (!property.equals(this.text_field.getText())) {
            this.update_property();
        }
        if (this.modified_properties.size() > 0) {
            ++this.displayed_property_index;
            if (this.displayed_property_index >= this.modified_properties.size()) {
                this.displayed_property_index = 0;
            }
            property = (String)this.modified_properties.elementAt(this.displayed_property_index);
            this.text_field.setText(property);
        }
    }

    void update_property() {
        if (this.displayed_property_index != -1) {
            this.modified_properties.removeElementAt(this.displayed_property_index);
        }
        if (this.text_field.getText().equals("")) {
            this.displayed_property_index = -1;
        } else {
            this.modified_properties.addElement(this.text_field.getText());
            this.displayed_property_index = this.modified_properties.indexOf(this.text_field.getText());
        }
        this.are_original_properties_still_valid = false;
    }

    Vector update_property_on_exit() {
        String property = this.displayed_property_index != -1 ? (String)this.modified_properties.elementAt(this.displayed_property_index) : "";
        if (!property.equals(this.text_field.getText())) {
            this.update_property();
        }
        if (!this.are_original_properties_still_valid) {
            return this.modified_properties;
        }
        return null;
    }
}

