/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import InferenceGraphs.InferenceGraphNode;
import JavaBayesInterface.EditFunctionDialog;
import JavaBayesInterface.EditNetworkDialog;
import JavaBayesInterface.EditVariableDialog;
import JavaBayesInterface.EditorFrame;
import JavaBayesInterface.JavaBayesHelpMessages;
import JavaBayesInterface.ObserveDialog;
import JavaBayesInterface.ScrollingPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class NetworkPanel
extends Canvas {
    private EditorFrame frame;
    private ScrollingPanel scrollPanel;
    private int mode;
    private InferenceGraph ig;
    private Point group_start;
    private Point group_end;
    boolean new_arc = false;
    Point new_arc_head = null;
    boolean modify_group = false;
    InferenceGraphNode movenode = null;
    Vector moving_nodes = null;
    InferenceGraphNode arcbottomnode = null;
    InferenceGraphNode archeadnode = null;
    int x_scroll;
    int y_scroll;
    private static final int NODE_SIZE = 26;
    private static final int NODE_RADIUS = 13;
    private static final int SPACE_DRAW_NODE_NAME = 24;
    private static final double ARROW_SIZE = 6.0;
    private static final double ARROW_HALF_SIZE = 3.0;
    private static final double DISTANCE_HIT_ARC = 200.0;
    private static final Color nodeColor = Color.green;
    private static final Color observedNodeColor = Color.blue;
    private static final Color explanationNodeColor = Color.orange;
    private static final Color nodeBorderColor = Color.black;
    private static final Color nodenameColor = Color.black;
    private static final Color arcColor = Color.gray;
    private static final Color backgroundColor = Color.white;
    private static final int CREATE_MODE = 1;
    private static final int MOVE_MODE = 2;
    private static final int DELETE_MODE = 3;
    private static final int OBSERVE_MODE = 4;
    private static final int QUERY_MODE = 5;
    private static final int EDIT_VARIABLE_MODE = 6;
    private static final int EDIT_FUNCTION_MODE = 7;
    private static final int EDIT_NETWORK_MODE = 8;
    private Font roman = new Font("TimesRoman", 1, 12);
    private Font helvetica = new Font("Helvetica", 1, 15);
    private FontMetrics fmetrics = this.getFontMetrics(this.roman);
    private int h = this.fmetrics.getHeight() / 3;
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private Dimension offScreenSize;

    NetworkPanel(EditorFrame frame, ScrollingPanel scroll) {
        this.frame = frame;
        this.scrollPanel = scroll;
        this.ig = new InferenceGraph();
        this.group_start = new Point(0, 0);
        this.group_end = new Point(0, 0);
        this.mode = 2;
        frame.setCursor(13);
        this.setBackground(backgroundColor);
    }

    @Override
    public boolean mouseDown(Event evt, int x, int y) {
        InferenceGraphNode node = this.nodehit(x += this.x_scroll, y += this.y_scroll);
        if (node == null) {
            if (this.mode == 3 && this.archit(x, y)) {
                this.delete_arc();
                this.archeadnode = null;
                this.arcbottomnode = null;
            } else if (this.mode == 1) {
                this.create_node(x, y);
            } else {
                this.group_start.move(x, y);
                this.group_end.move(x, y);
                this.modify_group = true;
            }
        } else if (this.mode == 4) {
            this.observe(node);
        } else if (this.mode == 5) {
            this.frame.process_query(this.ig, node.get_name());
        } else if (this.mode == 2) {
            this.movenode = node;
            this.generate_moving_nodes();
        } else if (this.mode == 3) {
            this.delete_node(node);
        } else if (this.mode == 1) {
            this.new_arc = true;
            this.arcbottomnode = node;
            this.new_arc_head = new Point(x, y);
        } else if (this.mode == 6) {
            this.edit_variable(node);
        } else if (this.mode == 7) {
            this.edit_function(node);
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseDrag(Event evt, int x, int y) {
        x += this.x_scroll;
        y += this.y_scroll;
        if (this.movenode != null) {
            this.move_node(x, y);
        } else if (this.new_arc) {
            this.new_arc_head = new Point(x, y);
        } else if (this.modify_group) {
            this.group_end.move(x, y);
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseUp(Event evt, int x, int y) {
        x += this.x_scroll;
        y += this.y_scroll;
        if (this.movenode != null) {
            this.ig.set_pos(this.movenode, new Point(x, y));
            this.movenode = null;
        } else if (this.new_arc) {
            this.archeadnode = this.nodehit(x, y);
            if (this.archeadnode != null && this.arcbottomnode != null) {
                if (this.archeadnode == this.arcbottomnode) {
                    JavaBayesHelpMessages.show(JavaBayesHelpMessages.selfarc);
                } else if (this.ig.hasCycle(this.arcbottomnode, this.archeadnode)) {
                    JavaBayesHelpMessages.show(JavaBayesHelpMessages.circular);
                } else {
                    this.create_arc();
                }
            }
            this.archeadnode = null;
            this.arcbottomnode = null;
            this.new_arc_head = null;
            this.new_arc = false;
        } else if (this.modify_group) {
            this.modify_group = false;
        }
        this.repaint();
        return true;
    }

    private InferenceGraphNode nodehit(int x, int y) {
        Enumeration e = this.ig.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode node = (InferenceGraphNode)e.nextElement();
            if ((x - node.get_pos_x()) * (x - node.get_pos_x()) + (y - node.get_pos_y()) * (y - node.get_pos_y()) >= 169) continue;
            return node;
        }
        return null;
    }

    boolean archit(int x, int y) {
        Enumeration e = this.ig.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode hnode = (InferenceGraphNode)e.nextElement();
            Enumeration ee = hnode.get_parents().elements();
            while (ee.hasMoreElements()) {
                InferenceGraphNode pnode = (InferenceGraphNode)ee.nextElement();
                double sdpa = this.square_distance_point_arc(hnode, pnode, x, y);
                if (!(sdpa >= 0.0) || !(sdpa <= 200.0)) continue;
                this.archeadnode = hnode;
                this.arcbottomnode = pnode;
            }
        }
        return this.archeadnode != null && this.arcbottomnode != null;
    }

    double square_distance_point_arc(InferenceGraphNode hnode, InferenceGraphNode pnode, int x3, int y3) {
        double area;
        double square_height;
        int y2;
        int x1 = hnode.get_pos_x();
        int y1 = hnode.get_pos_y();
        int x2 = pnode.get_pos_x();
        double square_base = (x2 - x1) * (x2 - x1) + ((y2 = pnode.get_pos_y()) - y1) * (y2 - y1);
        double square_hyp = square_base + (square_height = 4.0 * ((area = 0.5 * (double)(x1 * y2 + y1 * x3 + x2 * y3 - x3 * y2 - y3 * x1 - x2 * y1)) * area) / square_base);
        if (square_hyp < (double)((x3 - x1) * (x3 - x1) + (y3 - y1) * (y3 - y1))) {
            return -1.0;
        }
        if (square_hyp < (double)((x3 - x2) * (x3 - x2) + (y3 - y2) * (y3 - y2))) {
            return -1.0;
        }
        return square_height;
    }

    @Override
    public void update(Graphics g) {
        Dimension d = this.size();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            MediaTracker tracker = new MediaTracker(this);
            try {
                tracker.addImage(this.offScreenImage, 0);
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.offScreenGraphics.setColor(backgroundColor);
        this.offScreenGraphics.fillRect(0, 0, d.width, d.height);
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    @Override
    public void paint(Graphics g) {
        int group_height;
        int group_y;
        int group_width;
        int group_x;
        InferenceGraphNode node;
        int explanation_status = this.frame.get_mode();
        if (this.ig == null) {
            return;
        }
        g.setColor(arcColor);
        if (this.new_arc) {
            g.drawLine(this.arcbottomnode.get_pos_x() - this.x_scroll, this.arcbottomnode.get_pos_y() - this.y_scroll, this.new_arc_head.x - this.x_scroll, this.new_arc_head.y - this.y_scroll);
        }
        Enumeration e = this.ig.elements();
        while (e.hasMoreElements()) {
            node = (InferenceGraphNode)e.nextElement();
            Enumeration ee = node.get_parents().elements();
            while (ee.hasMoreElements()) {
                InferenceGraphNode parent = (InferenceGraphNode)ee.nextElement();
                this.draw_arc(g, node, parent);
            }
        }
        g.setFont(this.helvetica);
        e = this.ig.elements();
        while (e.hasMoreElements()) {
            node = (InferenceGraphNode)e.nextElement();
            g.setColor(nodeBorderColor);
            if (node.get_pos_x() - this.x_scroll >= 0) {
                g.fillOval(node.get_pos_x() - this.x_scroll - 13 - 1, node.get_pos_y() - this.y_scroll - 13 - 1, 28, 28);
            }
            switch (explanation_status) {
                case 4: {
                    g.setColor(explanationNodeColor);
                    break;
                }
                case 3: {
                    if (node.is_explanation()) {
                        g.setColor(explanationNodeColor);
                        break;
                    }
                    g.setColor(nodeColor);
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    g.setColor(nodeColor);
                }
            }
            if (node.is_observed()) {
                g.setColor(observedNodeColor);
            }
            if (node.get_pos_x() - this.x_scroll >= 0) {
                g.fillOval(node.get_pos_x() - this.x_scroll - 13, node.get_pos_y() - this.y_scroll - 13, 26, 26);
            }
            g.setColor(nodenameColor);
            g.drawString(node.get_name(), node.get_pos_x() - this.x_scroll - 24, node.get_pos_y() - this.y_scroll + 24);
        }
        g.setXORMode(backgroundColor);
        if (this.group_start.x < this.group_end.x) {
            group_x = this.group_start.x;
            group_width = this.group_end.x - this.group_start.x;
        } else {
            group_x = this.group_end.x;
            group_width = this.group_start.x - this.group_end.x;
        }
        if (this.group_start.y < this.group_end.y) {
            group_y = this.group_start.y;
            group_height = this.group_end.y - this.group_start.y;
        } else {
            group_y = this.group_end.y;
            group_height = this.group_start.y - this.group_end.y;
        }
        g.drawRect(group_x - this.x_scroll, group_y - this.y_scroll, group_width, group_height);
        g.setPaintMode();
        this.scrollPanel.setScrollbars(this.size());
    }

    private void draw_arc(Graphics g, InferenceGraphNode node, InferenceGraphNode parent) {
        int node_x = node.get_pos_x() - this.x_scroll;
        int node_y = node.get_pos_y() - this.y_scroll;
        int parent_x = parent.get_pos_x() - this.x_scroll;
        int parent_y = parent.get_pos_y() - this.y_scroll;
        double dir_x = node_x - parent_x;
        double dir_y = node_y - parent_y;
        double distance = Math.sqrt(dir_x * dir_x + dir_y * dir_y);
        double head_x = (double)node_x - 19.0 * (dir_x /= distance);
        double head_y = (double)node_y - 19.0 * (dir_y /= distance);
        double bottom_x = (double)parent_x + 13.0 * dir_x;
        double bottom_y = (double)parent_y + 13.0 * dir_y;
        int x1 = (int)(head_x - 3.0 * dir_x + 6.0 * dir_y);
        int x2 = (int)(head_x - 3.0 * dir_x - 6.0 * dir_y);
        int x3 = (int)(head_x + 6.0 * dir_x);
        int y1 = (int)(head_y - 3.0 * dir_y - 6.0 * dir_x);
        int y2 = (int)(head_y - 3.0 * dir_y + 6.0 * dir_x);
        int y3 = (int)(head_y + 6.0 * dir_y);
        int[] archead_x = new int[]{x1, x2, x3, x1};
        int[] archead_y = new int[]{y1, y2, y3, y1};
        g.drawLine((int)bottom_x, (int)bottom_y, (int)head_x, (int)head_y);
        g.fillPolygon(archead_x, archead_y, 4);
    }

    void set_mode(String label) {
        this.mode = label.equals("Create") ? 1 : (label.equals("Move") ? 2 : (label.equals("Delete") ? 3 : (label.equals("Query") ? 5 : (label.equals("Observe") ? 4 : (label.equals("Edit Variable") ? 6 : (label.equals("Edit Function") ? 7 : 1))))));
    }

    InferenceGraph get_inference_graph() {
        return this.ig;
    }

    void load(InferenceGraph inference_graph) {
        this.ig = inference_graph;
        this.repaint();
    }

    void clear() {
        this.ig = new InferenceGraph();
        this.repaint();
    }

    void observe(InferenceGraphNode node) {
        this.ig.reset_marginal();
        ObserveDialog d = new ObserveDialog(this, this.frame, this.ig, node);
        d.show();
    }

    void create_node(int x, int y) {
        this.ig.create_node(x, y);
        this.ig.reset_marginal();
    }

    void create_arc() {
        boolean flag_created = this.ig.create_arc(this.arcbottomnode, this.archeadnode);
        if (flag_created) {
            this.ig.reset_marginal();
        }
    }

    void generate_moving_nodes() {
        if (!this.inside_group(this.movenode)) {
            this.moving_nodes = null;
            return;
        }
        this.moving_nodes = new Vector();
        Enumeration e = this.ig.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode node = (InferenceGraphNode)e.nextElement();
            if (!this.inside_group(node)) continue;
            this.moving_nodes.addElement(node);
        }
    }

    void move_node(int x, int y) {
        int delta_x = this.movenode.get_pos_x() - x;
        int delta_y = this.movenode.get_pos_y() - y;
        if (this.moving_nodes == null) {
            this.ig.set_pos(this.movenode, new Point(x, y));
        } else {
            this.group_start.x -= delta_x;
            this.group_end.x -= delta_x;
            this.group_start.y -= delta_y;
            this.group_end.y -= delta_y;
            Enumeration e = this.moving_nodes.elements();
            while (e.hasMoreElements()) {
                InferenceGraphNode node = (InferenceGraphNode)e.nextElement();
                this.ig.set_pos(node, new Point(node.get_pos_x() - delta_x, node.get_pos_y() - delta_y));
            }
        }
    }

    void delete_node(InferenceGraphNode node) {
        if (!this.inside_group(node)) {
            this.ig.delete_node(node);
        } else {
            InferenceGraphNode dnode;
            Vector<InferenceGraphNode> nodes_to_delete = new Vector<InferenceGraphNode>();
            Enumeration e = this.ig.elements();
            while (e.hasMoreElements()) {
                dnode = (InferenceGraphNode)e.nextElement();
                if (!this.inside_group(dnode)) continue;
                nodes_to_delete.addElement(dnode);
            }
            e = nodes_to_delete.elements();
            while (e.hasMoreElements()) {
                dnode = (InferenceGraphNode)e.nextElement();
                this.ig.delete_node(dnode);
            }
        }
        this.ig.reset_marginal();
    }

    boolean inside_group(InferenceGraphNode node) {
        return node.get_pos_x() > Math.min(this.group_start.x, this.group_end.x) && node.get_pos_x() < Math.max(this.group_start.x, this.group_end.x) && node.get_pos_y() > Math.min(this.group_start.y, this.group_end.y) && node.get_pos_y() < Math.max(this.group_start.y, this.group_end.y);
    }

    void delete_arc() {
        this.ig.delete_arc(this.arcbottomnode, this.archeadnode);
        this.ig.reset_marginal();
    }

    void edit_variable(InferenceGraphNode node) {
        this.ig.reset_marginal();
        EditVariableDialog d = new EditVariableDialog(this, this.frame, this.ig, node);
        ((Dialog)d).show();
    }

    void edit_function(InferenceGraphNode node) {
        this.ig.reset_marginal();
        EditFunctionDialog d = new EditFunctionDialog((Frame)this.frame, this.ig, node);
        ((Dialog)d).show();
    }

    void edit_network() {
        this.ig.reset_marginal();
        EditNetworkDialog d = new EditNetworkDialog((Frame)this.frame, this.ig);
        ((Dialog)d).show();
    }
}

