/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import InferenceGraphs.InferenceGraphNode;
import JavaBayesInterface.NetworkPanel;
import JavaBayesInterface.PropertyManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class EditVariableDialog
extends Dialog {
    NetworkPanel npan;
    InferenceGraph ig;
    InferenceGraphNode node;
    int number_extreme_points;
    PropertyManager variable_property_manager;
    PropertyManager function_property_manager;
    int displayed_variable_property_index;
    int displayed_function_property_index;
    Panel np;
    Panel nvp;
    Panel tp;
    Panel ttp;
    Panel vpp;
    Panel fpp;
    Panel npp;
    Panel cbp;
    Panel pp;
    Panel gnp;
    Panel gncp;
    Panel okp;
    Panel qbp;
    Panel qbpp;
    Label name;
    Label new_value;
    Label type;
    Label variable_properties;
    Label function_properties;
    Label local_parameter;
    TextField text_name;
    TextField text_new_value;
    TextField text_local_parameter;
    CheckboxGroup types;
    CheckboxGroup function_types;
    Checkbox chance_type;
    Checkbox explanation_type;
    Checkbox no_local_credal_set_type;
    Checkbox local_credal_set_type;
    Button new_variable_property;
    Button next_variable_property;
    Button new_function_property;
    Button next_function_property;
    TextField variable_properties_text;
    TextField function_properties_text;
    Button dist_button;
    Button ok_button;
    Button dismiss_button;
    private static final int TOP_INSET = 5;
    private static final int LEFT_INSET = 10;
    private static final int RIGHT_INSET = 10;
    private static final int BOTTOM_INSET = 0;
    private static final String name_label = "Name:";
    private static final String new_value_label = "Values:";
    private static final String type_label = "Types:";
    private static final String chance_type_label = "Chance node";
    private static final String explanation_type_label = "Explanatory node";
    private static final String no_local_credal_set_label = "Single distribution";
    private static final String local_credal_set_label = "Credal set with extreme points";
    private static final String variable_properties_label = "Variable properties:";
    private static final String function_properties_label = "Function properties:";
    private static final String next_property_label = "Next";
    private static final String new_property_label = "New";
    private static final String edit_function_label = "Edit function";
    private static final String ok_label = "Apply";
    private static final String dismiss_label = "Dismiss";

    public EditVariableDialog(NetworkPanel network_panel, Frame parent, InferenceGraph i_g, InferenceGraphNode node) {
        super(parent, "Edit: " + node.get_name(), true);
        this.npan = network_panel;
        this.ig = i_g;
        this.node = node;
        this.np = new Panel();
        this.np.setLayout(new BorderLayout());
        this.name = new Label(name_label);
        this.text_name = new TextField(30);
        this.np.add("West", this.name);
        this.np.add("Center", this.text_name);
        this.nvp = new Panel();
        this.nvp.setLayout(new BorderLayout());
        this.new_value = new Label(new_value_label);
        this.text_new_value = new TextField(60);
        this.nvp.add("West", this.new_value);
        this.nvp.add("Center", this.text_new_value);
        this.tp = new Panel();
        this.tp.setLayout(new BorderLayout());
        this.type = new Label(type_label);
        this.ttp = new Panel();
        this.ttp.setLayout(new GridLayout(2, 1));
        this.types = new CheckboxGroup();
        this.chance_type = new Checkbox(chance_type_label, this.types, true);
        this.explanation_type = new Checkbox(explanation_type_label, this.types, false);
        this.ttp.add(this.chance_type);
        this.ttp.add(this.explanation_type);
        this.qbp = new Panel();
        this.qbp.setLayout(new GridLayout(2, 1));
        this.function_types = new CheckboxGroup();
        this.no_local_credal_set_type = new Checkbox(no_local_credal_set_label, this.function_types, true);
        this.local_credal_set_type = new Checkbox(local_credal_set_label, this.function_types, false);
        this.qbp.add(this.no_local_credal_set_type);
        this.qbp.add(this.local_credal_set_type);
        this.tp.add("North", this.type);
        this.tp.add("West", this.ttp);
        this.tp.add("East", this.qbp);
        this.cbp = new Panel();
        this.cbp.setLayout(new BorderLayout(10, 10));
        this.cbp.add("North", this.np);
        this.cbp.add("Center", this.nvp);
        this.cbp.add("South", this.tp);
        this.pp = new Panel();
        this.pp.setLayout(new BorderLayout());
        this.vpp = new Panel();
        this.vpp.setLayout(new BorderLayout());
        this.variable_properties = new Label(variable_properties_label);
        this.next_variable_property = new Button(next_property_label);
        this.new_variable_property = new Button(new_property_label);
        this.variable_properties_text = new TextField(40);
        this.vpp.add("North", this.variable_properties);
        this.vpp.add("West", this.next_variable_property);
        this.vpp.add("Center", this.variable_properties_text);
        this.vpp.add("East", this.new_variable_property);
        this.fpp = new Panel();
        this.fpp.setLayout(new BorderLayout());
        this.function_properties = new Label(function_properties_label);
        this.next_function_property = new Button(next_property_label);
        this.new_function_property = new Button(new_property_label);
        this.function_properties_text = new TextField(40);
        this.fpp.add("North", this.function_properties);
        this.fpp.add("West", this.next_function_property);
        this.fpp.add("Center", this.function_properties_text);
        this.fpp.add("East", this.new_function_property);
        this.pp.add("North", this.vpp);
        this.pp.add("Center", this.fpp);
        this.okp = new Panel();
        this.okp.setLayout(new FlowLayout(1));
        this.dist_button = new Button(edit_function_label);
        this.okp.add(this.dist_button);
        this.ok_button = new Button(ok_label);
        this.dismiss_button = new Button(dismiss_label);
        this.okp.add(this.ok_button);
        this.okp.add(this.dismiss_button);
        this.setLayout(new BorderLayout());
        this.add("North", this.cbp);
        this.add("Center", this.pp);
        this.add("South", this.okp);
        this.pack();
        this.fill_dialog();
    }

    @Override
    public void show() {
        Rectangle bounds = this.getParent().bounds();
        Rectangle abounds = this.bounds();
        this.move(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        super.show();
    }

    @Override
    public Insets insets() {
        Insets ins = super.insets();
        return new Insets(ins.top + 5, ins.left + 10, ins.bottom + 0, ins.right + 10);
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            this.dispose();
        }
        return super.handleEvent(evt);
    }

    private void fill_dialog() {
        String all_values = "";
        this.ig.get_bayes_net();
        this.text_name.setText(this.node.get_name());
        String[] values = this.node.get_values();
        for (int i = 0; i < values.length; ++i) {
            all_values = all_values + values[i];
            if (i == values.length - 1) continue;
            all_values = all_values + ", ";
        }
        this.text_new_value.setText(all_values);
        if (this.node.is_explanation()) {
            this.types.setCurrent(this.explanation_type);
        } else {
            this.types.setCurrent(this.chance_type);
        }
        if (this.node.is_credal_set()) {
            this.function_types.setCurrent(this.local_credal_set_type);
        } else {
            this.function_types.setCurrent(this.no_local_credal_set_type);
        }
        this.variable_property_manager = new PropertyManager(this.node.get_variable_properties(), this.variable_properties_text);
        this.function_property_manager = new PropertyManager(this.node.get_function_properties(), this.function_properties_text);
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target == this.dismiss_button) {
            this.dispose();
        } else if (evt.target == this.ok_button) {
            this.update_dialog();
        } else if (evt.target == this.new_variable_property) {
            this.variable_property_manager.new_property();
        } else if (evt.target == this.next_variable_property) {
            this.variable_property_manager.next_property();
        } else if (evt.target == this.new_function_property) {
            this.function_property_manager.new_property();
        } else if (evt.target == this.next_function_property) {
            this.function_property_manager.next_property();
        } else if (evt.target == this.variable_properties_text) {
            this.variable_property_manager.update_property();
        } else if (evt.target == this.function_properties_text) {
            this.function_property_manager.update_property();
        } else if (evt.target == this.dist_button) {
            this.npan.edit_function(this.node);
        } else {
            return super.action(evt, arg);
        }
        return true;
    }

    private String[] parse_values(String all_values) {
        Object token = null;
        String delimiters = " ,\n\t\r";
        StringTokenizer st = new StringTokenizer(all_values, delimiters);
        String[] vals = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            vals[i] = this.ig.validate_value(st.nextToken());
            ++i;
        }
        return vals;
    }

    private void update_dialog() {
        Vector fprop;
        String[] values;
        String checked_name = this.ig.check_name(this.text_name.getText());
        if (checked_name != null) {
            this.node.set_name(checked_name);
        }
        if ((values = this.parse_values(this.text_new_value.getText())) != null) {
            this.ig.change_values(this.node, values);
        }
        if (this.types.getSelectedCheckbox() == this.chance_type) {
            this.node.set_explanation(false);
        } else {
            this.node.set_explanation(true);
        }
        this.npan.repaint();
        if (this.function_types.getSelectedCheckbox() == this.no_local_credal_set_type) {
            this.node.set_no_local_credal_set();
        } else {
            this.node.set_local_credal_set();
        }
        Vector vprop = this.variable_property_manager.update_property_on_exit();
        if (vprop != null) {
            this.node.set_variable_properties(vprop);
            Enumeration e = vprop.elements();
            while (e.hasMoreElements()) {
                this.node.update_position_from_property((String)e.nextElement());
            }
        }
        if ((fprop = this.function_property_manager.update_property_on_exit()) != null) {
            this.node.set_function_properties(fprop);
        }
    }
}

