/*
 * Decompiled with CFR 0.152.
 */
package InferenceGraphs;

import BayesianInferences.Explanation;
import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import InferenceGraphs.InferenceGraphNode;
import InterchangeFormat.IFException;
import QuasiBayesianInferences.QBExpectation;
import QuasiBayesianInferences.QBInference;
import QuasiBayesianNetworks.QuasiBayesNet;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InferenceGraph {
    QuasiBayesNet qbn;
    QBInference qbi;
    QBExpectation qbe;
    Vector nodes = new Vector();
    private final String defaultBayesNetName = "InternalNetwork";
    public static final int MARGINAL_POSTERIOR = 1;
    public static final int EXPECTATION = 2;
    public static final int EXPLANATION = 3;
    public static final int FULL_EXPLANATION = 4;
    public static final int SENSITIVITY_ANALYSIS = 5;
    public static final int NO_CREDAL_SET = 0;
    public static final int CONSTANT_DENSITY_RATIO = 2;
    public static final int EPSILON_CONTAMINATED = 3;
    public static final int CONSTANT_DENSITY_BOUNDED = 4;
    public static final int TOTAL_VARIATION = 5;

    public InferenceGraph() {
        this.qbn = new QuasiBayesNet("InternalNetwork", 0, 0);
    }

    public InferenceGraph(BayesNet b_n) {
        this.qbn = new QuasiBayesNet(b_n);
        this.convert_bayes_net();
    }

    public InferenceGraph(String filename) throws IOException, IFException {
        this.qbn = new QuasiBayesNet(new DataInputStream(new FileInputStream(filename)));
        this.convert_bayes_net();
    }

    public InferenceGraph(URL url) throws IOException, IFException {
        this.qbn = new QuasiBayesNet(url);
        this.convert_bayes_net();
    }

    public QuasiBayesNet get_bayes_net() {
        return this.convert_graph();
    }

    boolean convert_bayes_net() {
        ProbabilityVariable pv = null;
        ProbabilityFunction pf = null;
        for (int i = 0; i < this.qbn.number_variables(); ++i) {
            pv = this.qbn.get_probability_variable(i);
            pf = null;
            for (int j = 0; j < this.qbn.number_probability_functions() && (pf = this.qbn.get_probability_function(j)).get_variable(0) != pv; ++j) {
            }
            if (pf == null) {
                return false;
            }
            this.nodes.addElement(new InferenceGraphNode(this, pv, pf));
        }
        this.generate_parents_and_children();
        return true;
    }

    private void generate_parents_and_children() {
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode base_node = (InferenceGraphNode)e.nextElement();
            ProbabilityFunction pf = base_node.pf;
            DiscreteVariable[] variables = pf.get_variables();
            for (int i = 1; i < variables.length; ++i) {
                InferenceGraphNode node = this.get_node(variables[i]);
                if (node == null) continue;
                base_node.parents.addElement(node);
                node.children.addElement(base_node);
            }
        }
    }

    private InferenceGraphNode get_node(DiscreteVariable dv) {
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode node = (InferenceGraphNode)e.nextElement();
            if (node.pv != dv) continue;
            return node;
        }
        return null;
    }

    QuasiBayesNet convert_graph() {
        ProbabilityVariable[] pvs = new ProbabilityVariable[this.nodes.size()];
        ProbabilityFunction[] pfs = new ProbabilityFunction[this.nodes.size()];
        this.qbn.set_probability_variables(pvs);
        this.qbn.set_probability_functions(pfs);
        int i = 0;
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode node = (InferenceGraphNode)e.nextElement();
            node.update_position();
            this.qbn.set_probability_variable(i, node.pv);
            this.qbn.set_probability_function(i, node.pf);
            ++i;
        }
        return this.qbn;
    }

    private String generate_name(int i) {
        char namec = (char)(97 + i % 26);
        int suffix = i / 26;
        String name = suffix > 0 ? new String("" + namec + suffix) : new String("" + namec);
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode no = (InferenceGraphNode)e.nextElement();
            if (!no.get_name().equals(name)) continue;
            return this.generate_name(i + 1);
        }
        return name;
    }

    public String get_name() {
        return this.qbn.get_name();
    }

    public void set_name(String n) {
        this.qbn.set_name(n);
    }

    public Vector get_network_properties() {
        return this.qbn.get_properties();
    }

    public void set_network_properties(Vector prop) {
        this.qbn.set_properties(prop);
    }

    public int get_global_neighborhood_type() {
        return this.qbn.get_global_neighborhood_type();
    }

    public void set_global_neighborhood(int type) {
        this.qbn.set_global_neighborhood_type(type);
    }

    public double get_global_neighborhood_parameter() {
        return this.qbn.get_global_neighborhood_parameter();
    }

    public void set_global_neighborhood_parameter(double parameter) {
        this.qbn.set_global_neighborhood_parameter(parameter);
    }

    public void remove_network_property(int index) {
        this.qbn.remove_property(index);
    }

    public void add_network_property(String prop) {
        this.qbn.add_property(prop);
    }

    public String check_name(String n) {
        String nn = this.validate_value(n);
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode no = (InferenceGraphNode)e.nextElement();
            if (!no.get_name().equals(nn)) continue;
            return null;
        }
        return nn;
    }

    public String validate_value(String value) {
        StringBuffer str = new StringBuffer(value);
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            str.setCharAt(i, '_');
        }
        return str.toString();
    }

    public void print_bayes_net(PrintStream out) {
        QuasiBayesNet qb_n = this.get_bayes_net();
        qb_n.print(out);
    }

    public void print_marginal(PrintStream pstream, String queried_variable, boolean do_compute_clusters, boolean show_bucket_tree) {
        if (!do_compute_clusters || this.qbi == null || !this.qbi.areClustersProduced()) {
            this.qbi = new QBInference(this.get_bayes_net(), do_compute_clusters);
        }
        this.qbi.inference(queried_variable);
        this.qbi.print(pstream, show_bucket_tree);
    }

    public void reset_marginal() {
        this.qbi = null;
    }

    public void print_expectation(PrintStream pstream, String queried_variable, boolean do_compute_clusters, boolean show_bucket_tree) {
        if (!do_compute_clusters || this.qbe == null || !this.qbi.areClustersProduced()) {
            this.qbe = new QBExpectation(this.get_bayes_net(), do_compute_clusters);
        }
        this.qbe.expectation(queried_variable);
        this.qbe.print(pstream, show_bucket_tree);
    }

    public void reset_expectation() {
        this.qbe = null;
    }

    public void print_explanation(PrintStream pstream, boolean show_bucket_tree) {
        Explanation ex = new Explanation(this.get_bayes_net());
        ex.explanation();
        ex.print(pstream, show_bucket_tree);
    }

    public void print_full_explanation(PrintStream pstream, boolean show_bucket_tree) {
        Explanation fex = new Explanation(this.get_bayes_net());
        fex.full_explanation();
        fex.print(pstream, show_bucket_tree);
    }

    public void print_sensitivity_analysis(PrintStream pstream) {
        System.out.print("HEY! Sensitivity analysis not implemented yet!");
    }

    public void save_bif(PrintStream out) {
        QuasiBayesNet qb_n = this.get_bayes_net();
        qb_n.save_bif(out);
    }

    public void save_xml(PrintStream out) {
        QuasiBayesNet qb_n = this.get_bayes_net();
        qb_n.save_xml(out);
    }

    public void save_bugs(PrintStream out) {
        QuasiBayesNet qb_n = this.get_bayes_net();
        qb_n.save_bugs(out);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        QuasiBayesNet qb_n = this.get_bayes_net();
        qb_n.print(out);
    }

    public Vector get_nodes() {
        return this.nodes;
    }

    public Enumeration elements() {
        return this.nodes.elements();
    }

    public int number_nodes() {
        return this.nodes.size();
    }

    public void create_node(int x, int y) {
        Point p = new Point(x, y);
        String n = this.generate_name(this.nodes.size());
        this.nodes.addElement(new InferenceGraphNode(this, n, p));
        this.convert_graph();
    }

    public boolean create_arc(InferenceGraphNode parent, InferenceGraphNode child) {
        Enumeration e = child.parents.elements();
        while (e.hasMoreElements()) {
            if (parent != (InferenceGraphNode)e.nextElement()) continue;
            return false;
        }
        parent.children.addElement(child);
        child.parents.addElement(parent);
        child.init_dists();
        this.convert_graph();
        return true;
    }

    public void delete_node(InferenceGraphNode node) {
        Enumeration e = node.children.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode child = (InferenceGraphNode)e.nextElement();
            child.parents.removeElement(node);
            child.init_dists();
        }
        e = node.parents.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode parent = (InferenceGraphNode)e.nextElement();
            parent.children.removeElement(node);
        }
        this.nodes.removeElement(node);
        this.convert_graph();
    }

    public void delete_arc(InferenceGraphNode parent, InferenceGraphNode child) {
        parent.children.removeElement(child);
        child.parents.removeElement(parent);
        child.init_dists();
        this.convert_graph();
    }

    public boolean hasCycle(InferenceGraphNode bottom_node, InferenceGraphNode head_node) {
        InferenceGraphNode[] listed_nodes = new InferenceGraphNode[this.nodes.size()];
        Hashtable<String, InferenceGraphNode> hashed_nodes = new Hashtable<String, InferenceGraphNode>();
        int last_listed_node_index = 0;
        int current_listed_node_index = 0;
        listed_nodes[0] = head_node;
        hashed_nodes.put(head_node.pv.get_name(), head_node);
        while (current_listed_node_index <= last_listed_node_index) {
            InferenceGraphNode next_node = listed_nodes[current_listed_node_index];
            ++current_listed_node_index;
            Vector children = next_node.children;
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                InferenceGraphNode child_node = (InferenceGraphNode)e.nextElement();
                if (child_node == bottom_node) {
                    return true;
                }
                if (hashed_nodes.containsKey(child_node.pv.get_name())) continue;
                hashed_nodes.put(child_node.pv.get_name(), child_node);
                listed_nodes[++last_listed_node_index] = child_node;
            }
        }
        return false;
    }

    public void change_values(InferenceGraphNode node, String[] values) {
        if (node.pv.number_values() == values.length) {
            node.pv.set_values(values);
            return;
        }
        node.pv.set_values(values);
        node.init_dists();
        Vector children = node.get_children();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode cnode = (InferenceGraphNode)e.nextElement();
            cnode.init_dists();
        }
        this.convert_graph();
    }

    public void set_pos(InferenceGraphNode node, Point position) {
        node.pos = position;
        this.convert_graph();
    }
}

