/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.DiscreteFunction;
import CredalSets.TwoMonotoneCapacity;
import java.util.Enumeration;
import java.util.Vector;

public class GeneralizedChoquetIntegral {
    double[] results = new double[2];

    public GeneralizedChoquetIntegral(TwoMonotoneCapacity tmc, DiscreteFunction df) {
        int i;
        Vector positive = this.sort_positive(df);
        Vector negative = this.sort_negative(df);
        double[] df_positive = new double[positive.size() - 1];
        for (i = 1; i <= df_positive.length; ++i) {
            df_positive[i - 1] = (Double)positive.elementAt(i) - (Double)positive.elementAt(i - 1);
        }
        double[] df_negative = new double[negative.size() - 1];
        for (i = 1; i <= df_negative.length; ++i) {
            df_negative[i - 1] = (Double)negative.elementAt(i) - (Double)negative.elementAt(i - 1);
        }
        double[] lp_positive = new double[df_positive.length];
        double[] up_positive = new double[df_positive.length];
        this.bound_positive(tmc, df, positive, lp_positive, up_positive);
        double[] lp_negative = new double[df_negative.length];
        double[] up_negative = new double[df_negative.length];
        this.bound_negative(tmc, df, negative, lp_negative, up_negative);
        double positive_side = 0.0;
        double negative_side = 0.0;
        for (i = 0; i < df_positive.length; ++i) {
            positive_side += df_positive[i] * lp_positive[i];
        }
        for (i = 0; i < df_negative.length; ++i) {
            negative_side += df_negative[i] * up_negative[i];
        }
        this.results[0] = positive_side + negative_side;
        positive_side = 0.0;
        negative_side = 0.0;
        for (i = 0; i < df_positive.length; ++i) {
            positive_side += df_positive[i] * up_positive[i];
        }
        for (i = 0; i < df_negative.length; ++i) {
            negative_side += df_negative[i] * lp_negative[i];
        }
        this.results[1] = positive_side + negative_side;
    }

    private Vector sort_positive(DiscreteFunction df) {
        Vector<Double> sorted = new Vector<Double>();
        sorted.addElement(new Double(0.0));
        for (int i = 0; i < df.number_values(); ++i) {
            if (df.get_value(i) <= 0.0) continue;
            for (int j = 0; j < sorted.size(); ++j) {
                if (!(df.get_value(i) < (Double)sorted.elementAt(j))) continue;
                sorted.addElement(new Double(df.get_value(i)));
            }
            sorted.insertElementAt(new Double(df.get_value(i)), sorted.size());
        }
        return sorted;
    }

    private Vector sort_negative(DiscreteFunction df) {
        Vector<Double> sorted = new Vector<Double>();
        sorted.addElement(new Double(0.0));
        for (int i = 0; i < df.number_values(); ++i) {
            if (df.get_value(i) >= 0.0) continue;
            for (int j = 0; j < sorted.size(); ++j) {
                if (!(df.get_value(i) > (Double)sorted.elementAt(j))) continue;
                sorted.addElement(new Double(df.get_value(i)));
            }
            sorted.insertElementAt(new Double(df.get_value(i)), sorted.size());
        }
        return sorted;
    }

    private void bound_positive(TwoMonotoneCapacity tmc, DiscreteFunction df, Vector sorted_values, double[] lps, double[] ups) {
        Enumeration e = sorted_values.elements();
        for (int i = 0; i < sorted_values.size() - 1; ++i) {
            double lp = 0.0;
            double sorted_value = (Double)e.nextElement();
            for (int j = 0; j < df.number_values(); ++j) {
                if (!(df.get_value(j) > sorted_value)) continue;
                lp += tmc.get_atom_probability(j);
            }
            lps[i] = tmc.get_lower_probability_from_base(lp);
            ups[i] = tmc.get_upper_probability_from_base(lp);
        }
    }

    private void bound_negative(TwoMonotoneCapacity tmc, DiscreteFunction df, Vector sorted_values, double[] lps, double[] ups) {
        Enumeration e = sorted_values.elements();
        for (int i = 0; i < sorted_values.size() - 1; ++i) {
            double lp = 0.0;
            double sorted_value = (Double)e.nextElement();
            for (int j = 0; j < df.number_values(); ++j) {
                if (!(df.get_value(j) < sorted_value)) continue;
                lp += tmc.get_atom_probability(j);
            }
            lps[i] = tmc.get_lower_probability_from_base(lp);
            ups[i] = tmc.get_upper_probability_from_base(lp);
        }
    }
}

