/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianInferences.Bucket;
import BayesianInferences.BucketTree;
import BayesianInferences.Ordering;
import BayesianNetworks.BayesNet;
import BayesianNetworks.ProbabilityFunction;
import java.io.PrintStream;
import java.util.Vector;

public class Inference {
    protected BayesNet bn;
    protected BucketTree bucket_tree;
    protected Bucket[] bucket_for_variable;
    protected Vector bucket_forest;
    protected ProbabilityFunction result;
    protected boolean do_produce_clusters;
    protected static final int IGNORE_EXPLANATION = 0;
    protected static final int EXPLANATION = 1;
    protected static final int FULL_EXPLANATION = 2;

    public Inference(BayesNet b_n, boolean dpc) {
        this.bn = b_n;
        this.bucket_for_variable = new Bucket[b_n.number_variables()];
        this.bucket_forest = new Vector();
        this.do_produce_clusters = dpc;
    }

    public void inference() {
        this.inference((String)null);
    }

    protected void inference(String queried_variable_name) {
        if (this.do_produce_clusters) {
            int index_queried = this.bn.index_of_variable(queried_variable_name);
            if (index_queried != -1) {
                Bucket buck = this.bucket_for_variable[index_queried];
                if (buck == null || buck.cluster == null) {
                    this.inference(new Ordering(this.bn, queried_variable_name, 0, 2));
                } else {
                    this.bucket_tree = buck.bucket_tree;
                    if (buck.bucket_status != 2) {
                        if (buck == this.bucket_tree.bucket_tree[this.bucket_tree.bucket_tree.length - 1]) {
                            this.bucket_tree.reduce();
                        } else {
                            this.bucket_tree.distribute();
                        }
                    }
                    System.out.println("ARRIVED HERE!");
                    buck.reduce_cluster();
                    System.out.println("AND HERE TOO!");
                    this.result = this.bucket_tree.get_normalized_result();
                }
            } else {
                this.inference(new Ordering(this.bn, null, 0, 2));
            }
        } else {
            this.inference(new Ordering(this.bn, queried_variable_name, 0, 2));
        }
    }

    protected void inference(String[] order) {
        this.inference(new Ordering(this.bn, order, 0));
    }

    private void inference(Ordering or) {
        this.bucket_tree = new BucketTree(or, this.do_produce_clusters);
        if (this.do_produce_clusters) {
            this.add_bucket_tree();
        }
        this.bucket_tree.reduce();
        this.result = this.bucket_tree.get_normalized_result();
    }

    private void add_bucket_tree() {
        this.bucket_forest.addElement(this.bucket_tree);
        for (int i = 0; i < this.bucket_tree.bucket_tree.length; ++i) {
            Bucket buck;
            this.bucket_for_variable[buck.variable.get_index()] = buck = this.bucket_tree.bucket_tree[i];
        }
    }

    public void print() {
        this.print(System.out, true);
    }

    public void print(PrintStream out) {
        this.print(out, true);
    }

    public void print(boolean should_print_bucket_tree) {
        this.print(System.out, should_print_bucket_tree);
    }

    public void print(PrintStream out, boolean should_print_bucket_tree) {
        if (this.result == null) {
            this.inference();
        }
        out.print("Posterior distribution:");
        if (should_print_bucket_tree) {
            this.bucket_tree.print(out);
        }
        out.println();
        this.result.print(out);
    }

    public BucketTree get_bucket_tree() {
        return this.bucket_tree;
    }

    public BayesNet get_bayes_net() {
        return this.bn;
    }

    public ProbabilityFunction get_result() {
        return this.result;
    }

    public boolean areClustersProduced() {
        return this.do_produce_clusters;
    }
}

