/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mapdb.Serializer;

public interface Engine
extends Closeable {
    public static final long RECID_NAME_CATALOG = 1L;
    public static final long RECID_CLASS_CATALOG = 2L;
    public static final long RECID_RECORD_CHECK = 3L;
    public static final long RECID_LAST_RESERVED = 7L;
    public static final long RECID_FIRST = 8L;
    public static final Engine CLOSED_ENGINE = new Engine(){

        @Override
        public long preallocate() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void close() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        public void commit() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void rollback() throws UnsupportedOperationException {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean isReadOnly() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean canRollback() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean canSnapshot() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public Engine snapshot() throws UnsupportedOperationException {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public Engine getWrappedEngine() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void clearCache() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void compact() {
            throw new IllegalAccessError("already closed");
        }
    };

    public long preallocate();

    public <A> long put(A var1, Serializer<A> var2);

    public <A> A get(long var1, Serializer<A> var3);

    public <A> void update(long var1, A var3, Serializer<A> var4);

    public <A> boolean compareAndSwap(long var1, A var3, A var4, Serializer<A> var5);

    public <A> void delete(long var1, Serializer<A> var3);

    @Override
    public void close();

    public boolean isClosed();

    public void commit();

    public void rollback() throws UnsupportedOperationException;

    public boolean isReadOnly();

    public boolean canRollback();

    public boolean canSnapshot();

    public Engine snapshot() throws UnsupportedOperationException;

    public Engine getWrappedEngine();

    public void clearCache();

    public void compact();

    public static class CloseOnJVMShutdown
    implements Engine {
        protected final AtomicBoolean shutdownHappened = new AtomicBoolean(false);
        final Runnable hookRunnable = new Runnable(){

            @Override
            public void run() {
                CloseOnJVMShutdown.this.shutdownHappened.set(true);
                CloseOnJVMShutdown.this.hook = null;
                if (CloseOnJVMShutdown.this.isClosed()) {
                    return;
                }
                CloseOnJVMShutdown.this.close();
            }
        };
        protected final Engine engine;
        protected Thread hook;

        public CloseOnJVMShutdown(Engine engine) {
            this.engine = engine;
            this.hook = new Thread(this.hookRunnable, "MapDB shutdown hook");
            Runtime.getRuntime().addShutdownHook(this.hook);
        }

        @Override
        public long preallocate() {
            return this.engine.preallocate();
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            return this.engine.put(value, serializer);
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            return this.engine.get(recid, serializer);
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            this.engine.update(recid, value, serializer);
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            return this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            this.engine.delete(recid, serializer);
        }

        @Override
        public void close() {
            this.engine.close();
            if (!this.shutdownHappened.get() && this.hook != null) {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
            this.hook = null;
        }

        @Override
        public boolean isClosed() {
            return this.engine.isClosed();
        }

        @Override
        public void commit() {
            this.engine.commit();
        }

        @Override
        public void rollback() throws UnsupportedOperationException {
            this.engine.rollback();
        }

        @Override
        public boolean isReadOnly() {
            return this.engine.isReadOnly();
        }

        @Override
        public boolean canRollback() {
            return this.engine.canRollback();
        }

        @Override
        public boolean canSnapshot() {
            return this.engine.canSnapshot();
        }

        @Override
        public Engine snapshot() throws UnsupportedOperationException {
            return this.engine.snapshot();
        }

        @Override
        public Engine getWrappedEngine() {
            return this.engine;
        }

        @Override
        public void clearCache() {
            this.engine.clearCache();
        }

        @Override
        public void compact() {
            this.engine.compact();
        }
    }

    public static final class ReadOnlyWrapper
    extends ReadOnly {
        protected final Engine engine;

        public ReadOnlyWrapper(Engine engine) {
            this.engine = engine;
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            return this.engine.get(recid, serializer);
        }

        @Override
        public void close() {
            this.engine.close();
        }

        @Override
        public boolean isClosed() {
            return this.engine.isClosed();
        }

        @Override
        public boolean canRollback() {
            return this.engine.canRollback();
        }

        @Override
        public Engine getWrappedEngine() {
            return this.engine;
        }

        @Override
        public void clearCache() {
            this.engine.clearCache();
        }

        @Override
        public boolean canSnapshot() {
            return this.engine.canSnapshot();
        }

        @Override
        public Engine snapshot() throws UnsupportedOperationException {
            return this.engine.snapshot();
        }
    }

    public static abstract class ReadOnly
    implements Engine {
        @Override
        public long preallocate() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void commit() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void rollback() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void compact() {
            throw new UnsupportedOperationException("Read-only");
        }
    }
}

