/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Locks;
import org.mapdb.LongConcurrentLRUMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;

public class CacheLRU
extends EngineWrapper {
    protected static final Object NULL = new Object();
    protected LongMap<Object> cache;
    protected final Locks.RecidLocks locks = new Locks.SegmentedRecidLocks(16);

    public CacheLRU(Engine engine, int cacheSize) {
        this(engine, new LongConcurrentLRUMap<Object>(cacheSize, (int)((double)cacheSize * 0.8)));
    }

    public CacheLRU(Engine engine, LongMap<Object> cache) {
        super(engine);
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = super.put(value, serializer);
        try {
            this.locks.lock(recid);
            this.cache.put(recid, value != null ? value : NULL);
        }
        finally {
            this.locks.unlock(recid);
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        Object ret = this.cache.get(recid);
        if (ret != null) {
            return (A)(ret == NULL ? null : ret);
        }
        try {
            this.locks.lock(recid);
            ret = super.get(recid, serializer);
            if (ret != null) {
                this.cache.put(recid, ret);
            }
            Object object = ret;
            return (A)object;
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            this.locks.lock(recid);
            this.cache.put(recid, value == null ? NULL : value);
            super.update(recid, value, serializer);
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long recid) {
        try {
            this.locks.lock(recid);
            this.cache.remove(recid);
            super.delete(recid);
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        try {
            this.locks.lock(recid);
            Object oldValue = this.cache.get(recid);
            if (oldValue != null && (oldValue == expectedOldValue || oldValue.equals(expectedOldValue) || oldValue == NULL && newValue == null)) {
                this.cache.put(recid, newValue == null ? NULL : newValue);
                this.engine.update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean ret = this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                this.cache.put(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    @Override
    public void close() {
        if (this.cache instanceof LongConcurrentLRUMap) {
            ((LongConcurrentLRUMap)this.cache).destroy();
        }
        this.cache = null;
        super.close();
    }

    @Override
    public void rollback() {
        this.cache.clear();
        super.rollback();
    }
}

