/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.Atomic;
import org.mapdb.Fun;

public final class Bind {
    private Bind() {
    }

    public static <K, V> void size(MapWithModificationListener<K, V> map, final Atomic.Long sizeCounter) {
        if (sizeCounter.get() == 0L) {
            long size = map.sizeLong();
            if (sizeCounter.get() != size) {
                sizeCounter.set(size);
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (oldVal == null && newVal != null) {
                    sizeCounter.incrementAndGet();
                } else if (oldVal != null && newVal == null) {
                    sizeCounter.decrementAndGet();
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValue(MapWithModificationListener<K, V> map, final Map<K, V2> secondary, final Fun.Function2<V2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(e.getKey(), fun.run(e.getKey(), e.getValue()));
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(key);
                } else {
                    secondary.put(key, fun.run(key, newVal));
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValues(MapWithModificationListener<K, V> map, final Set<Object[]> secondary, final Fun.Function2<V2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                V2[] v = fun.run(e.getKey(), e.getValue());
                if (v == null) continue;
                for (V2 v2 : v) {
                    secondary.add(new Object[]{e.getKey(), v2});
                }
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                block11: {
                    block12: {
                        block10: {
                            if (newVal != null) break block10;
                            Object[] v = (Object[])fun.run(key, oldVal);
                            if (v == null) break block11;
                            for (Object v2 : v) {
                                secondary.remove(new Object[]{key, v2});
                            }
                            break block11;
                        }
                        if (oldVal != null) break block12;
                        Object[] v = (Object[])fun.run(key, newVal);
                        if (v == null) break block11;
                        for (Object v2 : v) {
                            secondary.add(new Object[]{key, v2});
                        }
                        break block11;
                    }
                    Object[] oldv = (Object[])fun.run(key, oldVal);
                    Object[] newv = (Object[])fun.run(key, newVal);
                    if (oldv == null) {
                        if (newv != null) {
                            for (Object v : newv) {
                                secondary.add(new Object[]{key, v});
                            }
                        }
                        return;
                    }
                    if (newv == null) {
                        for (Object v : oldv) {
                            secondary.remove(new Object[]{key, v});
                        }
                        return;
                    }
                    HashSet hashes = new HashSet();
                    Collections.addAll(hashes, oldv);
                    for (Object v : newv) {
                        if (hashes.contains(v)) continue;
                        secondary.add(new Object[]{key, v});
                    }
                    for (Object v : newv) {
                        hashes.remove(v);
                    }
                    for (Object v : hashes) {
                        secondary.remove(new Object[]{key, v});
                    }
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final Set<Object[]> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.add(new Object[]{fun.run(e.getKey(), e.getValue()), e.getKey()});
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(new Object[]{fun.run(key, oldVal), key});
                } else if (oldVal == null) {
                    secondary.add(new Object[]{fun.run(key, newVal), key});
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(new Object[]{oldKey, key});
                    secondary.add(new Object[]{newKey, key});
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final Map<K2, K> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(fun.run(e.getKey(), e.getValue()), e.getKey());
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(fun.run(key, oldVal));
                } else if (oldVal == null) {
                    secondary.put(fun.run(key, newVal), key);
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(oldKey);
                    secondary.put(newKey, key);
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKeys(MapWithModificationListener<K, V> map, final Set<Object[]> secondary, final Fun.Function2<K2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                K2[] k2 = fun.run(e.getKey(), e.getValue());
                if (k2 == null) continue;
                for (K2 k22 : k2) {
                    secondary.add(new Object[]{k22, e.getKey()});
                }
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                block11: {
                    block12: {
                        block10: {
                            if (newVal != null) break block10;
                            Object[] k2 = (Object[])fun.run(key, oldVal);
                            if (k2 == null) break block11;
                            for (Object k22 : k2) {
                                secondary.remove(new Object[]{k22, key});
                            }
                            break block11;
                        }
                        if (oldVal != null) break block12;
                        Object[] k2 = (Object[])fun.run(key, newVal);
                        if (k2 == null) break block11;
                        for (Object k22 : k2) {
                            secondary.add(new Object[]{k22, key});
                        }
                        break block11;
                    }
                    Object[] oldk = (Object[])fun.run(key, oldVal);
                    Object[] newk = (Object[])fun.run(key, newVal);
                    if (oldk == null) {
                        if (newk != null) {
                            for (Object k22 : newk) {
                                secondary.add(new Object[]{k22, key});
                            }
                        }
                        return;
                    }
                    if (newk == null) {
                        for (Object k22 : oldk) {
                            secondary.remove(new Object[]{k22, key});
                        }
                        return;
                    }
                    HashSet hashes = new HashSet();
                    Collections.addAll(hashes, oldk);
                    for (Object k2 : newk) {
                        if (hashes.contains(k2)) continue;
                        secondary.add(new Object[]{k2, key});
                    }
                    for (Object k2 : newk) {
                        hashes.remove(k2);
                    }
                    for (Object k2 : hashes) {
                        secondary.remove(new Object[]{k2, key});
                    }
                }
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Set<Object[]> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Map<V, K> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V, C> void histogram(MapWithModificationListener<K, V> primary, final ConcurrentMap<C, Long> histogram, final Fun.Function2<C, K, V> entryToCategory) {
        MapListener listener = new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    Object category = entryToCategory.run(key, oldVal);
                    this.incrementHistogram(category, -1L);
                } else if (oldVal == null) {
                    Object category = entryToCategory.run(key, newVal);
                    this.incrementHistogram(category, 1L);
                } else {
                    Object newCat;
                    Object oldCat = entryToCategory.run(key, oldVal);
                    if (oldCat == (newCat = entryToCategory.run(key, newVal)) || oldCat.equals(newCat)) {
                        return;
                    }
                    this.incrementHistogram(oldCat, -1L);
                    this.incrementHistogram(newCat, 1L);
                }
            }

            private void incrementHistogram(C category, long i) {
                Long oldCount = (Long)histogram.get(category);
                if (oldCount == null && histogram.putIfAbsent(category, i) == null) {
                    return;
                }
                Long newCount = oldCount + i;
                while (!histogram.replace(category, oldCount, newCount)) {
                    newCount = (Long)histogram.get(category) + i;
                }
            }
        };
        primary.modificationListenerAdd(listener);
        if (histogram.isEmpty()) {
            for (Map.Entry e : primary.entrySet()) {
                listener.update(e.getKey(), null, e.getValue());
            }
        }
    }

    public static <K, V> void mapPutAfterDelete(MapWithModificationListener<K, V> primary, final MapWithModificationListener<K, V> secondary, final boolean overwriteSecondary) {
        primary.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    if (overwriteSecondary) {
                        secondary.put(key, oldVal);
                    } else {
                        secondary.putIfAbsent(key, oldVal);
                    }
                }
            }
        });
    }

    public static interface MapWithModificationListener<K, V>
    extends ConcurrentMap<K, V> {
        public void modificationListenerAdd(MapListener<K, V> var1);

        public void modificationListenerRemove(MapListener<K, V> var1);

        public long sizeLong();
    }

    public static interface MapListener<K, V> {
        public void update(K var1, V var2, V var3);
    }
}

