/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class ParallelEdgeRouter
extends DefaultEdge.LoopRouting {
    protected static final ParallelEdgeRouter sharedInstance = new ParallelEdgeRouter();
    private static double edgeSeparation = 10.0;
    private static double edgeDeparture = 10.0;

    public static ParallelEdgeRouter getSharedInstance() {
        return sharedInstance;
    }

    @Override
    public List routeEdge(GraphLayoutCache cache, EdgeView edge) {
        ArrayList newPoints = new ArrayList();
        CellView nodeFrom = edge.getSource();
        CellView nodeTo = edge.getTarget();
        if (null == nodeFrom) {
            nodeFrom = edge.getSourceParentView();
        }
        if (null == nodeTo) {
            nodeTo = edge.getTargetParentView();
        }
        if (null == nodeFrom || null == nodeTo) {
            return null;
        }
        if (nodeFrom == nodeTo) {
            return null;
        }
        List points = edge.getPoints();
        Object startPort = points.get(0);
        Object endPort = points.get(points.size() - 1);
        newPoints.add(startPort);
        Object[] edges = this.getParallelEdges(cache, edge, nodeFrom, nodeTo);
        if (edges == null) {
            return null;
        }
        if (edges.length >= 2) {
            Point2D perimeterPoint;
            int position = 0;
            for (int i = 0; i < edges.length; ++i) {
                Object e = edges[i];
                if (e != edge.getCell()) continue;
                position = i + 1;
            }
            Point2D point2D = perimeterPoint = edge.getTarget() != null ? edge.getPoint(edge.getPointCount() - 1) : AbstractCellView.getCenterPoint(nodeTo);
            if (perimeterPoint == null) {
                perimeterPoint = AbstractCellView.getCenterPoint(nodeTo);
            }
            Point2D from = edge.getSource() == null || edge.getSource().getParentView() == null ? nodeFrom.getPerimeterPoint(edge, AbstractCellView.getCenterPoint(nodeFrom), perimeterPoint) : edge.getSource().getParentView().getPerimeterPoint(edge, AbstractCellView.getCenterPoint(edge.getSource().getParentView()), edge.getTarget() != null && edge.getTarget().getParentView() != null ? AbstractCellView.getCenterPoint(edge.getTarget().getParentView()) : AbstractCellView.getCenterPoint(nodeTo));
            Point2D to = edge.getTarget() == null || edge.getTarget().getParentView() == null ? nodeTo.getPerimeterPoint(edge, AbstractCellView.getCenterPoint(nodeTo), from) : edge.getTarget().getParentView().getPerimeterPoint(edge, AbstractCellView.getCenterPoint(edge.getTarget().getParentView()), from);
            if (from != null && to != null) {
                AttributeMap allAttributes;
                double x;
                double dy = from.getY() - to.getY();
                double dx = from.getX() - to.getX();
                if (dy == 0.0 && dx == 0.0) {
                    return null;
                }
                double theta = 0.0;
                if (dy == 0.0) {
                    theta = 1.5707963267948966;
                } else if (dx == 0.0) {
                    theta = 0.0;
                } else {
                    double m = dy / dx;
                    theta = Math.atan(-1.0 / m);
                }
                double length = Math.sqrt(dx * dx + dy * dy);
                double rx = dx / length;
                double ry = dy / length;
                double sizeFrom = Math.max(nodeFrom.getBounds().getWidth(), nodeFrom.getBounds().getHeight()) / 2.0;
                double sizeTo = Math.max(nodeTo.getBounds().getWidth(), nodeTo.getBounds().getHeight()) / 2.0;
                double edgeMiddleDeparture = (Math.sqrt(dx * dx + dy * dy) - sizeFrom - sizeTo) / 2.0 + sizeFrom;
                double edgeFromDeparture = edgeDeparture + sizeFrom;
                double edgeToDeparture = edgeDeparture + sizeTo;
                double r = edgeSeparation * Math.floor(position / 2);
                if (0 == position % 2) {
                    r = -r;
                }
                double ex = r * Math.cos(theta);
                double ey = r * Math.sin(theta);
                if (edgeMiddleDeparture <= edgeFromDeparture) {
                    double midX = from.getX() - rx * edgeMiddleDeparture;
                    double midY = from.getY() - ry * edgeMiddleDeparture;
                    Point2D.Double controlPoint = new Point2D.Double(ex + midX, ey + midY);
                    newPoints.add(controlPoint);
                } else {
                    double midXFrom = from.getX() - rx * edgeFromDeparture;
                    double midYFrom = from.getY() - ry * edgeFromDeparture;
                    double midXTo = to.getX() + rx * edgeToDeparture;
                    double midYTo = to.getY() + ry * edgeToDeparture;
                    Point2D.Double controlPointFrom = new Point2D.Double(ex + midXFrom, ey + midYFrom);
                    Point2D.Double controlPointTo = new Point2D.Double(ex + midXTo, ey + midYTo);
                    newPoints.add(controlPointFrom);
                    newPoints.add(controlPointTo);
                }
                Point2D labelPos = edge.getLabelPosition();
                if (labelPos != null && (x = labelPos.getX()) == 500.0 && (allAttributes = edge.getAllAttributes()) != null) {
                    int lineStyle;
                    if (dy < 0.0) {
                        r = -r;
                    }
                    if ((lineStyle = this.getPreferredLineStyle(edge)) == -1) {
                        lineStyle = GraphConstants.getLineStyle(allAttributes);
                    }
                    if (lineStyle == 12 || lineStyle == 13) {
                        GraphConstants.setLabelPosition(allAttributes, new Point2D.Double(x, r * edgeMiddleDeparture / 79.0));
                    } else {
                        GraphConstants.setExactSegmentLabel(allAttributes, true);
                    }
                }
            }
        }
        newPoints.add(endPort);
        return newPoints;
    }

    public static double getEdgeSeparation() {
        return edgeSeparation;
    }

    public static void setEdgeSeparation(double edgeSeparation) {
        ParallelEdgeRouter.edgeSeparation = edgeSeparation;
    }

    public static double getEdgeDeparture() {
        return edgeDeparture;
    }

    public static void setEdgeDeparture(double edgeDeparture) {
        ParallelEdgeRouter.edgeDeparture = edgeDeparture;
    }

    protected Object[] getParallelEdges(GraphLayoutCache cache, EdgeView edge, CellView cellView1, CellView cellView2) {
        GraphModel model = cache.getModel();
        Object cell1 = cellView1.getCell();
        Object cell2 = cellView2.getCell();
        Object[] roots = DefaultGraphModel.getRoots(model);
        if (roots.length == 0) {
            return null;
        }
        Object[] cells = new Object[]{cell1, cell2};
        if ((cells = DefaultGraphModel.order(model, cells)) == null || cells.length < 2) {
            return null;
        }
        cell1 = cells[0];
        cell2 = cells[1];
        while (model.getParent(cell1) != null && !cache.isVisible(cell1)) {
            cell1 = model.getParent(cell1);
        }
        while (model.getParent(cell2) != null && !cache.isVisible(cell2)) {
            cell2 = model.getParent(cell2);
        }
        List cell1Children = DefaultGraphModel.getDescendants(model, new Object[]{cell1});
        ArrayList<Object> cells1 = new ArrayList<Object>();
        cells1.add(cell1);
        for (Object childCell : cell1Children) {
            if (!DefaultGraphModel.isVertex(model, childCell) || cache.isVisible(childCell)) continue;
            cells1.add(childCell);
        }
        List cell2Children = DefaultGraphModel.getDescendants(model, new Object[]{cell2});
        ArrayList<Object> cells2 = new ArrayList<Object>();
        cells2.add(cell2);
        for (Object childCell : cell2Children) {
            if (!DefaultGraphModel.isVertex(model, childCell) || cache.isVisible(childCell)) continue;
            cells2.add(childCell);
        }
        if (cells1.size() == 1 && cells2.size() == 1) {
            return DefaultGraphModel.getEdgesBetween(model, cell1, cell2, false);
        }
        Object[] edgesBetween = null;
        for (Object e : cells1) {
            for (Object e2 : cells2) {
                Object[] edges = DefaultGraphModel.getEdgesBetween(model, e, e2, false);
                if (edges.length <= 0) continue;
                if (edgesBetween == null) {
                    edgesBetween = edges;
                    continue;
                }
                Object[] newArray = new Object[edges.length + edgesBetween.length];
                System.arraycopy(edgesBetween, 0, newArray, 0, edgesBetween.length);
                System.arraycopy(edges, 0, newArray, edgesBetween.length, edges.length);
                edgesBetween = newArray;
            }
        }
        return edgesBetween;
    }

    public static void setGraph(JGraph graph) {
    }
}

