/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Bezier {
    private static final float AP = 0.5f;
    private Point2D[] bPoints;

    public Bezier(Point2D[] points) {
        int n = points.length;
        if (n < 3) {
            return;
        }
        this.bPoints = new Point[2 * (n - 2)];
        double pbX = points[0].getX();
        double pbY = points[0].getY();
        double pcX = points[1].getX();
        double pcY = points[1].getY();
        for (int i = 0; i < n - 2; ++i) {
            double lac;
            double proj;
            double paX = pbX;
            double paY = pbY;
            pbX = pcX;
            pbY = pcY;
            pcX = points[i + 2].getX();
            pcY = points[i + 2].getY();
            double abX = pbX - paX;
            double abY = pbY - paY;
            double acX = pcX - paX;
            double acY = pcY - paY;
            proj = (proj = abX * (acX /= (lac = Math.sqrt(acX * acX + acY * acY))) + abY * (acY /= lac)) < 0.0 ? -proj : proj;
            double apX = proj * acX;
            double apY = proj * acY;
            double p1X = pbX - 0.5 * apX;
            double p1Y = pbY - 0.5 * apY;
            this.bPoints[2 * i] = new Point((int)p1X, (int)p1Y);
            acX = -acX;
            acY = -acY;
            double cbX = pbX - pcX;
            double cbY = pbY - pcY;
            proj = cbX * acX + cbY * acY;
            proj = proj < 0.0 ? -proj : proj;
            apX = proj * acX;
            apY = proj * acY;
            double p2X = pbX - 0.5 * apX;
            double p2Y = pbY - 0.5 * apY;
            this.bPoints[2 * i + 1] = new Point((int)p2X, (int)p2Y);
        }
    }

    public Point2D[] getPoints() {
        return this.bPoints;
    }

    public int getPointCount() {
        return this.bPoints.length;
    }

    public Point2D getPoint(int i) {
        return this.bPoints[i];
    }
}

